/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.positionterminal.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.positionterminal.mapper.MdmPositionTerminalMapper;
import com.biz.crm.positionterminal.model.MdmPositionTerminalEntity;
import com.biz.crm.positionterminal.service.MdmPositionTerminalService;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmPositionTerminalServiceExpandImpl"})
public class MdmPositionTerminalServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPositionTerminalMapper, MdmPositionTerminalEntity>
implements MdmPositionTerminalService {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionTerminalServiceImpl.class);

    @Override
    public List<String> findTerminalCodeByPositionCode(List<String> positionCodeList) {
        if (CollectionUtils.isEmpty(positionCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionTerminalEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionTerminalEntity::getTerminalCode}).list().stream().map(MdmPositionTerminalEntity::getTerminalCode).collect(Collectors.toList());
    }

    @Override
    public List<String> findPositionCodeByTerminalCode(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionTerminalEntity::getTerminalCode, terminalCodeList)).select(new SFunction[]{MdmPositionTerminalEntity::getPositionCode}).list().stream().map(MdmPositionTerminalEntity::getPositionCode).collect(Collectors.toList());
    }
}

