/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.positionuser.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.positionuser.mapper.MdmPositionUserMapper;
import com.biz.crm.positionuser.model.MdmPositionUserEntity;
import com.biz.crm.positionuser.service.IMdmPositionUserService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmPositionUserServiceExpandImpl"})
@Transactional(rollbackFor={Exception.class})
public class MdmPositionUserServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPositionUserMapper, MdmPositionUserEntity>
implements IMdmPositionUserService {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionUserServiceImpl.class);
    @Resource
    private MdmPositionUserMapper mdmPositionUserMapper;

    @Override
    public void addUserPositions(String userName, List<String> positionCodes) {
        if (StringUtils.isNotEmpty((String)userName) && CollectionUtil.listEmpty(positionCodes)) {
            positionCodes.forEach(positionCode -> this.addUserPosition(userName, (String)positionCode));
        }
    }

    @Override
    public void addUserPosition(String userName, String positionCode) {
        List list;
        if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)positionCode) && CollectionUtil.listEmpty((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionUserEntity::getUserName, (Object)userName)).eq(MdmPositionUserEntity::getPositionCode, (Object)positionCode)).list()))) {
            MdmPositionUserEntity entity = new MdmPositionUserEntity();
            entity.setPositionCode(positionCode);
            entity.setUserName(userName);
            this.save((Object)entity);
        }
    }

    @Override
    public void removePositionCode(String positionCode) {
        if (StringUtils.isNotEmpty((String)positionCode)) {
            this.removePositionCodes(Collections.singletonList(positionCode));
        }
    }

    @Override
    public void removePositionCodes(List<String> positionCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodes)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionUserEntity::getPositionCode, positionCodes)).remove();
        }
    }

    @Override
    public void removeUser(String userName) {
        if (StringUtils.isNotEmpty((String)userName)) {
            this.removeUsers(Collections.singletonList(userName));
        }
    }

    @Override
    public void removeUsers(List<String> userNames) {
        if (CollectionUtil.listNotEmptyNotSizeZero(userNames)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionUserEntity::getUserName, userNames)).remove();
        }
    }
}

