/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pricesetting.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.eunm.mdm.PriceSettingFieldEnum;
import com.biz.crm.eunm.mdm.PriceSettingStatusEnum;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.priceconditiongroup.mapper.MdmPriceConditionGroupRelFieldMapper;
import com.biz.crm.priceconditiongroup.model.MdmPriceConditionGroupRelFieldEntity;
import com.biz.crm.priceconditiontype.mapper.MdmPriceConditionTypeMapper;
import com.biz.crm.priceconditiontype.model.MdmPriceConditionTypeEntity;
import com.biz.crm.pricesetting.mapper.MdmPriceSettingMapper;
import com.biz.crm.pricesetting.model.MdmPriceSettingEntity;
import com.biz.crm.pricesetting.service.IMdmPriceSettingService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmPriceSettingServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(MdmPriceSettingServiceHelper.class);
    @Resource
    private MdmPriceSettingMapper mdmPriceSettingMapper;
    @Autowired
    private IMdmPriceSettingService iMdmPriceSettingService;
    @Autowired
    private MdmPriceConditionGroupRelFieldMapper mdmPriceConditionGroupRelFieldMapper;
    @Autowired
    private MdmPriceConditionTypeMapper mdmPriceConditionTypeMapper;

    public void saveCheck(MdmPriceSettingReqVo reqVo) {
        this.setUpEnableStatus(reqVo);
        this.dataRequired(reqVo);
    }

    private List<MdmPriceConditionGroupRelFieldEntity> dataIllegal(MdmPriceSettingReqVo reqVo) {
        List conditionTypeEntities = this.mdmPriceConditionTypeMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(MdmPriceConditionTypeEntity::getConditionTypeCode, (Object)reqVo.getConditionTypeCode()));
        AssertUtils.isNotEmpty((Collection)conditionTypeEntities, (String)"\u6761\u4ef6\u7c7b\u578b\u7f16\u7801\u4e0d\u5b58\u5728");
        List fieldEntities = this.mdmPriceConditionGroupRelFieldMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode, (Object)reqVo.getConditionGroupCode()));
        AssertUtils.isNotEmpty((Collection)fieldEntities, (String)"\u6761\u4ef6\u5b57\u6bb5\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
        return fieldEntities;
    }

    public void dataUniqueSaveOrUpdate(MdmPriceSettingReqVo reqVo) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"condition_type_code", (Object)reqVo.getConditionTypeCode());
        wrapper.eq((Object)"condition_group_code", (Object)reqVo.getConditionGroupCode());
        this.setFieldCondition((QueryWrapper<MdmPriceSettingEntity>)wrapper, reqVo);
        List list = this.mdmPriceSettingMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List mdmPriceSettingReqVos = CrmBeanUtil.copyList((List)list, MdmPriceSettingReqVo.class);
            List<MdmPriceSettingReqVo> mdmPriceSettingReqVoList = this.timeTruncation(reqVo, mdmPriceSettingReqVos);
            if (CollectionUtil.listNotEmpty(mdmPriceSettingReqVoList)) {
                mdmPriceSettingReqVoList.forEach(mdmPriceSettingReqVo -> {
                    Date beginDate = DateUtil.localDateTimeConvertToDate((LocalDateTime)mdmPriceSettingReqVo.getBeginDateTime());
                    Date endDate = DateUtil.localDateTimeConvertToDate((LocalDateTime)mdmPriceSettingReqVo.getEndDateTime());
                    mdmPriceSettingReqVo.setBeginData(DateUtil.getFormatDateStr((Date)beginDate, (String)"yyyy-MM-dd"));
                    mdmPriceSettingReqVo.setBeginDataSecond(DateUtil.getFormatDateStr((Date)beginDate, (String)"HH:mm:ss"));
                    mdmPriceSettingReqVo.setEndData(DateUtil.getFormatDateStr((Date)endDate, (String)"yyyy-MM-dd"));
                    mdmPriceSettingReqVo.setEndDataSecond(DateUtil.getFormatDateStr((Date)endDate, (String)"HH:mm:ss"));
                });
                this.iMdmPriceSettingService.saveOrUpdateBatch(CrmBeanUtil.copyList(mdmPriceSettingReqVoList, MdmPriceSettingEntity.class));
            }
        } else {
            MdmPriceSettingEntity mdmPriceSettingReq = (MdmPriceSettingEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmPriceSettingEntity.class));
            mdmPriceSettingReq.setPriceSettingCode(CodeUtil.createOneCode((String)"mdm_price_setting"));
            this.iMdmPriceSettingService.saveOrUpdate((Object)mdmPriceSettingReq);
        }
    }

    public void setFieldCondition(QueryWrapper<MdmPriceSettingEntity> wrapper, MdmPriceSettingReqVo reqVo) {
        List<MdmPriceConditionGroupRelFieldEntity> fieldEntities = this.dataIllegal(reqVo);
        fieldEntities.forEach(fieldEntity -> {
            if (PriceSettingFieldEnum.CHANNEL.getCode().equals(fieldEntity.getFieldCode())) {
                AssertUtils.isNotEmpty((String)reqVo.getChannel(), (String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
                wrapper.eq((Object)"channel", (Object)reqVo.getChannel());
            }
            if (PriceSettingFieldEnum.CUSTOMER_CODE.getCode().equals(fieldEntity.getFieldCode())) {
                AssertUtils.isNotEmpty((String)reqVo.getCustomerCode(), (String)"\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
                wrapper.eq((Object)"customer_code", (Object)reqVo.getCustomerCode());
            }
            if (PriceSettingFieldEnum.ORG_CODE.getCode().equals(fieldEntity.getFieldCode())) {
                AssertUtils.isNotEmpty((String)reqVo.getOrgCode(), (String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
                wrapper.eq((Object)"org_code", (Object)reqVo.getOrgCode());
            }
            if (PriceSettingFieldEnum.PRODUCT_CODE.getCode().equals(fieldEntity.getFieldCode())) {
                AssertUtils.isNotEmpty((String)reqVo.getProductCode(), (String)"\u4ea7\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
                wrapper.eq((Object)"product_code", (Object)reqVo.getProductCode());
            }
        });
    }

    private List<MdmPriceSettingReqVo> timeTruncation(MdmPriceSettingReqVo reqVo, List<MdmPriceSettingReqVo> list) {
        reqVo.setBeginDateTime(DateUtil.dateConvertToLocalDateTime((Date)DateUtil.str2Date((String)reqVo.getBeginData().trim().concat(" ").concat(reqVo.getBeginDataSecond()), (SimpleDateFormat)DateUtil.datetimeFormat)));
        reqVo.setEndDateTime(DateUtil.dateConvertToLocalDateTime((Date)DateUtil.str2Date((String)reqVo.getEndData().trim().concat(" ").concat(reqVo.getEndDataSecond()), (SimpleDateFormat)DateUtil.datetimeFormat)));
        reqVo.setPriceSettingCode(CodeUtil.createOneCode((String)"mdm_price_setting"));
        ArrayList<MdmPriceSettingReqVo> priceSettingReqVos = new ArrayList<MdmPriceSettingReqVo>();
        for (MdmPriceSettingReqVo priceSetting : list) {
            priceSetting.setBeginDateTime(DateUtil.dateConvertToLocalDateTime((Date)DateUtil.str2Date((String)priceSetting.getBeginData().trim().concat(" ").concat(priceSetting.getBeginDataSecond()), (SimpleDateFormat)DateUtil.datetimeFormat)));
            priceSetting.setEndDateTime(DateUtil.dateConvertToLocalDateTime((Date)DateUtil.str2Date((String)priceSetting.getEndData().trim().concat(" ").concat(priceSetting.getEndDataSecond()), (SimpleDateFormat)DateUtil.datetimeFormat)));
            priceSettingReqVos.addAll(this.generate(priceSetting, reqVo));
        }
        List collect = priceSettingReqVos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MdmPriceSettingReqVo>(Comparator.comparing(MdmPriceSettingReqVo::getPriceSettingCode))), ArrayList::new));
        return collect;
    }

    private List<MdmPriceSettingReqVo> generate(MdmPriceSettingReqVo data1, MdmPriceSettingReqVo data2) {
        List<MdmPriceSettingReqVo> list = Stream.of(data1, data2).collect(Collectors.toList());
        long s1 = data1.getBeginDateTime().toEpochSecond(ZoneOffset.of("+8"));
        long e1 = data1.getEndDateTime().toEpochSecond(ZoneOffset.of("+8"));
        long s2 = data2.getBeginDateTime().toEpochSecond(ZoneOffset.of("+8"));
        long e2 = data2.getEndDateTime().toEpochSecond(ZoneOffset.of("+8"));
        if (s2 <= s1) {
            if (e2 >= s1) {
                if (e2 < e1) {
                    data1.setBeginDateTime(data2.getEndDateTime().plusSeconds(1L));
                } else {
                    list.remove(data1);
                    this.mdmPriceSettingMapper.deleteById((Serializable)((Object)data1.getId()));
                }
            }
        } else if (s2 <= e1) {
            if (e2 < e1) {
                LocalDateTime endDate = data1.getEndDateTime();
                data1.setEndDateTime(data2.getBeginDateTime().plusSeconds(-1L));
                MdmPriceSettingReqVo data3 = (MdmPriceSettingReqVo)CrmBeanUtil.copy((Object)data1, MdmPriceSettingReqVo.class);
                data3.setBeginDateTime(data2.getEndDateTime().plusSeconds(1L));
                data3.setEndDateTime(endDate);
                data3.setPrice(data1.getPrice());
                data3.setId("");
                data3.setPriceSettingCode(CodeUtil.createOneCode((String)"mdm_price_setting"));
                list.add(data3);
            } else {
                data1.setEndDateTime(data2.getEndDateTime().plusSeconds(-1L));
            }
        }
        return list;
    }

    private void dataRequired(MdmPriceSettingReqVo reqVo) {
        long dateEnd;
        long dateStart;
        AssertUtils.isNotEmpty((String)reqVo.getConditionTypeCode(), (String)"\u6761\u4ef6\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getConditionGroupCode(), (String)"\u6761\u4ef6\u5b57\u6bb5\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull((Object)reqVo.getPrice(), (String)"\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull((Object)reqVo.getCurrencyType(), (String)"\u5e01\u79cd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull((Object)reqVo.getPriceUnit(), (String)"\u4ef7\u683c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull((Object)reqVo.getBeginData(), (String)"\u6709\u6548\u671f\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull((Object)reqVo.getEndData(), (String)"\u6709\u6548\u671f\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((String)reqVo.getBeginDataSecond())) {
            reqVo.setBeginDataSecond("00:00:00");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getEndDataSecond())) {
            reqVo.setEndDataSecond("23:59:59");
        }
        AssertUtils.isTrue(((dateStart = DateUtil.str2Date((String)reqVo.getBeginData().trim().concat(" ").concat(reqVo.getBeginDataSecond()), (SimpleDateFormat)DateUtil.datetimeFormat).getTime()) < (dateEnd = DateUtil.str2Date((String)reqVo.getEndData().trim().concat(" ").concat(reqVo.getEndDataSecond()), (SimpleDateFormat)DateUtil.datetimeFormat).getTime()) ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u6216\u8005\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f");
    }

    public void setUpEnableStatus(MdmPriceSettingReqVo reqVo) {
        String staterStr = reqVo.getBeginData().trim().concat(" ").concat(reqVo.getBeginDataSecond());
        String endStr = reqVo.getEndData().trim().concat(" ").concat(reqVo.getEndDataSecond());
        Date staterData = DateUtil.str2Date((String)staterStr, (SimpleDateFormat)DateUtil.datetimeFormat);
        Date endData = DateUtil.str2Date((String)endStr, (SimpleDateFormat)DateUtil.datetimeFormat);
        Date date = DateUtil.getDate();
        if (DateUtil.equalIsDateMoreThanAnother((Date)staterData, (Date)date)) {
            reqVo.setEnableStatus(PriceSettingStatusEnum.TO_BE_EFFECTIVE.getCode());
        }
        if (DateUtil.equalIsDateMoreThanAnother((Date)date, (Date)staterData) && DateUtil.equalIsDateMoreThanAnother((Date)endData, (Date)date)) {
            reqVo.setEnableStatus(PriceSettingStatusEnum.IN_EFFECT.getCode());
        }
        if (DateUtil.equalIsDateMoreThanAnother((Date)date, (Date)endData)) {
            reqVo.setEnableStatus(PriceSettingStatusEnum.EXPIRED.getCode());
        }
    }
}

