/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.region.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.region.MdmRegionReqVo;
import com.biz.crm.nebular.mdm.region.MdmRegionRespVo;
import com.biz.crm.nebular.mdm.region.MdmRegionSelectRespVo;
import com.biz.crm.region.mapper.MdmRegionMapper;
import com.biz.crm.region.model.MdmRegionEntity;
import com.biz.crm.region.service.IMdmRegionService;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmRegionServiceExpandImpl"})
public class MdmRegionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmRegionMapper, MdmRegionEntity>
implements IMdmRegionService {
    private static final Logger log = LoggerFactory.getLogger(MdmRegionServiceImpl.class);
    @Resource
    private MdmRegionMapper mdmRegionMapper;

    @Override
    public PageResult<MdmRegionRespVo> findList(MdmRegionReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmRegionRespVo> list = this.mdmRegionMapper.findList((Page<MdmRegionRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmRegionRespVo query(MdmRegionReqVo reqVo) {
        MdmRegionEntity one = (MdmRegionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((Object)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).in(!CollectionUtils.isEmpty((Collection)reqVo.getIds()), BaseIdEntity::getId, (Collection)reqVo.getIds())).in(!CollectionUtils.isEmpty((Collection)reqVo.getRegionCodeList()), MdmRegionEntity::getRegionCode, (Collection)reqVo.getRegionCodeList())).eq(!StringUtils.isEmpty((Object)reqVo.getRegionCode()), MdmRegionEntity::getRegionCode, (Object)reqVo.getRegionCode())).eq(!StringUtils.isEmpty((Object)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus())).one());
        return (MdmRegionRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmRegionRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmRegionReqVo reqVo) {
        MdmRegionEntity entity = (MdmRegionEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmRegionEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmRegionReqVo reqVo) {
        String id = reqVo.getId();
        Assert.hasText((String)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmRegionEntity entity = (MdmRegionEntity)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)entity), (String)"\u533a\u57df\u4e0d\u5b58\u5728");
        this.updateById(CrmBeanUtil.copy((Object)reqVo, MdmRegionEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmRegionReqVo reqVo) {
        List ids = reqVo.getIds();
        String id = reqVo.getId();
        String regionCode = reqVo.getRegionCode();
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)ids) || !StringUtils.isEmpty((Object)id) || !StringUtils.isEmpty((Object)regionCode) ? 1 : 0) != 0, (String)"id\u6216\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).eq(BaseIdEntity::getId, (Object)id)).eq(MdmRegionEntity::getRegionCode, (Object)regionCode)).in(!CollectionUtils.isEmpty((Collection)reqVo.getRegionCodeList()), MdmRegionEntity::getRegionCode, new Object[]{reqVo.getRegionCode()})).remove();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmRegionReqVo reqVo) {
        List ids = reqVo.getIds();
        String id = reqVo.getId();
        String regionCode = reqVo.getRegionCode();
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)ids) || !StringUtils.isEmpty((Object)id) || !StringUtils.isEmpty((Object)regionCode) ? 1 : 0) != 0, (String)"id\u6216\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).eq(BaseIdEntity::getId, (Object)id)).eq(MdmRegionEntity::getRegionCode, (Object)regionCode)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmRegionReqVo reqVo) {
        List ids = reqVo.getIds();
        String id = reqVo.getId();
        String regionCode = reqVo.getRegionCode();
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)ids) || !StringUtils.isEmpty((Object)id) || !StringUtils.isEmpty((Object)regionCode) ? 1 : 0) != 0, (String)"id\u6216\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).eq(BaseIdEntity::getId, (Object)id)).eq(MdmRegionEntity::getRegionCode, (Object)regionCode)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public List<MdmRegionSelectRespVo> select(MdmRegionReqVo mdmRegionReqVo) {
        String currentRegionLevel = mdmRegionReqVo.getCurrentRegionLevel();
        if (!StringUtils.isEmpty((Object)currentRegionLevel)) {
            Assert.isTrue((boolean)currentRegionLevel.matches("^[0-9]+$"), (String)"\u533a\u57df\u5c42\u7ea7\u5fc5\u987b\u662f\u6570\u5b57");
            mdmRegionReqVo.setRegionLevel(String.valueOf(Integer.parseInt(currentRegionLevel) - 1));
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((Object)mdmRegionReqVo.getId()), BaseIdEntity::getId, (Object)mdmRegionReqVo.getId())).in(!CollectionUtils.isEmpty((Collection)mdmRegionReqVo.getIds()), BaseIdEntity::getId, new Object[]{mdmRegionReqVo.getId()})).in(!CollectionUtils.isEmpty((Collection)mdmRegionReqVo.getRegionCodeList()), MdmRegionEntity::getRegionCode, (Collection)mdmRegionReqVo.getRegionCodeList())).like(!StringUtils.isEmpty((Object)mdmRegionReqVo.getRegionCode()), MdmRegionEntity::getRegionCode, (Object)mdmRegionReqVo.getRegionCode())).like(!StringUtils.isEmpty((Object)mdmRegionReqVo.getRegionName()), MdmRegionEntity::getRegionName, (Object)mdmRegionReqVo.getRegionName())).eq(!StringUtils.isEmpty((Object)mdmRegionReqVo.getRegionLevel()), MdmRegionEntity::getRegionLevel, (Object)mdmRegionReqVo.getRegionLevel())).eq(!StringUtils.isEmpty((Object)mdmRegionReqVo.getParentCode()), MdmRegionEntity::getParentCode, (Object)mdmRegionReqVo.getParentCode())).eq(!StringUtils.isEmpty((Object)mdmRegionReqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)mdmRegionReqVo.getEnableStatus())).list();
        return CrmBeanUtil.copyList((List)list, MdmRegionSelectRespVo.class);
    }
}

