/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.role.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.humanarea.MdmUnbindUserRelationCustomerReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleRelationPositionPageReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleRelationPositionReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSearchReqVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRelationPositionPageRespVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.positionlevel.service.IMdmPositionLevelRoleService;
import com.biz.crm.positionrole.mapper.MdmPositionRoleMapper;
import com.biz.crm.positionrole.model.MdmPositionRoleEntity;
import com.biz.crm.positionrole.service.MdmPositionRoleService;
import com.biz.crm.role.mapper.MdmRoleMapper;
import com.biz.crm.role.mode.MdmRoleEntity;
import com.biz.crm.role.service.IMdmRoleService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.utils.DatabaseTypeUtil;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmRoleServiceExpandImpl"})
public class MdmRoleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmRoleMapper, MdmRoleEntity>
implements IMdmRoleService {
    private static final Logger log = LoggerFactory.getLogger(MdmRoleServiceImpl.class);
    @Resource
    private MdmRoleMapper mdmRoleMapper;
    @Resource
    private MdmPositionRoleService mdmPositionRoleService;
    @Resource
    private MdmPositionRoleMapper mdmPositionRoleMapper;
    @Resource
    private IMdmPositionLevelRoleService mdmPositionLevelRoleService;

    @Override
    public PageResult<MdmRoleRespVo> findList(MdmRoleReqVo mdmRoleReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmRoleReqVo.getPageNum(), (Integer)mdmRoleReqVo.getPageSize());
        List<MdmRoleRespVo> list = this.mdmRoleMapper.findList((Page<MdmRoleReqVo>)page, mdmRoleReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmRoleRespVo query(MdmRoleReqVo mdmRoleReqVo) {
        if (StringUtils.isNotEmpty((CharSequence)mdmRoleReqVo.getId()) || StringUtils.isNotEmpty((CharSequence)mdmRoleReqVo.getRoleCode())) {
            MdmRoleEntity one = (MdmRoleEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((CharSequence)mdmRoleReqVo.getRoleCode()), MdmRoleEntity::getRoleCode, (Object)mdmRoleReqVo.getRoleCode())).eq(!StringUtils.isEmpty((CharSequence)mdmRoleReqVo.getId()), BaseIdEntity::getId, (Object)mdmRoleReqVo.getId())).one());
            return (MdmRoleRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmRoleRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmRoleReqVo mdmRoleReqVo) {
        if (StringUtils.isBlank((CharSequence)mdmRoleReqVo.getRoleName())) {
            throw new BusinessException("\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Assert.hasText((String)mdmRoleReqVo.getEnableStatus(), (String)"\u542f\u7528\u7981\u7528\u72b6\u6001\u5fc5\u586b");
        MdmRoleEntity roleNameEntity = (MdmRoleEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRoleEntity::getRoleName, (Object)mdmRoleReqVo.getRoleName())).select(new SFunction[]{BaseIdEntity::getId}).last(DatabaseTypeUtil.SEGMENT)).one());
        Assert.isNull((Object)((Object)roleNameEntity), (String)"\u5f53\u524d\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        if (StringUtils.isBlank((CharSequence)mdmRoleReqVo.getRoleCode())) {
            mdmRoleReqVo.setRoleCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_ROLE_CODE.getCode()));
        } else {
            Assert.isTrue((boolean)mdmRoleReqVo.getRoleCode().matches("^[A-Za-z0-9]+$"), (String)"\u89d2\u8272\u7f16\u7801\u8bf7\u8f93\u5165\u6570\u5b57\u548c\u5b57\u6bcd\u7ec4\u5408");
            MdmRoleEntity roleCodeEntity = (MdmRoleEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRoleEntity::getRoleCode, (Object)mdmRoleReqVo.getRoleCode())).select(new SFunction[]{BaseIdEntity::getId}).last(DatabaseTypeUtil.SEGMENT)).one());
            Assert.isNull((Object)((Object)roleCodeEntity), (String)"\u5f53\u524d\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        this.save(CrmBeanUtil.copy((Object)mdmRoleReqVo, MdmRoleEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmRoleReqVo mdmRoleReqVo) {
        String id = mdmRoleReqVo.getId();
        Assert.hasText((String)id, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        this.updateById(CrmBeanUtil.copy((Object)mdmRoleReqVo, MdmRoleEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmRoleReqVo mdmRoleReqVo) {
        List ids = mdmRoleReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u5fc5\u586b");
        for (String id : ids) {
            MdmRoleEntity role = (MdmRoleEntity)((Object)this.getById((Serializable)((Object)id)));
            Assert.notNull((Object)((Object)role), (String)"\u89d2\u8272\u4e0d\u5b58\u5728");
            this.mdmPositionLevelRoleService.removeRoleCode(role.getRoleCode());
            this.mdmPositionRoleService.removeRoleCode(role.getRoleCode());
            this.removeById((Serializable)((Object)id));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmRoleReqVo mdmRoleReqVo) {
        List ids = mdmRoleReqVo.getIds();
        Assert.notNull((Object)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId}).count();
        Assert.isTrue((count != null && count.equals(ids.size()) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u542f\u7528\u72b6\u6001\u4e3a\u201d\u7981\u7528\u201c\u7684\u6743\u9650\u89d2\u8272");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)mdmRoleReqVo.getIds())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmRoleReqVo mdmRoleReqVo) {
        List ids = mdmRoleReqVo.getIds();
        Assert.notNull((Object)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId}).count();
        Assert.isTrue((count != null && count.equals(ids.size()) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u7981\u7528\u72b6\u6001\u4e3a\u201d\u542f\u7528\u201c\u7684\u6743\u9650\u89d2\u8272");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)mdmRoleReqVo.getIds())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public List<MdmRoleRespVo> listCondition(MdmRoleSearchReqVo mdmRoleSearchReqVo) {
        List<Object> roleCodeList = new ArrayList();
        if (!StringUtils.isEmpty((CharSequence)mdmRoleSearchReqVo.getPositionCode())) {
            roleCodeList = this.mdmPositionRoleService.findRoleCodeByPosition(Collections.singletonList(mdmRoleSearchReqVo.getPositionCode()));
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).like(!StringUtils.isEmpty((CharSequence)mdmRoleSearchReqVo.getRoleCode()), MdmRoleEntity::getRoleCode, (Object)mdmRoleSearchReqVo.getRoleCode())).like(!StringUtils.isEmpty((CharSequence)mdmRoleSearchReqVo.getRoleName()), MdmRoleEntity::getRoleName, (Object)mdmRoleSearchReqVo.getRoleName())).in(!CollectionUtils.isEmpty(roleCodeList), MdmRoleEntity::getRoleCode, roleCodeList)).list();
        return CrmBeanUtil.copyList((List)list, MdmRoleRespVo.class);
    }

    @Override
    public PageResult<MdmRoleRelationPositionPageRespVo> positionPage(MdmRoleRelationPositionPageReqVo mdmRoleRelationPositionPageReqVo) {
        String queryType = mdmRoleRelationPositionPageReqVo.getQueryType();
        Assert.hasText((String)queryType, (String)"\u67e5\u8be2\u65b9\u5f0fqueryType\u4e0d\u80fd\u4e3a\u7a7a");
        switch (queryType) {
            case "1": {
                return this.findUnRelationAnyUser(mdmRoleRelationPositionPageReqVo);
            }
            case "2": {
                return this.findUnRelationCurrentUser(mdmRoleRelationPositionPageReqVo);
            }
            case "3": {
                return this.findRelationCurrentUser(mdmRoleRelationPositionPageReqVo);
            }
        }
        return new PageResult();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void relationPosition(MdmRoleRelationPositionReqVo mdmRoleRelationPositionReqVo) {
        List positionCodeList = mdmRoleRelationPositionReqVo.getPositionCodeList();
        String roleCode = mdmRoleRelationPositionReqVo.getRoleCode();
        String originRoleCode = mdmRoleRelationPositionReqVo.getOriginRoleCode();
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)positionCodeList, (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        if (!StringUtils.isEmpty((CharSequence)originRoleCode)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmPositionRoleService.lambdaUpdate().eq(MdmPositionRoleEntity::getRoleCode, (Object)originRoleCode)).in(MdmPositionRoleEntity::getPositionCode, (Collection)positionCodeList)).remove();
        }
        positionCodeList.stream().map(positionCode -> {
            MdmPositionRoleEntity mdmPositionRoleEntity = new MdmPositionRoleEntity();
            mdmPositionRoleEntity.setPositionCode((String)positionCode);
            mdmPositionRoleEntity.setRoleCode(roleCode);
            mdmPositionRoleEntity.setId(positionCode + roleCode);
            return mdmPositionRoleEntity;
        }).forEach(x -> {
            MdmPositionRoleEntity one = (MdmPositionRoleEntity)((Object)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmPositionRoleService.lambdaQuery().eq(MdmPositionRoleEntity::getPositionCode, (Object)x.getPositionCode())).eq(MdmPositionRoleEntity::getRoleCode, (Object)x.getRoleCode())).one()));
            if (one == null) {
                this.mdmPositionRoleService.save(x);
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unbindRelationPosition(MdmUnbindUserRelationCustomerReqVo mdmUnbindUserRelationCustomerReqVo) {
        List ids = mdmUnbindUserRelationCustomerReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        this.mdmPositionRoleService.removeByIds(ids);
    }

    private PageResult<MdmRoleRelationPositionPageRespVo> findRelationCurrentUser(MdmRoleRelationPositionPageReqVo mdmRoleRelationPositionPageReqVo) {
        Page page = new Page((long)mdmRoleRelationPositionPageReqVo.getPageNum().intValue(), (long)mdmRoleRelationPositionPageReqVo.getPageSize().intValue());
        Assert.hasText((String)mdmRoleRelationPositionPageReqVo.getRoleCode(), (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<MdmRoleRelationPositionPageRespVo> data = this.mdmPositionRoleMapper.findRelationCurrentUser((Page<MdmRoleRelationPositionPageRespVo>)page, mdmRoleRelationPositionPageReqVo);
        return PageResult.builder().data(data).count(Long.valueOf(page.getTotal())).build();
    }

    private PageResult<MdmRoleRelationPositionPageRespVo> findUnRelationCurrentUser(MdmRoleRelationPositionPageReqVo mdmRoleRelationPositionPageReqVo) {
        Page page = new Page((long)mdmRoleRelationPositionPageReqVo.getPageNum().intValue(), (long)mdmRoleRelationPositionPageReqVo.getPageSize().intValue());
        Assert.hasText((String)mdmRoleRelationPositionPageReqVo.getRoleCode(), (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.mdmPositionRoleService.lambdaQuery().eq(MdmPositionRoleEntity::getRoleCode, (Object)mdmRoleRelationPositionPageReqVo.getRoleCode())).select(new SFunction[]{MdmPositionRoleEntity::getPositionCode}).list();
        List<String> positionCodeList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            positionCodeList = list.stream().map(MdmPositionRoleEntity::getPositionCode).collect(Collectors.toList());
        }
        List<MdmRoleRelationPositionPageRespVo> data = this.mdmPositionRoleMapper.findUnRelationAnyUser((Page<MdmRoleRelationPositionPageRespVo>)page, mdmRoleRelationPositionPageReqVo, positionCodeList);
        return PageResult.builder().data(data).count(Long.valueOf(page.getTotal())).build();
    }

    private PageResult<MdmRoleRelationPositionPageRespVo> findUnRelationAnyUser(MdmRoleRelationPositionPageReqVo mdmRoleRelationPositionPageReqVo) {
        List list = this.mdmPositionRoleService.lambdaQuery().select(new SFunction[]{MdmPositionRoleEntity::getPositionCode}).list();
        ArrayList<String> positionCodeList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            positionCodeList = list.stream().map(MdmPositionRoleEntity::getPositionCode).collect(Collectors.toList());
        }
        Page page = new Page((long)mdmRoleRelationPositionPageReqVo.getPageNum().intValue(), (long)mdmRoleRelationPositionPageReqVo.getPageSize().intValue());
        List<MdmRoleRelationPositionPageRespVo> data = this.mdmPositionRoleMapper.findUnRelationAnyUser((Page<MdmRoleRelationPositionPageRespVo>)page, mdmRoleRelationPositionPageReqVo, positionCodeList);
        return PageResult.builder().data(data).count(Long.valueOf(page.getTotal())).build();
    }
}

