/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tableconfig.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.tableconfig.mapper.MdmColumnConfigMapper;
import com.biz.crm.tableconfig.model.MdmColumnConfigEntity;
import com.biz.crm.tableconfig.service.IMdmColumnConfigService;
import com.biz.crm.util.CrmBeanUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmColumnConfigServiceExpandImpl"})
public class MdmColumnConfigServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmColumnConfigMapper, MdmColumnConfigEntity>
implements IMdmColumnConfigService {
    private static final Logger log = LoggerFactory.getLogger(MdmColumnConfigServiceImpl.class);
    @Resource
    private MdmColumnConfigMapper mdmColumnConfigMapper;

    @Override
    public PageResult<MdmColumnConfigRespVo> findList(MdmColumnConfigReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmColumnConfigRespVo> list = this.mdmColumnConfigMapper.findList((Page<MdmColumnConfigRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmColumnConfigRespVo query(MdmColumnConfigReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmColumnConfigReqVo reqVo) {
        Assert.hasText((String)reqVo.getFunctionCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getField(), (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        MdmColumnConfigEntity entity = (MdmColumnConfigEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmColumnConfigEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmColumnConfigReqVo reqVo) {
        Assert.hasText((String)reqVo.getFunctionCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getField(), (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        String id = reqVo.getId();
        Assert.hasText((String)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmColumnConfigEntity entity = (MdmColumnConfigEntity)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)entity), (String)"\u5b57\u6bb5\u4e0d\u5b58\u5728");
        this.updateById(CrmBeanUtil.copy((Object)reqVo, MdmColumnConfigEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmColumnConfigReqVo reqVo) {
        List mdmColumnConfigEntities = this.mdmColumnConfigMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmColumnConfigEntities)) {
            mdmColumnConfigEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(mdmColumnConfigEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmColumnConfigReqVo reqVo) {
        List mdmColumnConfigEntities = this.mdmColumnConfigMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmColumnConfigEntities)) {
            mdmColumnConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmColumnConfigEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmColumnConfigReqVo reqVo) {
        List mdmColumnConfigEntities = this.mdmColumnConfigMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmColumnConfigEntities)) {
            mdmColumnConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmColumnConfigEntities);
    }

    @Override
    public List<MdmColumnConfigRespVo> listCondition(MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((Object)mdmColumnConfigReqVo.getFunctionCode()), MdmColumnConfigEntity::getFunctionCode, (Object)mdmColumnConfigReqVo.getFunctionCode())).list();
        return CrmBeanUtil.copyList((List)list, MdmColumnConfigRespVo.class);
    }

    @Override
    public List<MdmColumnConfigRespVo> columnResolve(String classPath) {
        ArrayList<MdmColumnConfigRespVo> list = new ArrayList<MdmColumnConfigRespVo>();
        for (Class<?> clazz = Class.forName(classPath); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = clazz.getDeclaredFields()) {
                if (declaredField.getName().equals("formInstanceId") || declaredField.getName().equals("serialVersionUID")) continue;
                MdmColumnConfigRespVo mdmColumnConfigRespVo = new MdmColumnConfigRespVo();
                mdmColumnConfigRespVo.setField(declaredField.getName());
                mdmColumnConfigRespVo.setVisible(Boolean.valueOf(true));
                ApiModelProperty annotation = declaredField.getAnnotation(ApiModelProperty.class);
                if (annotation != null) {
                    mdmColumnConfigRespVo.setTitle(annotation.value());
                }
                list.add(mdmColumnConfigRespVo);
            }
        }
        return list;
    }

    @Override
    public void addBatch(List<MdmColumnConfigReqVo> mdmColumnConfigReqVos) {
        Assert.notEmpty(mdmColumnConfigReqVos, (String)"\u65b0\u589e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)mdmColumnConfigReqVos.stream().noneMatch(x -> StringUtils.isEmpty((Object)x.getFunctionCode())), (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        long count = mdmColumnConfigReqVos.stream().map(MdmColumnConfigReqVo::getFunctionCode).distinct().count();
        Assert.isTrue((count == 1L ? 1 : 0) != 0, (String)"\u83dc\u5355\u7f16\u7801\u5fc5\u987b\u76f8\u540c");
        for (MdmColumnConfigReqVo mdmColumnConfigReqVo : mdmColumnConfigReqVos) {
            this.save(mdmColumnConfigReqVo);
        }
    }
}

