/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tableconfig.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubRespVo;
import com.biz.crm.tableconfig.mapper.MdmFunctionSubMapper;
import com.biz.crm.tableconfig.model.MdmFunctionSubEntity;
import com.biz.crm.tableconfig.service.IMdmFunctionSubService;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmFunctionSubServiceExpandImpl"})
public class MdmFunctionSubServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmFunctionSubMapper, MdmFunctionSubEntity>
implements IMdmFunctionSubService {
    private static final Logger log = LoggerFactory.getLogger(MdmFunctionSubServiceImpl.class);
    @Resource
    private MdmFunctionSubMapper mdmFunctionSubMapper;
    @Resource
    private MdmFunctionService mdmFunctionService;

    @Override
    public PageResult<MdmFunctionSubRespVo> findList(MdmFunctionSubReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmFunctionSubRespVo> list = this.mdmFunctionSubMapper.findList((Page<MdmFunctionSubRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmFunctionSubRespVo query(MdmFunctionSubReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmFunctionSubReqVo reqVo) {
        String parentCode = reqVo.getParentCode();
        Assert.hasText((String)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmFunctionReqVo mdmFunctionReqVo = new MdmFunctionReqVo();
        mdmFunctionReqVo.setFunctionCode(parentCode);
        MdmFunctionRespVo mdmFunctionRespVo = this.mdmFunctionService.query(mdmFunctionReqVo);
        Assert.notNull((Object)mdmFunctionRespVo, (String)"\u83dc\u5355\u4e0d\u5b58\u5728");
        MdmFunctionSubEntity entity = (MdmFunctionSubEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmFunctionSubEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmFunctionSubReqVo reqVo) {
        MdmFunctionSubEntity entity = (MdmFunctionSubEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmFunctionSubReqVo reqVo) {
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)reqVo.getIds())).remove();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmFunctionSubReqVo reqVo) {
        List mdmFunctionSubEntities = this.mdmFunctionSubMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmFunctionSubEntities)) {
            mdmFunctionSubEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmFunctionSubEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmFunctionSubReqVo reqVo) {
        List mdmFunctionSubEntities = this.mdmFunctionSubMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmFunctionSubEntities)) {
            mdmFunctionSubEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmFunctionSubEntities);
    }

    @Override
    public PageResult<MdmFunctionRespVo> functionPage(MdmFunctionReqVo mdmFunctionReqVo) {
        return this.mdmFunctionService.functionPage(mdmFunctionReqVo);
    }

    @Override
    public List<MdmFunctionSubRespVo> findSubList(MdmFunctionReqVo mdmFunctionReqVo) {
        String parentCode = mdmFunctionReqVo.getParentCode();
        Assert.hasText((String)parentCode, (String)"\u4e0a\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmFunctionSubEntity::getParentCode, (Object)parentCode)).list();
        return CrmBeanUtil.copyList((List)list, MdmFunctionSubRespVo.class);
    }
}

