/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingSearchReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmTerminalOrgSearchReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmCusOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmPositionTerminalSearchReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalRespVo;
import com.biz.crm.terminal.service.IMdmTerminalService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmterminal"})
@Api(tags={"\u7ec8\u7aef\u4fe1\u606f"})
@CrmGlobalLog
public class MdmTerminalController {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalController.class);
    @Autowired
    private IMdmTerminalService iMdmTerminalService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmDictMethod
    public Result<PageResult<MdmTerminalRespVo>> list(@RequestBody MdmTerminalReqVo mdmTerminalReqVo) {
        PageResult<MdmTerminalRespVo> result = this.iMdmTerminalService.findList(mdmTerminalReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    public Result<MdmTerminalRespVo> query(@RequestBody MdmTerminalReqVo mdmTerminalReqVo) {
        MdmTerminalRespVo model = this.iMdmTerminalService.query(mdmTerminalReqVo);
        return Result.ok((Object)model);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result<Object> save(@RequestBody MdmTerminalReqVo mdmTerminalReqVo) {
        this.iMdmTerminalService.save(mdmTerminalReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result<Object> update(@RequestBody MdmTerminalReqVo mdmTerminalReqVo) {
        this.iMdmTerminalService.update(mdmTerminalReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result<Object> delete(@RequestBody MdmTerminalReqVo mdmTerminalReqVo) {
        this.iMdmTerminalService.deleteBatch(mdmTerminalReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    public Result<Object> enable(@RequestBody MdmTerminalReqVo mdmTerminalReqVo) {
        this.iMdmTerminalService.enableBatch(mdmTerminalReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    public Result<Object> disable(@RequestBody MdmTerminalReqVo mdmTerminalReqVo) {
        this.iMdmTerminalService.disableBatch(mdmTerminalReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801")
    @PostMapping(value={"/update_cus_org"})
    public Result<Object> updateCusOrgCode(@RequestBody MdmCusOrgTerminalReqVo mdmCusOrgTerminalReqVo) {
        this.iMdmTerminalService.updateCusOrgCode(mdmCusOrgTerminalReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u7ec8\u7aef\u7f16\u7801\u96c6\u5408")
    @PostMapping(value={"/terminal_code_list"})
    public Result<List<String>> findByOrgCodeList(@RequestBody List<String> list) {
        return Result.ok(this.iMdmTerminalService.findByOrgCodeList(list));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u4e0a\u7ea7\u5ba2\u6237")
    @PostMapping(value={"/up_customer"})
    public Result<List<MdmCustomerMsgRespVo>> findCustomerList(@RequestBody MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo) {
        return Result.ok(this.iMdmTerminalService.findCustomerList(mdmCustomerOrgSearchReqVo));
    }

    @ApiOperation(value="\u4e1a\u52a1\u5458\u4e0b\u62c9\u67e5\u8be2")
    @PostMapping(value={"/supply_search"})
    public Result<List<MdmCustomerDockingRespVo>> dockingSearch(@RequestBody MdmCustomerDockingSearchReqVo mdmCustomerDockingSearchReqVo) {
        return Result.ok(this.iMdmTerminalService.dockingSearch(mdmCustomerDockingSearchReqVo));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u53ca\u4e0b\u7ea7\u7ec8\u7aef")
    @PostMapping(value={"/findCurrentAndSubTerminalList"})
    public Result<List<MdmTerminalRespVo>> findCurrentAndSubTerminalList(@RequestBody MdmTerminalOrgSearchReqVo mdmTerminalOrgSearchReqVo) {
        return Result.ok(this.iMdmTerminalService.findCurrentAndSubTerminalList(mdmTerminalOrgSearchReqVo));
    }

    @ApiOperation(value="\u6761\u4ef6\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list_condition"})
    public Result<List<MdmTerminalRespVo>> listCondition(@RequestBody MdmTerminalReqVo mdmTerminalReqVo) {
        return Result.ok(this.iMdmTerminalService.listCondition(mdmTerminalReqVo));
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4did\u6216\u7f16\u7801\u67e5\u8be2\u7ec8\u7aef\u5217\u8868")
    @PostMapping(value={"/position_terminal"})
    public Result<List<MdmTerminalRespVo>> findPositionTerminalList(@RequestBody MdmPositionTerminalSearchReqVo mdmPositionTerminalSearchReqVo) {
        return Result.ok(this.iMdmTerminalService.findPositionTerminalList(mdmPositionTerminalSearchReqVo));
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4did\u6216\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u53ca\u6240\u6709\u4e0b\u7ea7\u804c\u4f4d\u5bf9\u5e94\u7ec8\u7aef\u5217\u8868")
    @PostMapping(value={"/sub_position_terminal"})
    public Result<List<MdmTerminalRespVo>> findCurrentAndSybPositionTerminalList(@RequestBody MdmPositionTerminalSearchReqVo mdmPositionTerminalSearchReqVo) {
        return Result.ok(this.iMdmTerminalService.findCurrentAndSybPositionTerminalList(mdmPositionTerminalSearchReqVo));
    }

    @ApiOperation(value="\u7ec8\u7aef\u53ca\u8054\u7cfb\u4eba\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/terminal_contact_page"})
    public Result<PageResult<MdmTerminalRespVo>> terminalContactPage(@RequestBody MdmTerminalReqVo mdmTerminalReqVo) {
        return Result.ok(this.iMdmTerminalService.terminalContactPage(mdmTerminalReqVo));
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u4e0e\u7ec8\u7aef\u5173\u8054\u7684\u4f01\u4e1a\u7ec4\u7ec7\u7f16\u7801")
    @PostMapping(value={"/batchUpdateTerminalOrg"})
    public Result batchUpdateTerminalOrg(@RequestBody MdmOrgTerminalReqVo reqVo) {
        this.iMdmTerminalService.batchUpdateTerminalOrg(reqVo);
        return Result.ok();
    }
}

