/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.mdm.TerminalMediaTypeEnum;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalMediaReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalMediaRespVo;
import com.biz.crm.terminal.mapper.MdmTerminalMediaMapper;
import com.biz.crm.terminal.model.MdmTerminalMediaEntity;
import com.biz.crm.terminal.service.IMdmTerminalMediaService;
import com.biz.crm.util.CrmBeanUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmTerminalMediaServiceExpandImpl"})
public class MdmTerminalMediaServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmTerminalMediaMapper, MdmTerminalMediaEntity>
implements IMdmTerminalMediaService {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalMediaServiceImpl.class);

    @Override
    public List<MdmTerminalMediaRespVo> findList(MdmTerminalMediaReqVo mdmTerminalMediaReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((Object)mdmTerminalMediaReqVo.getTerminalCode()), MdmTerminalMediaEntity::getTerminalCode, (Object)mdmTerminalMediaReqVo.getTerminalCode())).eq(!StringUtils.isEmpty((Object)mdmTerminalMediaReqVo.getImageType()), MdmTerminalMediaEntity::getImageType, (Object)mdmTerminalMediaReqVo.getImageType())).list();
        return CrmBeanUtil.copyList((List)list, MdmTerminalMediaRespVo.class);
    }

    @Override
    public void setUpMedia(MdmTerminalReqVo mdmTerminalReqVo) {
        MdmTerminalMediaEntity mdmTerminalMediaEntity;
        String terminalCode = mdmTerminalReqVo.getTerminalCode();
        List licenseImagePath = mdmTerminalReqVo.getLicenseImagePath();
        List shopImagePath = mdmTerminalReqVo.getShopImagePath();
        Assert.hasText((String)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<MdmTerminalMediaEntity> mdmTerminalMediaEntities = new ArrayList<MdmTerminalMediaEntity>();
        if (!CollectionUtils.isEmpty((Collection)licenseImagePath)) {
            for (String path : licenseImagePath) {
                mdmTerminalMediaEntity = new MdmTerminalMediaEntity();
                mdmTerminalMediaEntity.setImagePath(path);
                mdmTerminalMediaEntity.setTerminalCode(terminalCode);
                mdmTerminalMediaEntity.setImageType(TerminalMediaTypeEnum.LICENSE.getCode());
                mdmTerminalMediaEntities.add(mdmTerminalMediaEntity);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)shopImagePath)) {
            for (String path : shopImagePath) {
                mdmTerminalMediaEntity = new MdmTerminalMediaEntity();
                mdmTerminalMediaEntity.setImagePath(path);
                mdmTerminalMediaEntity.setTerminalCode(terminalCode);
                mdmTerminalMediaEntity.setImageType(TerminalMediaTypeEnum.SHOP.getCode());
                mdmTerminalMediaEntities.add(mdmTerminalMediaEntity);
            }
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmTerminalMediaEntity::getTerminalCode, (Object)terminalCode)).remove();
        if (!CollectionUtils.isEmpty(mdmTerminalMediaEntities)) {
            this.saveBatch(mdmTerminalMediaEntities);
        }
    }
}

