/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.user.req.MdmUserChangePasswordReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.user.service.IMdmUserService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmuser"})
@Api(tags={"MDM-\u7528\u6237\u7ba1\u7406"})
public class MdmUserController {
    private static final Logger log = LoggerFactory.getLogger(MdmUserController.class);
    @Autowired
    private IMdmUserService mdmUserService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<MdmUserRespVo>> list(@RequestBody MdmUserReqVo mdmUserReqVo) {
        PageResult<MdmUserRespVo> result = this.mdmUserService.findList(mdmUserReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5\uff08id\u6216userName\uff09")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<MdmUserRespVo> query(@RequestBody MdmUserReqVo mdmUserReqVo) {
        MdmUserRespVo respVo = this.mdmUserService.query(mdmUserReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody MdmUserReqVo mdmUserReqVo) {
        this.mdmUserService.save(mdmUserReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody MdmUserReqVo mdmUserReqVo) {
        this.mdmUserService.update(mdmUserReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664\uff08\u4f20ids\uff09")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody MdmUserReqVo mdmUserReqVo) {
        this.mdmUserService.deleteBatch(mdmUserReqVo);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528\uff08\u4f20ids\uff09")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody MdmUserReqVo mdmUserReqVo) {
        this.mdmUserService.enableBatch(mdmUserReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528\uff08\u4f20ids\uff09")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody MdmUserReqVo mdmUserReqVo) {
        this.mdmUserService.disableBatch(mdmUserReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    @PostMapping(value={"/changePassword"})
    public Result changePassword(@RequestBody MdmUserChangePasswordReqVo reqVo) {
        this.mdmUserService.changePassword(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u91cd\u7f6e\u7528\u6237\u5bc6\u7801\uff08\u4f20ids\uff09")
    @PostMapping(value={"/resetPassword"})
    public Result resetPassword(@RequestBody MdmUserReqVo reqVo) {
        this.mdmUserService.resetPassword(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7528\u6237\u89e3\u9501\uff08\u4f20ids\uff09")
    @PostMapping(value={"/unlock"})
    public Result unlock(@RequestBody MdmUserReqVo reqVo) {
        this.mdmUserService.unlock(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7528\u6237\u57fa\u672c\u4fe1\u606f\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list_detail"})
    public Result<List<MdmUserRespVo>> listDetail(@RequestBody MdmUserReqVo mdmUserReqVo) {
        return Result.ok(this.mdmUserService.listDetail(mdmUserReqVo));
    }
}

