/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.humanarea.MdmUnbindUserRelationCustomerReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationCustomerPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationCustomerPageRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationCustomerReplaceReqVo;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.IMdmPositionService;
import com.biz.crm.positioncustomer.model.MdmPositionCustomerEntity;
import com.biz.crm.positioncustomer.service.MdmPositionCustomerService;
import com.biz.crm.positionuser.model.MdmPositionUserEntity;
import com.biz.crm.positionuser.service.IMdmPositionUserService;
import com.biz.crm.user.mapper.MdmUserCustomerMapper;
import com.biz.crm.user.service.MdmUserCustomerService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class MdmUserCustomerServiceImpl
implements MdmUserCustomerService {
    @Resource
    private MdmUserCustomerMapper mdmUserCustomerMapper;
    @Resource
    private IMdmPositionService mdmPositionService;
    @Resource
    private MdmPositionCustomerService mdmPositionCustomerService;
    @Resource
    private IMdmPositionUserService mdmPositionUserService;

    @Override
    public PageResult<MdmUserRelationCustomerPageRespVo> findCustomerNotRelateAnyUser(MdmUserRelationCustomerPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmUserRelationCustomerPageRespVo> list = this.mdmUserCustomerMapper.findCustomerNotRelateAnyUser((Page<MdmUserRelationCustomerPageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmUserRelationCustomerPageRespVo> findCustomerNotRelateCurUser(MdmUserRelationCustomerPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        List<MdmUserRelationCustomerPageRespVo> list = this.mdmUserCustomerMapper.findCustomerNotRelateCurUser((Page<MdmUserRelationCustomerPageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmUserRelationCustomerPageRespVo> findCustomerHasRelateCurUser(MdmUserRelationCustomerPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmUserRelationCustomerPageRespVo> list = this.mdmUserCustomerMapper.findCustomerHasRelateCurUser((Page<MdmUserRelationCustomerPageRespVo>)page, reqVo);
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceCustomerPosition(MdmUserRelationCustomerReplaceReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        Assert.notEmpty((Collection)reqVo.getCustomerCodeList(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        MdmPositionEntity position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).select(new SFunction[]{MdmPositionEntity::getPositionCode}).one());
        Assert.notNull((Object)((Object)position), (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7f16\u7801");
        List positionUserEntityList = ((LambdaQueryChainWrapper)this.mdmPositionUserService.lambdaQuery().eq(MdmPositionUserEntity::getUserName, (Object)reqVo.getUserName())).select(new SFunction[]{MdmPositionUserEntity::getPositionCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)positionUserEntityList)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmPositionCustomerService.lambdaUpdate().in(MdmPositionCustomerEntity::getCustomerCode, (Collection)reqVo.getCustomerCodeList())).in(MdmPositionCustomerEntity::getPositionCode, (Collection)positionUserEntityList.stream().map(MdmPositionUserEntity::getPositionCode).collect(Collectors.toList()))).remove();
            reqVo.getCustomerCodeList().forEach(customerCode -> {
                MdmPositionCustomerEntity entity = new MdmPositionCustomerEntity();
                entity.setCustomerCode((String)customerCode);
                entity.setPositionCode(position.getPositionCode());
                this.mdmPositionCustomerService.save((Object)entity);
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unbindRelationCustomer(MdmUnbindUserRelationCustomerReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        Assert.notEmpty((Collection)reqVo.getCustomerCodeList(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        List positionUserEntityList = ((LambdaQueryChainWrapper)this.mdmPositionUserService.lambdaQuery().eq(MdmPositionUserEntity::getUserName, (Object)reqVo.getUserName())).select(new SFunction[]{MdmPositionUserEntity::getPositionCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)positionUserEntityList)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmPositionCustomerService.lambdaUpdate().in(MdmPositionCustomerEntity::getCustomerCode, (Collection)reqVo.getCustomerCodeList())).in(MdmPositionCustomerEntity::getPositionCode, (Collection)positionUserEntityList.stream().map(MdmPositionUserEntity::getPositionCode).collect(Collectors.toList()))).remove();
        }
    }
}

