/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserUnderlingReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserUnderlingRespVo;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.IMdmPositionService;
import com.biz.crm.user.mapper.MdmUserMapper;
import com.biz.crm.user.service.IMdmUserUnderlingService;
import com.biz.crm.util.PageUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmUserUnderlingServiceExpandImpl"})
public class MdmUserUnderlingServiceImpl
implements IMdmUserUnderlingService {
    private static final Logger log = LoggerFactory.getLogger(MdmUserUnderlingServiceImpl.class);
    @Resource
    private MdmUserMapper mdmUserMapper;
    @Resource
    private IMdmPositionService mdmPositionService;

    @Override
    public PageResult<MdmUserUnderlingRespVo> findUserUnderlingList(MdmUserUnderlingReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmUserUnderlingRespVo> list = this.mdmUserMapper.findUserUnderlingList((Page<MdmUserUnderlingRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceParentPosition(MdmUserUnderlingReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getUnderlingPositionCodeList(), (String)"\u8bf7\u9009\u62e9\u4e0b\u7ea7\u804c\u4f4d");
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u8bf7\u9009\u62e9\u4e0a\u7ea7\u804c\u4f4d");
        MdmPositionEntity parentPosition = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).one());
        Assert.notNull((Object)((Object)parentPosition), (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u5b58\u5728");
        List<MdmPositionRespVo> parentList = this.mdmPositionService.findAllParentPositionList(parentPosition.getId(), null);
        List parentCodeList = parentList.stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
        reqVo.getUnderlingPositionCodeList().forEach(positionCode -> {
            Assert.hasText((String)positionCode, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmPositionEntity position = (MdmPositionEntity)((Object)((Object)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionCode, positionCode)).one()));
            Assert.notNull((Object)((Object)position), (String)("\u65e0\u6548\u7684\u4e0b\u7ea7\u804c\u4f4d" + positionCode));
            Assert.isTrue((!parentCodeList.contains(positionCode) ? 1 : 0) != 0, (String)("\u6240\u9009\u804c\u4f4d" + parentPosition.getPositionName() + "\u662f" + position.getPositionName() + "\u7684\u4e0b\u7ea7\u804c\u4f4d\uff0c\u4e0d\u80fd\u9009\u62e9\u4f5c\u4e3a\u4e0a\u7ea7"));
            position.setPositionCode(parentPosition.getPositionCode());
            this.mdmPositionService.updateById((Object)position);
        });
    }
}

