/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.button.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.button.mapper.MdmButtonMapper;
import com.biz.crm.button.model.MdmButtonEntity;
import com.biz.crm.button.service.MdmButtonService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.button.MdmButtonReqVo;
import com.biz.crm.nebular.mdm.button.MdmButtonRespVo;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmButtonServiceExpandImpl"})
public class MdmButtonServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmButtonMapper, MdmButtonEntity>
implements MdmButtonService {
    private static final Logger log = LoggerFactory.getLogger(MdmButtonServiceImpl.class);
    @Resource
    private MdmButtonMapper mdmButtonMapper;

    @Override
    public PageResult<MdmButtonRespVo> findList(MdmButtonReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmButtonRespVo> list = this.mdmButtonMapper.findList((Page<MdmButtonRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmButtonRespVo query(MdmButtonReqVo reqVo) {
        MdmButtonEntity one = (MdmButtonEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((Object)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).eq(!StringUtils.isEmpty((Object)reqVo.getButtonCode()), MdmButtonEntity::getButtonCode, (Object)reqVo.getButtonCode())).one());
        return (MdmButtonRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmButtonRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmButtonReqVo reqVo) {
        this.valid(reqVo);
        Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmButtonEntity::getFunctionCode, (Object)reqVo.getFunctionCode())).eq(MdmButtonEntity::getButtonCode, (Object)reqVo.getButtonCode())).count();
        Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u83dc\u5355\u6309\u94ae\u7f16\u7801\u5df2\u5b58\u5728");
        this.save(CrmBeanUtil.copy((Object)reqVo, MdmButtonEntity.class));
    }

    private void valid(MdmButtonReqVo reqVo) {
        String buttonCode = reqVo.getButtonCode();
        Assert.hasText((String)buttonCode, (String)"\u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String buttonName = reqVo.getButtonName();
        Assert.hasText((String)buttonName, (String)"\u6309\u94ae\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        String functionCode = reqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmButtonReqVo reqVo) {
        this.valid(reqVo);
        String id = reqVo.getId();
        Assert.hasText((String)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)this.getById((Serializable)((Object)id)), (String)"\u6309\u94ae\u4e0d\u5b58\u5728");
        Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ne(BaseIdEntity::getId, (Object)reqVo.getId())).eq(MdmButtonEntity::getFunctionCode, (Object)reqVo.getFunctionCode())).eq(MdmButtonEntity::getButtonCode, (Object)reqVo.getButtonCode())).count();
        Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u83dc\u5355\u6309\u94ae\u7f16\u7801\u5df2\u5b58\u5728");
        this.updateById(CrmBeanUtil.copy((Object)reqVo, MdmButtonEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmButtonReqVo reqVo) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(!CollectionUtils.isEmpty((Collection)reqVo.getIds()), BaseIdEntity::getId, (Collection)reqVo.getIds())).eq(!StringUtils.isEmpty((Object)reqVo.getButtonCode()), MdmButtonEntity::getButtonCode, (Object)reqVo.getButtonCode())).remove();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmButtonReqVo reqVo) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(!CollectionUtils.isEmpty((Collection)reqVo.getIds()), BaseIdEntity::getId, (Object)reqVo.getIds())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmButtonReqVo reqVo) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(!CollectionUtils.isEmpty((Collection)reqVo.getIds()), BaseIdEntity::getId, (Object)reqVo.getIds())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public List<MdmButtonRespVo> listCondition(MdmButtonReqVo mdmButtonReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(!CollectionUtils.isEmpty((Collection)mdmButtonReqVo.getFunctionCodeList()), MdmButtonEntity::getFunctionCode, (Collection)mdmButtonReqVo.getFunctionCodeList())).eq(!StringUtils.isEmpty((Object)mdmButtonReqVo.getFunctionCode()), MdmButtonEntity::getFunctionCode, (Object)mdmButtonReqVo.getFunctionCode())).like(!StringUtils.isEmpty((Object)mdmButtonReqVo.getButtonCode()), MdmButtonEntity::getButtonCode, (Object)mdmButtonReqVo.getButtonCode())).like(!StringUtils.isEmpty((Object)mdmButtonReqVo.getButtonName()), MdmButtonEntity::getButtonName, (Object)mdmButtonReqVo.getButtonName())).list();
        return CrmBeanUtil.copyList((List)list, MdmButtonRespVo.class);
    }
}

