/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.function.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.button.service.MdmButtonRoleService;
import com.biz.crm.button.service.MdmButtonService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.function.mapper.MdmFunctionMapper;
import com.biz.crm.function.model.MdmFunctionEntity;
import com.biz.crm.function.service.MdmFunctionRoleService;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.nebular.mdm.button.MdmButtonReqVo;
import com.biz.crm.nebular.mdm.button.MdmButtonRespVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionButtonReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionButtonRespVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionButtonSubReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmFunctionServiceExpandImpl"})
public class MdmFunctionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmFunctionMapper, MdmFunctionEntity>
implements MdmFunctionService {
    private static final Logger log = LoggerFactory.getLogger(MdmFunctionServiceImpl.class);
    @Autowired
    private MdmFunctionMapper mdmFunctionMapper;
    @Autowired
    private MdmButtonService mdmButtonService;
    @Autowired
    private MdmFunctionRoleService mdmFunctionRoleService;
    @Autowired
    private MdmButtonRoleService mdmButtonRoleService;

    @Override
    public MdmFunctionRespVo query(MdmFunctionReqVo mdmFunctionReqVo) {
        MdmFunctionEntity one = (MdmFunctionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getId()), BaseIdEntity::getId, (Object)mdmFunctionReqVo.getId())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionCode()), MdmFunctionEntity::getFunctionCode, (Object)mdmFunctionReqVo.getFunctionCode())).in(!CollectionUtils.isEmpty((Collection)mdmFunctionReqVo.getFunctionCodeList()), MdmFunctionEntity::getFunctionCode, (Collection)mdmFunctionReqVo.getFunctionCodeList())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getParentCode()), MdmFunctionEntity::getFunctionCode, (Object)mdmFunctionReqVo.getParentCode())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionModule()), MdmFunctionEntity::getFunctionModule, (Object)mdmFunctionReqVo.getFunctionModule())).one());
        return (MdmFunctionRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmFunctionRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmFunctionReqVo reqVo) {
        if (StringUtils.isEmpty((Object)reqVo.getFunctionCode())) {
            reqVo.setFunctionCode(CodeUtil.generateCode());
        }
        this.valid(reqVo);
        this.save(CrmBeanUtil.copy((Object)reqVo, MdmFunctionEntity.class));
    }

    private void valid(MdmFunctionReqVo reqVo) {
        if (StringUtils.isEmpty((Object)reqVo.getFunctionOrder())) {
            reqVo.setFunctionOrder("1");
        }
        Assert.hasText((String)reqVo.getFunctionCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getFunctionName(), (String)"\u83dc\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getFunctionModule(), (String)"\u83dc\u5355\u6a21\u5757\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getFunctionConfig(), (String)"\u83dc\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)reqVo.getFunctionOrder().matches("^\\d+$"), (String)"\u6392\u5e8f\u5fc5\u987b\u662f\u6570\u5b57");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmFunctionReqVo reqVo) {
        this.valid(reqVo);
        Assert.hasText((String)reqVo.getId(), (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmFunctionEntity entity = (MdmFunctionEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        Assert.notNull((Object)((Object)entity), (String)"\u83dc\u5355\u4e0d\u5b58\u5728");
        this.updateById(CrmBeanUtil.copy((Object)reqVo, MdmFunctionEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmFunctionReqVo reqVo) {
        String functionCode = reqVo.getFunctionCode();
        List ids = reqVo.getIds();
        Assert.isTrue((!StringUtils.isEmpty((Object)functionCode) || !CollectionUtils.isEmpty((Collection)ids) ? 1 : 0) != 0, (String)"\u83dc\u5355\u7f16\u7801\u6216id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(!StringUtils.isEmpty((Object)functionCode), MdmFunctionEntity::getFunctionCode, (Object)functionCode)).in(!CollectionUtils.isEmpty((Collection)ids), BaseIdEntity::getId, (Collection)ids)).remove();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmFunctionReqVo reqVo) {
        String functionCode = reqVo.getFunctionCode();
        List ids = reqVo.getIds();
        Assert.isTrue((!StringUtils.isEmpty((Object)functionCode) || !CollectionUtils.isEmpty((Collection)ids) ? 1 : 0) != 0, (String)"\u83dc\u5355\u7f16\u7801\u6216id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(!StringUtils.isEmpty((Object)functionCode), MdmFunctionEntity::getFunctionCode, (Object)functionCode)).in(!CollectionUtils.isEmpty((Collection)ids), BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmFunctionReqVo reqVo) {
        String functionCode = reqVo.getFunctionCode();
        List ids = reqVo.getIds();
        Assert.isTrue((!StringUtils.isEmpty((Object)functionCode) || !CollectionUtils.isEmpty((Collection)ids) ? 1 : 0) != 0, (String)"\u83dc\u5355\u7f16\u7801\u6216id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(!StringUtils.isEmpty((Object)functionCode), MdmFunctionEntity::getFunctionCode, (Object)functionCode)).in(!CollectionUtils.isEmpty((Collection)ids), BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public List<MdmFunctionRespVo> systemList(MdmFunctionReqVo mdmFunctionReqVo) {
        mdmFunctionReqVo.setFunctionConfig("0");
        return this.listCondition(mdmFunctionReqVo);
    }

    @Override
    public List<MdmFunctionRespVo> systemTree(MdmFunctionReqVo mdmFunctionReqVo) {
        List<MdmFunctionRespVo> mdmFunctionRespVos = this.systemList(mdmFunctionReqVo);
        return this.treeConvert(mdmFunctionRespVos);
    }

    private List<MdmFunctionRespVo> treeConvert(List<MdmFunctionRespVo> mdmFunctionRespVos) {
        ArrayList<MdmFunctionRespVo> root = new ArrayList<MdmFunctionRespVo>();
        for (MdmFunctionRespVo mdmFunctionRespVo : mdmFunctionRespVos) {
            ArrayList<MdmFunctionRespVo> children;
            if (StringUtils.isEmpty((Object)mdmFunctionRespVo.getParentCode())) {
                root.add(mdmFunctionRespVo);
            }
            if ((children = mdmFunctionRespVo.getChildren()) == null) {
                children = new ArrayList<MdmFunctionRespVo>();
            }
            for (MdmFunctionRespVo functionRespVo : mdmFunctionRespVos) {
                if (!mdmFunctionRespVo.getFunctionCode().equals(functionRespVo.getParentCode())) continue;
                children.add(functionRespVo);
            }
            mdmFunctionRespVo.setChildren(children);
        }
        return root;
    }

    @Override
    public List<MdmFunctionRespVo> listCondition(MdmFunctionReqVo mdmFunctionReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionCode()), MdmFunctionEntity::getFunctionCode, (Object)mdmFunctionReqVo.getFunctionCode())).like(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionName()), MdmFunctionEntity::getFunctionName, (Object)mdmFunctionReqVo.getFunctionName())).in(!CollectionUtils.isEmpty((Collection)mdmFunctionReqVo.getFunctionCodeList()), MdmFunctionEntity::getFunctionCode, (Collection)mdmFunctionReqVo.getFunctionCodeList())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getParentCode()), MdmFunctionEntity::getFunctionCode, (Object)mdmFunctionReqVo.getParentCode())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionModule()), MdmFunctionEntity::getFunctionModule, (Object)mdmFunctionReqVo.getFunctionModule())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionConfig()), MdmFunctionEntity::getFunctionConfig, (Object)mdmFunctionReqVo.getFunctionConfig())).orderByAsc(MdmFunctionEntity::getFunctionOrder)).list();
        return CrmBeanUtil.copyList((List)list, MdmFunctionRespVo.class);
    }

    @Override
    public List<MdmFunctionButtonRespVo> listButton(MdmFunctionReqVo mdmFunctionReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionCode()), MdmFunctionEntity::getFunctionCode, (Object)mdmFunctionReqVo.getFunctionCode())).like(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionName()), MdmFunctionEntity::getFunctionName, (Object)mdmFunctionReqVo.getFunctionName())).in(!CollectionUtils.isEmpty((Collection)mdmFunctionReqVo.getFunctionCodeList()), MdmFunctionEntity::getFunctionCode, (Collection)mdmFunctionReqVo.getFunctionCodeList())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getParentCode()), MdmFunctionEntity::getFunctionCode, (Object)mdmFunctionReqVo.getParentCode())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionModule()), MdmFunctionEntity::getFunctionModule, (Object)mdmFunctionReqVo.getFunctionModule())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionConfig()), MdmFunctionEntity::getFunctionConfig, (Object)mdmFunctionReqVo.getFunctionConfig())).orderByAsc(MdmFunctionEntity::getFunctionOrder)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        List<MdmFunctionButtonRespVo> mdmFunctionButtonRespVos = CrmBeanUtil.copyList((List)list, MdmFunctionButtonRespVo.class);
        String roleCode = mdmFunctionReqVo.getRoleCode();
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        mdmFunctionButtonRespVos = this.convertSelectFunction(mdmFunctionButtonRespVos, roleCode);
        this.setUpFunctionButton(mdmFunctionButtonRespVos, roleCode);
        return this.convertFunctionButtonToTree(mdmFunctionButtonRespVos);
    }

    private List<MdmFunctionButtonRespVo> convertFunctionButtonToTree(List<MdmFunctionButtonRespVo> mdmFunctionButtonRespVos) {
        ArrayList<MdmFunctionButtonRespVo> root = new ArrayList<MdmFunctionButtonRespVo>();
        for (MdmFunctionButtonRespVo mdmFunctionButtonRespVo : mdmFunctionButtonRespVos) {
            if (StringUtils.isEmpty((Object)mdmFunctionButtonRespVo.getParentCode())) {
                root.add(mdmFunctionButtonRespVo);
            }
            List children = Optional.ofNullable(mdmFunctionButtonRespVo.getChildren()).orElse(new ArrayList());
            for (MdmFunctionButtonRespVo functionButtonRespVo : mdmFunctionButtonRespVos) {
                if (!mdmFunctionButtonRespVo.getFunctionCode().equals(functionButtonRespVo.getParentCode())) continue;
                children.add(functionButtonRespVo);
            }
            mdmFunctionButtonRespVo.setChildren(children);
        }
        return root;
    }

    private void setUpFunctionButton(List<MdmFunctionButtonRespVo> mdmFunctionButtonRespVos, String roleCode) {
        List functionCodeList = mdmFunctionButtonRespVos.stream().map(MdmFunctionButtonRespVo::getFunctionCode).collect(Collectors.toList());
        MdmButtonReqVo mdmButtonReqVo = new MdmButtonReqVo();
        mdmButtonReqVo.setFunctionCodeList(functionCodeList);
        List<Object> mdmButtonRespVos = this.mdmButtonService.listCondition(mdmButtonReqVo);
        if (!CollectionUtils.isEmpty(mdmButtonRespVos)) {
            List<String> relationButtonCodeList = this.mdmButtonRoleService.findButtonCodeByRole(roleCode);
            mdmButtonRespVos = mdmButtonRespVos.stream().peek(x -> x.setSelect(!CollectionUtils.isEmpty((Collection)relationButtonCodeList) && relationButtonCodeList.contains(x.getButtonCode()) ? "1" : "0")).collect(Collectors.toList());
            Map<String, List<MdmButtonRespVo>> buttonMap = mdmButtonRespVos.stream().collect(Collectors.groupingBy(MdmButtonRespVo::getFunctionCode));
            for (MdmFunctionButtonRespVo mdmFunctionButtonRespVo : mdmFunctionButtonRespVos) {
                mdmFunctionButtonRespVo.setMdmButtonVos(buttonMap.get(mdmFunctionButtonRespVo.getFunctionCode()));
            }
        }
    }

    private List<MdmFunctionButtonRespVo> convertSelectFunction(List<MdmFunctionButtonRespVo> mdmFunctionButtonRespVos, String roleCode) {
        List<String> relationFunctionCodeList = this.mdmFunctionRoleService.findFunctionCodeByRole(roleCode);
        return mdmFunctionButtonRespVos.stream().peek(x -> x.setSelect(!CollectionUtils.isEmpty((Collection)relationFunctionCodeList) && relationFunctionCodeList.contains(x.getFunctionCode()) ? "1" : "0")).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveListButton(MdmFunctionButtonReqVo mdmFunctionButtonReqVo) {
        String roleCode = mdmFunctionButtonReqVo.getRoleCode();
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List mdmFunctionButtonSubReqVos = mdmFunctionButtonReqVo.getMdmFunctionButtonSubReqVos();
        Assert.notEmpty((Collection)mdmFunctionButtonSubReqVos, (String)"\u83dc\u5355\u53ca\u6309\u94ae\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> functionCodeList = new ArrayList<String>();
        ArrayList<String> buttonCodeList = new ArrayList<String>();
        List currentFunctionList = mdmFunctionButtonSubReqVos;
        while (!CollectionUtils.isEmpty((Collection)currentFunctionList)) {
            List currentFunctionCodeList = currentFunctionList.stream().filter(x -> !StringUtils.isEmpty((Object)x.getSelect()) && "1".equals(x.getSelect())).map(MdmFunctionButtonSubReqVo::getFunctionCode).collect(Collectors.toList());
            functionCodeList.addAll(currentFunctionCodeList);
            List currentButtonCodeList = currentFunctionList.stream().flatMap(x -> x.getMdmButtonVos().stream()).filter(x -> !StringUtils.isEmpty((Object)x.getSelect()) && "1".equals(x.getSelect())).map(MdmButtonReqVo::getButtonCode).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(currentButtonCodeList)) {
                buttonCodeList.addAll(currentButtonCodeList);
            }
            currentFunctionList = currentFunctionList.stream().flatMap(x -> x.getChildren().stream()).collect(Collectors.toList());
        }
        this.mdmFunctionRoleService.update(roleCode, functionCodeList);
        this.mdmButtonRoleService.update(roleCode, buttonCodeList);
    }

    @Override
    public PageResult<MdmFunctionRespVo> functionPage(MdmFunctionReqVo mdmFunctionReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmFunctionReqVo.getPageNum(), (Integer)mdmFunctionReqVo.getPageSize());
        List<MdmFunctionRespVo> list = this.mdmFunctionMapper.findList((Page<MdmFunctionRespVo>)page, mdmFunctionReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

