/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.org.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgPositionRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgSelectRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgTreeRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerUpdateReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgPositionPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgPositionUpdateReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgTerminalPageReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalRespVo;
import com.biz.crm.org.service.IEngineOrgService;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/engineorg"})
@CrmGlobalLog
public class EngineOrgController {
    private static final Logger log = LoggerFactory.getLogger(EngineOrgController.class);
    @Resource
    private IEngineOrgService engineOrgService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/page"})
    @CrmDictMethod
    public Result<PageResult<EngineOrgRespVo>> page(@RequestBody EngineOrgReqVo engineOrgReqVo) {
        PageResult<EngineOrgRespVo> result = this.engineOrgService.findList(engineOrgReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u7ec4\u7ec7-\u7ec8\u7aef\u5173\u8054:\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/terminal_page"})
    @CrmDictMethod
    public Result<PageResult<MdmTerminalRespVo>> page(@RequestBody MdmOrgTerminalPageReqVo mdmOrgTerminalPageReqVo) {
        return Result.ok(this.engineOrgService.findList(mdmOrgTerminalPageReqVo));
    }

    @ApiOperation(value="\u7ec4\u7ec7-\u5ba2\u6237\u5173\u8054:\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/customer_page"})
    @CrmDictMethod
    public Result<PageResult<MdmCustomerMsgRespVo>> page(@RequestBody MdmOrgCustomerPageReqVo mdmOrgCustomerPageReqVo) {
        return Result.ok(this.engineOrgService.findList(mdmOrgCustomerPageReqVo));
    }

    @ApiOperation(value="\u7ec4\u7ec7-\u804c\u4f4d\u5173\u8054:\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/position_page"})
    @CrmDictMethod
    public Result<PageResult<EngineOrgPositionRespVo>> page(@RequestBody MdmOrgPositionPageReqVo mdmOrgPositionPageReqVo) {
        return Result.ok(this.engineOrgService.findOrgPositionList(mdmOrgPositionPageReqVo));
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    public Result<List<EngineOrgRespVo>> list(@RequestBody EngineOrgReqVo engineOrgReqVo) {
        return Result.ok(this.engineOrgService.listCondition(engineOrgReqVo));
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    public Result<EngineOrgRespVo> query(@RequestBody EngineOrgReqVo engineOrgReqVo) {
        EngineOrgRespVo respVo = this.engineOrgService.query(engineOrgReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody EngineOrgReqVo engineOrgReqVo) {
        this.engineOrgService.save(engineOrgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result update(@RequestBody EngineOrgReqVo engineOrgReqVo) {
        this.engineOrgService.update(engineOrgReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody EngineOrgReqVo engineOrgReqVo) {
        this.engineOrgService.deleteBatch(engineOrgReqVo);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    public Result enable(@RequestBody EngineOrgReqVo engineOrgReqVo) {
        this.engineOrgService.enableBatch(engineOrgReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    public Result disable(@RequestBody EngineOrgReqVo engineOrgReqVo) {
        this.engineOrgService.disableBatch(engineOrgReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u4e0e\u7ec8\u7aef\u5173\u8054\u7684\u7ec4\u7ec7\u7f16\u7801")
    @PostMapping(value={"/update_terminal_org"})
    public Result<Object> terminalOrgCode(@Valid @RequestBody MdmOrgTerminalReqVo mdmOrgTerminalReqVo) {
        this.engineOrgService.terminalOrgCode(mdmOrgTerminalReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u4e0e\u5ba2\u6237\u5173\u8054\u7684\u7ec4\u7ec7\u7f16\u7801")
    @PostMapping(value={"/update_customer_org"})
    public Result<Object> customerOrgCode(@Valid @RequestBody MdmOrgCustomerUpdateReqVo mdmOrgCustomerUpdateReqVo) {
        this.engineOrgService.updateOrgCode(mdmOrgCustomerUpdateReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u4e0e\u804c\u4f4d\u5173\u8054\u7684\u7ec4\u7ec7\u7f16\u7801")
    @PostMapping(value={"/update_position_org"})
    public Result<Object> positionOrgCode(@Valid @RequestBody MdmOrgPositionUpdateReqVo mdmOrgPositionUpdateReqVo) {
        this.engineOrgService.positionOrgCode(mdmOrgPositionUpdateReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u5f53\u524d\u53ca\u4e0b\u7ea7\u7ec4\u7ec7\u6811\uff0c\u4e0d\u4f20\u5219\u67e5\u8be2\u5168\u90e8\u7ec4\u7ec7\u6811")
    @PostMapping(value={"/tree"})
    public Result<List<EngineOrgTreeRespVo>> findCurrentAndSubOrgTree(@RequestBody EngineOrgSearchReqVo engineOrgSearchReqVo) {
        return Result.ok(this.engineOrgService.findCurrentAndSubOrgTree(engineOrgSearchReqVo));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u5f53\u524d\u53ca\u4e0b\u7ea7\u7ec4\u7ec7\u96c6\u5408\uff0c\u4e0d\u4f20\u5219\u67e5\u8be2\u5168\u90e8\u7ec4\u7ec7")
    @PostMapping(value={"/sub"})
    public Result<List<EngineOrgRespVo>> findCurrentAndSubOrgCodeList(@RequestBody EngineOrgSearchReqVo engineOrgSearchReqVo) {
        return Result.ok(this.engineOrgService.findCurrentAndSubOrgCodeList(engineOrgSearchReqVo));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u4e0b\u62c9\u6846\u67e5\u8be2")
    @PostMapping(value={"/select"})
    public Result<List<EngineOrgSelectRespVo>> orgSelect(@RequestBody EngineOrgReqVo engineOrgReqVo) {
        return Result.ok(this.engineOrgService.orgSelect(engineOrgReqVo));
    }

    @ApiOperation(value="\u91cd\u7f6e\u964d\u7ef4\u7f16\u7801")
    @PostMapping(value={"/reset_rule_code"})
    public Result<Object> setUpRuleCode() {
        this.engineOrgService.setUpRuleCode();
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u53ca\u6240\u6709\u4e0b\u7ea7\u7ec4\u7ec7")
    @PostMapping(value={"/findOrgChildrenList"})
    public Result<List<EngineOrgRespVo>> findOrgChildrenList(@RequestBody EngineOrgReqVo engineOrgReqVo) {
        return Result.ok(this.engineOrgService.findOrgChildrenList(engineOrgReqVo.getId(), engineOrgReqVo.getOrgCode()));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u53ca\u6240\u6709\u4e0a\u7ea7\u7ec4\u7ec7")
    @PostMapping(value={"/findAllOrgParentList"})
    public Result<List<EngineOrgRespVo>> findAllOrgParentList(@RequestBody EngineOrgReqVo engineOrgReqVo) {
        return Result.ok(this.engineOrgService.findOrgParentList(engineOrgReqVo.getId(), engineOrgReqVo.getOrgCode()));
    }
}

