/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.position.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.position.mapper.MdmPositionTerminalMapper;
import com.biz.crm.position.model.MdmPositionTerminalEntity;
import com.biz.crm.position.service.MdmPositionTerminalService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmPositionTerminalServiceExpandImpl"})
public class MdmPositionTerminalServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPositionTerminalMapper, MdmPositionTerminalEntity>
implements MdmPositionTerminalService {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionTerminalServiceImpl.class);

    @Override
    public List<String> findTerminalCodeByPositionCode(List<String> positionCodeList) {
        if (CollectionUtils.isEmpty(positionCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionTerminalEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionTerminalEntity::getTerminalCode}).list().stream().map(MdmPositionTerminalEntity::getTerminalCode).collect(Collectors.toList());
    }

    @Override
    public List<String> findPositionCodeByTerminalCode(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionTerminalEntity::getTerminalCode, terminalCodeList)).select(new SFunction[]{MdmPositionTerminalEntity::getPositionCode}).list().stream().map(MdmPositionTerminalEntity::getPositionCode).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addRelation(String terminalCode, String positionCode) {
        if (StringUtils.isNotEmpty((String)terminalCode) && StringUtils.isNotEmpty((String)positionCode)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionTerminalEntity::getTerminalCode, (Object)terminalCode)).eq(MdmPositionTerminalEntity::getPositionCode, (Object)positionCode)).remove();
            MdmPositionTerminalEntity entity = new MdmPositionTerminalEntity();
            entity.setTerminalCode(terminalCode);
            entity.setPositionCode(positionCode);
            this.save((Object)entity);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replacePosition(List<String> ids, String positionCode) {
        if (CollectionUtil.listNotEmptyNotSizeZero(ids) && StringUtils.isNotEmpty((String)positionCode)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(MdmPositionTerminalEntity::getPositionCode, (Object)positionCode)).update();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRelations(List<String> ids) {
        if (CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByTerminal(String terminalCode) {
        if (StringUtils.isNotEmpty((String)terminalCode)) {
            this.removeByTerminals(Collections.singletonList(terminalCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByTerminals(List<String> terminalCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(terminalCodes)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionTerminalEntity::getTerminalCode, terminalCodes)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByPosition(String positionCode) {
        if (StringUtils.isNotEmpty((String)positionCode)) {
            this.removeByPositions(Collections.singletonList(positionCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByPositions(List<String> positionCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodes)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionTerminalEntity::getPositionCode, positionCodes)).remove();
        }
    }
}

