/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.roleuser.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.roleuser.mapper.EngineRoleUserMapper;
import com.biz.crm.roleuser.model.EngineRoleUserEntity;
import com.biz.crm.roleuser.service.IEngineRoleUserService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"EngineRoleUserServiceExpandImpl"})
public class EngineRoleUserServiceImpl
extends ServiceImpl<EngineRoleUserMapper, EngineRoleUserEntity>
implements IEngineRoleUserService {
    private static final Logger log = LoggerFactory.getLogger(EngineRoleUserServiceImpl.class);
    @Resource
    private EngineRoleUserMapper engineRoleUserMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveUserRole(String userAccount, String roleCode) {
        List list;
        if (StringUtils.isNotEmpty((String)userAccount) && StringUtils.isNotEmpty((String)roleCode) && CollectionUtil.listEmpty((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(EngineRoleUserEntity::getUserAccount, (Object)userAccount)).eq(EngineRoleUserEntity::getRoleCode, (Object)roleCode)).list()))) {
            EngineRoleUserEntity entity = new EngineRoleUserEntity();
            entity.setUserAccount(userAccount);
            entity.setRoleCode(roleCode);
            this.save((Object)entity);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveUserRoles(String userAccount, List<String> roleCodes) {
        if (roleCodes != null) {
            roleCodes.forEach(roleCode -> this.saveUserRole(userAccount, (String)roleCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRoleCode(String roleCode) {
        if (StringUtils.isNotEmpty((String)roleCode)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(EngineRoleUserEntity::getRoleCode, (Object)roleCode)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRoleCodes(List<String> roleCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(roleCodes)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(EngineRoleUserEntity::getRoleCode, roleCodes)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeUserAccount(String userAccount) {
        if (StringUtils.isNotEmpty((String)userAccount)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(EngineRoleUserEntity::getUserAccount, (Object)userAccount)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeUserAccounts(List<String> userAccounts) {
        if (CollectionUtil.listNotEmptyNotSizeZero(userAccounts)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(EngineRoleUserEntity::getUserAccount, userAccounts)).remove();
        }
    }
}

