/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmTerminalOrgSearchReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmCusOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmPositionTerminalSearchReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalPrimaryContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalPrimaryContactPageRespVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalRespVo;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmTerminalController"})
@Api(tags={"\u7ec8\u7aef\u4fe1\u606f"})
@CrmGlobalLog
public class MdmTerminalController {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalController.class);
    @Autowired
    private MdmTerminalService mdmTerminalService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/page"})
    @CrmDictMethod
    public Result<PageResult<MdmTerminalRespVo>> page(@RequestBody MdmTerminalReqVo mdmTerminalReqVo) {
        PageResult<MdmTerminalRespVo> result = this.mdmTerminalService.findList(mdmTerminalReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="terminalCode", value="\u7ec8\u7aef\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @PostMapping(value={"/query"})
    public Result<MdmTerminalRespVo> query(@RequestParam(value="id", required=false) String id, @RequestParam(value="terminalCode", required=false) String terminalCode) {
        MdmTerminalReqVo mdmTerminalReqVo = new MdmTerminalReqVo();
        mdmTerminalReqVo.setId(id);
        mdmTerminalReqVo.setTerminalCode(terminalCode);
        MdmTerminalRespVo model = this.mdmTerminalService.query(mdmTerminalReqVo);
        return Result.ok((Object)model);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result<Object> save(@RequestBody MdmTerminalReqVo mdmTerminalReqVo) {
        this.mdmTerminalService.save(mdmTerminalReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result<Object> update(@RequestBody MdmTerminalReqVo mdmTerminalReqVo) {
        this.mdmTerminalService.update(mdmTerminalReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result<Object> delete(@RequestBody List<String> ids) {
        MdmTerminalReqVo mdmTerminalReqVo = new MdmTerminalReqVo();
        mdmTerminalReqVo.setIds(ids);
        this.mdmTerminalService.deleteBatch(mdmTerminalReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u542f\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    public Result<Object> enable(@RequestBody List<String> ids) {
        MdmTerminalReqVo mdmTerminalReqVo = new MdmTerminalReqVo();
        mdmTerminalReqVo.setIds(ids);
        this.mdmTerminalService.enableBatch(mdmTerminalReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7981\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    public Result<Object> disable(@RequestBody List<String> ids) {
        MdmTerminalReqVo mdmTerminalReqVo = new MdmTerminalReqVo();
        mdmTerminalReqVo.setIds(ids);
        this.mdmTerminalService.disableBatch(mdmTerminalReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801")
    @PostMapping(value={"/updateCusOrgCode"})
    public Result<Object> updateCusOrgCode(@RequestBody MdmCusOrgTerminalReqVo mdmCusOrgTerminalReqVo) {
        this.mdmTerminalService.updateCusOrgCode(mdmCusOrgTerminalReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u7ec8\u7aef\u7f16\u7801\u96c6\u5408")
    @PostMapping(value={"/findByOrgCodeList"})
    public Result<List<String>> findByOrgCodeList(@RequestBody List<String> list) {
        return Result.ok(this.mdmTerminalService.findByOrgCodeList(list));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u4e0a\u7ea7\u5ba2\u6237")
    @PostMapping(value={"/findCustomerList"})
    public Result<List<MdmCustomerMsgRespVo>> findCustomerList(@RequestBody MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo) {
        return Result.ok(this.mdmTerminalService.findCustomerList(mdmCustomerOrgSearchReqVo));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u53ca\u4e0b\u7ea7\u7ec8\u7aef")
    @PostMapping(value={"/findCurrentAndSubTerminalList"})
    public Result<List<MdmTerminalRespVo>> findCurrentAndSubTerminalList(@RequestBody MdmTerminalOrgSearchReqVo mdmTerminalOrgSearchReqVo) {
        return Result.ok(this.mdmTerminalService.findCurrentAndSubTerminalList(mdmTerminalOrgSearchReqVo));
    }

    @ApiOperation(value="\u6761\u4ef6\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/listCondition"})
    public Result<List<MdmTerminalRespVo>> listCondition(@RequestBody MdmTerminalReqVo mdmTerminalReqVo) {
        return Result.ok(this.mdmTerminalService.listCondition(mdmTerminalReqVo));
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4did\u6216\u7f16\u7801\u67e5\u8be2\u7ec8\u7aef\u5217\u8868")
    @PostMapping(value={"/findPositionTerminalList"})
    public Result<List<MdmTerminalRespVo>> findPositionTerminalList(@RequestBody MdmPositionTerminalSearchReqVo mdmPositionTerminalSearchReqVo) {
        return Result.ok(this.mdmTerminalService.findPositionTerminalList(mdmPositionTerminalSearchReqVo));
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4did\u6216\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u53ca\u6240\u6709\u4e0b\u7ea7\u804c\u4f4d\u5bf9\u5e94\u7ec8\u7aef\u5217\u8868")
    @PostMapping(value={"/findCurrentAndSybPositionTerminalList"})
    public Result<List<MdmTerminalRespVo>> findCurrentAndSybPositionTerminalList(@RequestBody MdmPositionTerminalSearchReqVo mdmPositionTerminalSearchReqVo) {
        return Result.ok(this.mdmTerminalService.findCurrentAndSybPositionTerminalList(mdmPositionTerminalSearchReqVo));
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u7ec8\u7aef\u53ca\u8054\u7cfb\u4eba\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/terminalContactPage"})
    public Result<PageResult<MdmTerminalPrimaryContactPageRespVo>> terminalContactPage(@RequestBody MdmTerminalPrimaryContactPageReqVo mdmTerminalPrimaryContactPageReqVo) {
        return Result.ok(this.mdmTerminalService.terminalContactPage(mdmTerminalPrimaryContactPageReqVo));
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u4e0e\u7ec8\u7aef\u5173\u8054\u7684\u4f01\u4e1a\u7ec4\u7ec7\u7f16\u7801")
    @PostMapping(value={"/batchUpdateTerminalOrg"})
    public Result batchUpdateTerminalOrg(@RequestBody MdmOrgTerminalReqVo reqVo) {
        this.mdmTerminalService.batchUpdateTerminalOrg(reqVo);
        return Result.ok();
    }
}

