/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.availablelistrule.advise.Advise;
import com.biz.crm.availablelistrule.advise.strategy.TerminalChangeAdviseTargetStrategy;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerTerminalService;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.TerminalMediaTypeEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTerminalReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmTerminalOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmCusOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmPositionTerminalSearchReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalContactReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalMediaReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalMediaRespVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalPrimaryContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalPrimaryContactPageRespVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.position.service.MdmPositionTerminalService;
import com.biz.crm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.service.MdmTerminalContactService;
import com.biz.crm.terminal.service.MdmTerminalMediaService;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.utils.DatabaseTypeUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmTerminalServiceExpandImpl"})
public class MdmTerminalServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmTerminalMapper, MdmTerminalEntity>
implements MdmTerminalService {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalServiceImpl.class);
    @Autowired
    private MdmTerminalMapper mdmTerminalMapper;
    @Autowired
    private MdmTerminalContactService mdmTerminalContactService;
    @Autowired
    private MdmTerminalSupplyService mdmTerminalSupplyService;
    @Resource
    private TerminalChangeAdviseTargetStrategy terminalChangeAdviseTargetStrategy;
    @Resource
    private Advise advise;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmCustomerTerminalService mdmCustomerTerminalService;
    @Resource
    private MdmTerminalMediaService mdmTerminalMediaService;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmPositionTerminalService mdmPositionTerminalService;

    @Override
    public PageResult<MdmTerminalRespVo> findList(MdmTerminalReqVo mdmTerminalReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmTerminalReqVo.getPageNum(), (Integer)mdmTerminalReqVo.getPageSize());
        if (!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getCode())) {
            List<String> orgCodeList = this.mdmOrgService.findAllChildrenOrgCodeList(null, mdmTerminalReqVo.getCode());
            mdmTerminalReqVo.setOrgCodeList(orgCodeList);
        }
        List<MdmTerminalRespVo> list = this.mdmTerminalMapper.findList((Page<MdmTerminalRespVo>)page, mdmTerminalReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmTerminalRespVo query(MdmTerminalReqVo mdmTerminalReqVo) {
        MdmTerminalRespVo mdmTerminalRespVo = this.mdmTerminalMapper.query(mdmTerminalReqVo);
        Assert.notNull((Object)mdmTerminalRespVo, (String)"\u7ec8\u7aef\u4e0d\u5b58\u5728");
        String terminalCode = mdmTerminalRespVo.getTerminalCode();
        MdmTerminalContactReqVo mdmTerminalContactReqVo = new MdmTerminalContactReqVo();
        mdmTerminalContactReqVo.setTerminalCode(terminalCode);
        mdmTerminalRespVo.setMdmTerminalContactVos(this.mdmTerminalContactService.listCondition(mdmTerminalContactReqVo));
        mdmTerminalRespVo.setMdmTerminalSupplyVos(this.mdmTerminalSupplyService.listCondition(mdmTerminalRespVo.getTerminalCode()));
        MdmTerminalMediaReqVo mdmTerminalMediaReqVo = new MdmTerminalMediaReqVo();
        mdmTerminalMediaReqVo.setTerminalCode(mdmTerminalRespVo.getTerminalCode());
        List<MdmTerminalMediaRespVo> list = this.mdmTerminalMediaService.findList(mdmTerminalMediaReqVo);
        if (!CollectionUtils.isEmpty(list)) {
            mdmTerminalRespVo.setLicenseImagePath(list.stream().filter(x -> TerminalMediaTypeEnum.LICENSE.getCode().equals(x.getImageType())).map(MdmTerminalMediaRespVo::getImagePath).collect(Collectors.toList()));
            mdmTerminalRespVo.setShopImagePath(list.stream().filter(x -> TerminalMediaTypeEnum.SHOP.getCode().equals(x.getImageType())).map(MdmTerminalMediaRespVo::getImagePath).collect(Collectors.toList()));
        }
        return mdmTerminalRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmTerminalReqVo mdmTerminalReqVo) {
        if (StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getTerminalCode())) {
            mdmTerminalReqVo.setTerminalCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_TERMINAL.getCode()));
        } else {
            Integer count = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalEntity::getTerminalCode, (Object)mdmTerminalReqVo.getTerminalCode())).count();
            Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728");
        }
        this.save(CrmBeanUtil.copy((Object)mdmTerminalReqVo, MdmTerminalEntity.class));
        this.updateContact(mdmTerminalReqVo);
        this.sendChangeMsg(Collections.singletonList(mdmTerminalReqVo.getTerminalCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmTerminalReqVo mdmTerminalReqVo) {
        String id = mdmTerminalReqVo.getId();
        String terminalCode = mdmTerminalReqVo.getTerminalCode();
        Assert.hasText((String)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)id, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmTerminalEntity entity = (MdmTerminalEntity)((Object)this.getById((Serializable)((Object)mdmTerminalReqVo.getId())));
        Assert.notNull((Object)((Object)entity), (String)"\u7ec8\u7aef\u4e0d\u5b58\u5728");
        Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ne(BaseIdEntity::getId, (Object)id)).eq(MdmTerminalEntity::getTerminalCode, (Object)terminalCode)).count();
        Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728");
        this.updateById(CrmBeanUtil.copy((Object)mdmTerminalReqVo, MdmTerminalEntity.class));
        this.updateContact(mdmTerminalReqVo);
        this.sendChangeMsg(Collections.singletonList(mdmTerminalReqVo.getTerminalCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmTerminalReqVo mdmTerminalReqVo) {
        List ids = mdmTerminalReqVo.getIds();
        this.removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmTerminalReqVo mdmTerminalReqVo) {
        List ids = mdmTerminalReqVo.getIds();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((ids.size() == list.size() ? 1 : 0) != 0, (String)"\u53ea\u80fd\u542f\u7528\u72b6\u6001\u4e3a\u201d\u7981\u7528\u201c\u7684\u7ec8\u7aef");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmTerminalReqVo mdmTerminalReqVo) {
        List ids = mdmTerminalReqVo.getIds();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((ids.size() == list.size() ? 1 : 0) != 0, (String)"\u53ea\u80fd\u7981\u7528\u72b6\u6001\u4e3a\u201d\u542f\u7528\u201c\u7684\u7ec8\u7aef");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public void updateCusOrgCode(MdmCusOrgTerminalReqVo mdmCusOrgTerminalReqVo) {
        if (CollectionUtils.isEmpty((Collection)mdmCusOrgTerminalReqVo.getTerminalCodeList()) || StringUtils.isEmpty((CharSequence)mdmCusOrgTerminalReqVo.getCusOrgCode())) {
            throw new BusinessException("\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u6216\u7ec8\u7aef\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmTerminalEntity::getTerminalCode, (Collection)mdmCusOrgTerminalReqVo.getTerminalCodeList())).set(MdmTerminalEntity::getCustomerOrgCode, (Object)mdmCusOrgTerminalReqVo.getCusOrgCode())).update();
    }

    protected void updateContact(MdmTerminalReqVo terminalReqVo) {
        this.mdmTerminalContactService.setUpContact(terminalReqVo);
        this.mdmTerminalSupplyService.setUpSupply(terminalReqVo);
        this.mdmTerminalMediaService.setUpMedia(terminalReqVo);
    }

    @Override
    public List<String> findByOrgCodeList(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalEntity::getOrgCode, list)).select(new SFunction[]{MdmTerminalEntity::getTerminalCode}).last(DatabaseTypeUtil.SEGMENT_ITEM)).list().stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> findOrgCodeByTerminalCodeList(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return Collections.emptyMap();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalEntity::getTerminalCode, terminalCodeList)).select(new SFunction[]{MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getOrgCode}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.toMap(MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getOrgCode));
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCustomerList(MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo) {
        return this.mdmCustomerMsgService.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo);
    }

    @Override
    public List<MdmTerminalRespVo> findCurrentAndSubTerminalList(MdmTerminalOrgSearchReqVo mdmTerminalOrgSearchReqVo) {
        List<MdmOrgRespVo> mdmOrgRespVos;
        List orgCodeList = mdmTerminalOrgSearchReqVo.getOrgCodeList();
        if (!CollectionUtils.isEmpty((Collection)orgCodeList) && !CollectionUtils.isEmpty(mdmOrgRespVos = this.mdmOrgService.findAllChildrenOrgListByList(null, orgCodeList))) {
            orgCodeList = mdmOrgRespVos.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            mdmTerminalOrgSearchReqVo.setOrgCodeList(orgCodeList);
        }
        if (!StringUtils.isEmpty((CharSequence)mdmTerminalOrgSearchReqVo.getCustomerCode())) {
            MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo = new MdmCustomerTerminalReqVo();
            mdmCustomerTerminalReqVo.setCustomerCode(mdmTerminalOrgSearchReqVo.getCustomerCode());
            mdmTerminalOrgSearchReqVo.setTerminalCodeList(this.mdmCustomerTerminalService.terminalCodeList(mdmCustomerTerminalReqVo));
        }
        return this.mdmTerminalMapper.findCurrentAndSubTerminalList(mdmTerminalOrgSearchReqVo);
    }

    @Override
    public List<MdmTerminalRespVo> listCondition(MdmTerminalReqVo mdmTerminalReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getId()), BaseIdEntity::getId, (Object)mdmTerminalReqVo.getId())).eq(!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getFormInstanceId()), CrmBaseEntity::getFormInstanceId, (Object)mdmTerminalReqVo.getFormInstanceId())).eq(!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)mdmTerminalReqVo.getEnableStatus())).like(!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getTerminalCode()), MdmTerminalEntity::getTerminalCode, (Object)mdmTerminalReqVo.getTerminalCode())).like(!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getTerminalName()), MdmTerminalEntity::getTerminalName, (Object)mdmTerminalReqVo.getTerminalName())).in(!CollectionUtils.isEmpty((Collection)mdmTerminalReqVo.getTerminalCodeList()), MdmTerminalEntity::getTerminalCode, (Collection)mdmTerminalReqVo.getTerminalCodeList())).in(!CollectionUtils.isEmpty((Collection)mdmTerminalReqVo.getOrgCodeList()), MdmTerminalEntity::getOrgCode, (Collection)mdmTerminalReqVo.getOrgCodeList())).last(DatabaseTypeUtil.SEGMENT_ITEM)).list();
        return CrmBeanUtil.copyList((List)list, MdmTerminalRespVo.class);
    }

    private void sendChangeMsg(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return;
        }
        this.advise.adviseTarget(this.terminalChangeAdviseTargetStrategy, terminalCodeList);
    }

    @Override
    public List<MdmTerminalRespVo> findPositionTerminalList(MdmPositionTerminalSearchReqVo mdmPositionTerminalSearchReqVo) {
        return this.mdmTerminalMapper.findPositionTerminalList(mdmPositionTerminalSearchReqVo);
    }

    @Override
    public List<MdmTerminalRespVo> findCurrentAndSybPositionTerminalList(MdmPositionTerminalSearchReqVo mdmPositionTerminalSearchReqVo) {
        List<String> positionCodeList = this.mdmPositionService.findAllChildrenPositionCodeList(mdmPositionTerminalSearchReqVo.getPositionId(), mdmPositionTerminalSearchReqVo.getPositionCode());
        if (!CollectionUtils.isEmpty(positionCodeList)) {
            mdmPositionTerminalSearchReqVo.setPositionCodeList(positionCodeList);
            mdmPositionTerminalSearchReqVo.setPositionId(null);
            mdmPositionTerminalSearchReqVo.setPositionCode(null);
        }
        return this.mdmTerminalMapper.findPositionTerminalList(mdmPositionTerminalSearchReqVo);
    }

    @Override
    public PageResult<MdmTerminalPrimaryContactPageRespVo> terminalContactPage(MdmTerminalPrimaryContactPageReqVo mdmTerminalPrimaryContactPageReqVo) {
        UserRedis user = UserUtils.getUser();
        Assert.notNull((Object)user, (String)"\u5f53\u524d\u7528\u6237\u4f1a\u8bdd\u4e0d\u5b58\u5728");
        String positionCode = user.getPoscode();
        Assert.hasText((String)positionCode, (String)"\u7528\u6237\u804c\u4f4d\u4e0d\u5b58\u5728");
        mdmTerminalPrimaryContactPageReqVo.setTerminalCodeList(this.mdmPositionTerminalService.findTerminalCodeByPositionCode(Collections.singletonList(positionCode)));
        Page page = PageUtil.buildPage((Integer)mdmTerminalPrimaryContactPageReqVo.getPageNum(), (Integer)mdmTerminalPrimaryContactPageReqVo.getPageSize());
        List<MdmTerminalPrimaryContactPageRespVo> list = this.mdmTerminalMapper.terminalContactPage((Page<MdmCustomerMsgRespVo>)page, mdmTerminalPrimaryContactPageReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateTerminalOrg(MdmOrgTerminalReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getTerminalCodeList(), (String)"\u7f3a\u5931\u7ec8\u7aef\u7f16\u7801");
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        MdmOrgRespVo org = this.mdmOrgService.query(new MdmOrgReqVo().setOrgCode(reqVo.getOrgCode()));
        Assert.notNull((Object)org, (String)"\u672a\u627e\u5230\u7ec4\u7ec7");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmTerminalEntity::getTerminalCode, (Collection)reqVo.getTerminalCodeList())).set(MdmTerminalEntity::getOrgCode, (Object)reqVo.getOrgCode())).update();
    }
}

