/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.mapper.MdmCustomerDockingMapper;
import com.biz.crm.customer.model.MdmCustomerDockingEntity;
import com.biz.crm.customer.service.MdmCustomerDockingService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingSearchReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmCustomerDockingServiceExpandImpl"})
public class MdmCustomerDockingServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmCustomerDockingMapper, MdmCustomerDockingEntity>
implements MdmCustomerDockingService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerDockingServiceImpl.class);
    @Resource
    private MdmCustomerDockingMapper mdmCustomerDockingMapper;

    @Override
    public PageResult<MdmCustomerDockingRespVo> findList(MdmCustomerDockingReqVo mdmCustomerDockingReqVo) {
        Page page = new Page((long)mdmCustomerDockingReqVo.getPageNum().intValue(), (long)mdmCustomerDockingReqVo.getPageSize().intValue());
        List<MdmCustomerDockingRespVo> list = this.mdmCustomerDockingMapper.findList((Page<MdmCustomerDockingRespVo>)page, mdmCustomerDockingReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmCustomerDockingRespVo> list(MdmCustomerDockingReqVo mdmCustomerDockingReqVo) {
        return this.mdmCustomerDockingMapper.list(mdmCustomerDockingReqVo);
    }

    @Override
    public List<String> findCustomerCodeListByPosition(List<String> positionCodeList) {
        if (CollectionUtils.isEmpty(positionCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerDockingEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmCustomerDockingEntity::getCustomerCode}).list().stream().map(MdmCustomerDockingEntity::getCustomerCode).distinct().collect(Collectors.toList());
    }

    @Override
    public MdmCustomerDockingRespVo query(MdmCustomerDockingReqVo mdmCustomerDockingReqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmCustomerDockingReqVo mdmCustomerDockingReqVo) {
        MdmCustomerDockingEntity entity = (MdmCustomerDockingEntity)((Object)CrmBeanUtil.copy((Object)mdmCustomerDockingReqVo, MdmCustomerDockingEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmCustomerDockingReqVo mdmCustomerDockingReqVo) {
        MdmCustomerDockingEntity entity = (MdmCustomerDockingEntity)((Object)this.getById((Serializable)((Object)mdmCustomerDockingReqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    public List<MdmCustomerDockingRespVo> dockingSearch(MdmCustomerDockingSearchReqVo mdmCustomerDockingSearchReqVo) {
        String dockingName = mdmCustomerDockingSearchReqVo.getDockingName();
        String orgCode = mdmCustomerDockingSearchReqVo.getOrgCode();
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().eq(!StringUtils.isEmpty((String)orgCode), (Object)"b.org_code", (Object)orgCode)).and(!StringUtils.isEmpty((String)dockingName), x -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)x.like((Object)"a.name", (Object)dockingName)).or()).like((Object)"b.org_name", (Object)dockingName)).or()).like((Object)"e.user_name", (Object)dockingName);
        });
        return this.mdmCustomerDockingMapper.dockingSearch((QueryWrapper<MdmCustomerDockingRespVo>)wrapper);
    }

    @Override
    public void setUpDocking(List<MdmCustomerDockingReqVo> mdmCustomerDockingReqVos, String customerCode) {
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerDockingEntity::getCustomerCode, (Object)customerCode)).remove();
        if (!CollectionUtils.isEmpty(mdmCustomerDockingReqVos)) {
            mdmCustomerDockingReqVos.stream().peek(x -> x.setCustomerCode(customerCode)).forEach(x -> {});
            List mdmCustomerDockingEntities = CrmBeanUtil.copyList(mdmCustomerDockingReqVos, MdmCustomerDockingEntity.class);
            this.saveBatch(mdmCustomerDockingEntities);
        }
    }
}

