/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.org.manager;

import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.customer.model.MdmCustomerMsgEntity;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerUpdateReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgPositionUpdateReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo;
import com.biz.crm.position.model.EnginePositionEntity;
import com.biz.crm.position.service.EnginePositionService;
import com.biz.crm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.service.MdmTerminalService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MdmOrgManager {
    private static final Logger log = LoggerFactory.getLogger(MdmOrgManager.class);
    @Resource
    private MdmTerminalMapper mdmTerminalMapper;
    @Resource
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private EnginePositionService enginePositionService;
    @Resource
    private MdmTerminalService mdmTerminalService;

    public PageResult<MdmCustomerMsgRespVo> findList(MdmOrgCustomerPageReqVo mdmOrgCustomerPageReqVo) {
        Page page = new Page((long)mdmOrgCustomerPageReqVo.getPageNum().intValue(), (long)mdmOrgCustomerPageReqVo.getPageSize().intValue());
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
        mdmCustomerMsgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        mdmCustomerMsgReqVo.setCustomerCode(mdmOrgCustomerPageReqVo.getCustomerCode());
        mdmCustomerMsgReqVo.setCustomerName(mdmOrgCustomerPageReqVo.getCustomerName());
        mdmCustomerMsgReqVo.setOrgCode(mdmOrgCustomerPageReqVo.getOrgCode());
        if (!StringUtils.isNotEmpty((CharSequence)mdmOrgCustomerPageReqVo.getOrgCode())) {
            return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
        }
        mdmCustomerMsgReqVo.setOrgCodeList(Collections.singletonList(mdmOrgCustomerPageReqVo.getOrgCode()));
        List<MdmCustomerMsgRespVo> list = this.mdmCustomerMsgMapper.findList((Page<MdmCustomerMsgRespVo>)page, mdmCustomerMsgReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    public void updateOrgCode(MdmOrgCustomerUpdateReqVo mdmOrgCustomerUpdateReqVo) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmCustomerMsgService.lambdaUpdate().in(MdmCustomerMsgEntity::getCustomerCode, (Collection)mdmOrgCustomerUpdateReqVo.getCustomerCodeList())).set(MdmCustomerMsgEntity::getOrgCode, (Object)mdmOrgCustomerUpdateReqVo.getOrgCode())).update();
    }

    public void terminalOrgCode(MdmOrgTerminalReqVo mdmOrgTerminalReqVo) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmTerminalService.lambdaUpdate().in(MdmTerminalEntity::getTerminalCode, (Collection)mdmOrgTerminalReqVo.getTerminalCodeList())).set(MdmTerminalEntity::getOrgCode, (Object)mdmOrgTerminalReqVo.getOrgCode())).update();
    }

    public void positionOrgCode(MdmOrgPositionUpdateReqVo mdmOrgPositionUpdateReqVo, String orgId) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.enginePositionService.lambdaUpdate().in(EnginePositionEntity::getPositionCode, (Collection)mdmOrgPositionUpdateReqVo.getPositionCodeList())).set(EnginePositionEntity::getOrganizationId, (Object)orgId)).update();
    }
}

