/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.position.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EnginePositionReqVo;
import com.biz.crm.nebular.mdm.humanarea.EnginePositionRespVo;
import com.biz.crm.nebular.mdm.humanarea.EnginePositionSelectReqVo;
import com.biz.crm.nebular.mdm.humanarea.EnginePositionSelectRespVo;
import com.biz.crm.nebular.mdm.humanarea.EnginePositionUnionQueryRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmPositionSelectPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmPositionSelectPageRespVo;
import com.biz.crm.nebular.mdm.positionlevel.resp.MdmPositionLevelRespVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.org.service.IEngineOrgService;
import com.biz.crm.position.mapper.EnginePositionMapper;
import com.biz.crm.position.model.EnginePositionEntity;
import com.biz.crm.position.service.EnginePositionService;
import com.biz.crm.positionlevel.service.MdmPositionLevelService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.DatabaseTypeUtil;
import com.bizunited.platform.common.vo.UuidVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"EnginePositionServiceExpandImpl"})
public class EnginePositionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<EnginePositionMapper, EnginePositionEntity>
implements EnginePositionService {
    private static final Logger log = LoggerFactory.getLogger(EnginePositionServiceImpl.class);
    @Resource
    private EnginePositionMapper enginePositionMapper;
    @Resource
    private EnginePositionService enginePositionService;
    @Resource
    private MdmPositionLevelService mdmPositionLevelService;
    @Resource
    private IEngineOrgService engineOrgService;

    @Override
    public PageResult<EnginePositionRespVo> findList(EnginePositionReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((String)reqVo.getPositionCode()), (Object)"code", (Object)reqVo.getPositionCode())).like(!StringUtils.isEmpty((String)reqVo.getPositionName()), (Object)"name", (Object)reqVo.getPositionName());
        List<EnginePositionRespVo> list = this.enginePositionMapper.findList((Page<EnginePositionRespVo>)page, (QueryWrapper<EnginePositionRespVo>)wrapper);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<EnginePositionRespVo> listCondition(EnginePositionReqVo enginePositionReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(!StringUtils.isEmpty((String)enginePositionReqVo.getPositionCode()), EnginePositionEntity::getPositionCode, (Object)enginePositionReqVo.getPositionCode())).like(!StringUtils.isEmpty((String)enginePositionReqVo.getPositionName()), EnginePositionEntity::getPositionName, (Object)enginePositionReqVo.getPositionName())).in(!CollectionUtils.isEmpty((Collection)enginePositionReqVo.getPositionCodeList()), EnginePositionEntity::getPositionCode, (Collection)enginePositionReqVo.getPositionCodeList())).in(!CollectionUtils.isEmpty((Collection)enginePositionReqVo.getIds()), BaseIdEntity::getId, (Collection)enginePositionReqVo.getIds())).eq(!StringUtils.isEmpty((String)enginePositionReqVo.getFormInstanceId()), CrmBaseEntity::getFormInstanceId, (Object)enginePositionReqVo.getFormInstanceId())).last(DatabaseTypeUtil.SEGMENT_ITEM)).list();
        return CrmBeanUtil.copyList((List)list, EnginePositionRespVo.class);
    }

    @Override
    public EnginePositionRespVo singleCondition(EnginePositionReqVo enginePositionReqVo) {
        EnginePositionEntity one = (EnginePositionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)enginePositionReqVo.getId()), BaseIdEntity::getId, (Object)enginePositionReqVo.getId())).eq(!StringUtils.isEmpty((String)enginePositionReqVo.getPositionCode()), EnginePositionEntity::getPositionCode, (Object)enginePositionReqVo.getPositionCode())).eq(!StringUtils.isEmpty((String)enginePositionReqVo.getFormInstanceId()), CrmBaseEntity::getFormInstanceId, (Object)enginePositionReqVo.getFormInstanceId())).eq(!StringUtils.isEmpty((String)enginePositionReqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)enginePositionReqVo.getEnableStatus())).one());
        return (EnginePositionRespVo)CrmBeanUtil.copy((Object)((Object)one), EnginePositionRespVo.class);
    }

    @Override
    public List<EnginePositionRespVo> getAllParentPositionList(String id, String positionCode) {
        EnginePositionEntity position;
        ArrayList<EnginePositionRespVo> list = new ArrayList<EnginePositionRespVo>();
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionCode)) && (position = (EnginePositionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)positionCode), EnginePositionEntity::getPositionCode, (Object)positionCode)).one())) != null) {
            ArrayList<EnginePositionEntity> entityList = new ArrayList<EnginePositionEntity>();
            entityList.add(position);
            HashSet<String> set = new HashSet<String>();
            set.add(position.getId());
            String parentId = position.getParentId();
            while (StringUtils.isNotEmpty((String)parentId)) {
                EnginePositionEntity parent = (EnginePositionEntity)((Object)this.getById((Serializable)((Object)parentId)));
                if (parent != null) {
                    if (set.contains(parent.getId())) {
                        throw new BusinessException("\u6570\u636e\u5f02\u5e38\uff1a\u804c\u4f4d\u4e0a\u7ea7\u5f62\u6210\u73af\u8def\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
                    }
                    entityList.add(parent);
                    set.add(parent.getId());
                    continue;
                }
                parentId = null;
            }
            list.addAll(CrmBeanUtil.copyList(entityList, EnginePositionRespVo.class));
        }
        return list;
    }

    @Override
    public List<EnginePositionSelectRespVo> positionSelectList(EnginePositionSelectReqVo enginePositionSelectReqVo) {
        List<EnginePositionSelectRespVo> list = this.enginePositionMapper.positionSelectList(enginePositionSelectReqVo, CrmEnableStatusEnum.ENABLE.getCode());
        if (list != null && list.size() > 0) {
            list.forEach(item -> item.setUnionName(this.generateUnionName(item.getOrgName(), item.getPositionName(), item.getUserName())));
        }
        return list;
    }

    @Override
    public List<EnginePositionSelectRespVo> orgUpPositionSelectList(EnginePositionSelectReqVo enginePositionSelectReqVo) {
        Assert.hasText((String)enginePositionSelectReqVo.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u5fc5\u4f20");
        List<EngineOrgRespVo> orgParentList = this.engineOrgService.findOrgParentList(null, enginePositionSelectReqVo.getOrgCode());
        if (CollectionUtil.listEmpty(orgParentList)) {
            return new ArrayList<EnginePositionSelectRespVo>();
        }
        List orgIds = orgParentList.stream().map(UuidVo::getId).collect(Collectors.toList());
        enginePositionSelectReqVo.setOrgIds(orgIds);
        enginePositionSelectReqVo.setOrgCode(null);
        List<EnginePositionSelectRespVo> list = this.enginePositionMapper.positionSelectList(enginePositionSelectReqVo, CrmEnableStatusEnum.ENABLE.getCode());
        if (list != null && list.size() > 0) {
            list.forEach(item -> item.setUnionName(this.generateUnionName(item.getOrgName(), item.getPositionName(), item.getUserName())));
        }
        return list;
    }

    @Override
    public List<EnginePositionRespVo> findAllPositionByUser(String userAccount) {
        if (StringUtils.isEmpty((String)userAccount)) {
            return Collections.emptyList();
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"a.user_account", (Object)userAccount)).last(DatabaseTypeUtil.SEGMENT_ITEM);
        return this.enginePositionMapper.findAllPositionByUser((QueryWrapper<EnginePositionRespVo>)wrapper);
    }

    @Override
    public List<String> findAllPositionCodeByUser(String userAccount) {
        if (StringUtils.isEmpty((String)userAccount)) {
            return Collections.emptyList();
        }
        return this.enginePositionMapper.findAllPositionCodeByUser(userAccount);
    }

    @Override
    public EnginePositionRespVo findPrimaryPositionByUserAccount(String userAccount) {
        Assert.hasText((String)userAccount, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return this.enginePositionMapper.findPrimaryPositionByUserAccount(userAccount);
    }

    @Override
    public PageResult<MdmPositionSelectPageRespVo> positionSelect(MdmPositionSelectPageReqVo mdmPositionSelectPageReqVo) {
        Page page = new Page((long)mdmPositionSelectPageReqVo.getPageNum().intValue(), (long)mdmPositionSelectPageReqVo.getPageSize().intValue());
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((String)mdmPositionSelectPageReqVo.getPositionCode()), (Object)"c.code", (Object)mdmPositionSelectPageReqVo.getPositionCode())).like(!StringUtils.isEmpty((String)mdmPositionSelectPageReqVo.getPositionName()), (Object)"c.name", (Object)mdmPositionSelectPageReqVo.getPositionName())).like(!StringUtils.isEmpty((String)mdmPositionSelectPageReqVo.getUserName()), (Object)"a.user_name", (Object)mdmPositionSelectPageReqVo.getUserName())).eq(!StringUtils.isEmpty((String)mdmPositionSelectPageReqVo.getParentPositionCode()), (Object)"f.code", (Object)mdmPositionSelectPageReqVo.getParentPositionCode());
        return new PageResult(Long.valueOf(page.getTotal()), this.enginePositionMapper.positionSelect((Page<MdmPositionSelectPageRespVo>)page, (QueryWrapper<MdmPositionSelectPageRespVo>)wrapper));
    }

    @Override
    public EnginePositionRespVo query(EnginePositionReqVo enginePositionReqVo) {
        EnginePositionEntity one = (EnginePositionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)enginePositionReqVo.getId()), BaseIdEntity::getId, (Object)enginePositionReqVo.getId())).eq(!StringUtils.isEmpty((String)enginePositionReqVo.getPositionCode()), EnginePositionEntity::getPositionCode, (Object)enginePositionReqVo.getPositionCode())).eq(!StringUtils.isEmpty((String)enginePositionReqVo.getFormInstanceId()), CrmBaseEntity::getFormInstanceId, (Object)enginePositionReqVo.getFormInstanceId())).last(DatabaseTypeUtil.SEGMENT)).one());
        return (EnginePositionRespVo)CrmBeanUtil.copy((Object)((Object)one), EnginePositionRespVo.class);
    }

    @Override
    public EnginePositionUnionQueryRespVo getPositionUnionInfo(EnginePositionReqVo enginePositionReqVo) {
        EnginePositionUnionQueryRespVo respVo = new EnginePositionUnionQueryRespVo();
        EnginePositionEntity position = (EnginePositionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(EnginePositionEntity::getPositionCode, (Object)enginePositionReqVo.getPositionCode())).one());
        if (position != null) {
            respVo.setId(position.getId());
            respVo.setPositionCode(position.getPositionCode());
            respVo.setPositionName(position.getPositionName());
            respVo.setIsPrimary(position.getIsPrimary());
            if (StringUtils.isNotEmpty((String)position.getParentId())) {
                EnginePositionSelectReqVo reqVo = new EnginePositionSelectReqVo();
                reqVo.setId(position.getParentId());
                List<EnginePositionSelectRespVo> parentPositionList = this.enginePositionMapper.positionSelectList(reqVo, null);
                if (CollectionUtil.listNotEmptyNotSizeZero(parentPositionList)) {
                    EnginePositionSelectRespVo parentPosition = parentPositionList.get(0);
                    respVo.setParentPositionId(parentPosition.getId());
                    respVo.setParentPositionCode(parentPosition.getPositionCode());
                    respVo.setParentPositionName(parentPosition.getPositionName());
                    respVo.setParentUnionName(this.generateUnionName(parentPosition.getOrgName(), parentPosition.getPositionName(), parentPosition.getUserName()));
                }
            }
            List<MdmRoleRespVo> roleList = this.enginePositionMapper.findPositionRoleList(position.getPositionCode());
            respVo.setRoleList(roleList);
        }
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(EnginePositionReqVo enginePositionReqVo) {
        if (StringUtils.isEmpty((String)enginePositionReqVo.getPositionCode())) {
            enginePositionReqVo.setPositionCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_POSITION_CODE.getCode()));
        }
        Assert.hasText((String)enginePositionReqVo.getPositionName(), (String)"\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        EnginePositionEntity entity = (EnginePositionEntity)((Object)CrmBeanUtil.copy((Object)enginePositionReqVo, EnginePositionEntity.class));
        this.convertPosition(enginePositionReqVo, entity);
        this.save((Object)entity);
    }

    private void convertPosition(EnginePositionReqVo enginePositionReqVo, EnginePositionEntity entity) {
        String positionLevelCode;
        MdmPositionLevelRespVo query;
        String orgCode = enginePositionReqVo.getOrgCode();
        if (!StringUtils.isEmpty((String)orgCode)) {
            EngineOrgReqVo engineOrgReqVo = new EngineOrgReqVo();
            engineOrgReqVo.setOrgCode(orgCode);
            engineOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            query = this.enginePositionService.query(enginePositionReqVo);
            Assert.notNull((Object)query, (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528");
            entity.setOrganizationId(query.getId());
        }
        if (!StringUtils.isEmpty((String)(positionLevelCode = enginePositionReqVo.getPositionLevelCode()))) {
            query = this.mdmPositionLevelService.detail(null, positionLevelCode);
            Assert.notNull((Object)query, (String)"\u804c\u4f4d\u7ea7\u522b\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528");
            entity.setPositionLevelId(query.getId());
            entity.setPositionLevelCode(query.getPositionLevelCode());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(EnginePositionReqVo enginePositionReqVo) {
        Assert.hasText((String)enginePositionReqVo.getId(), (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        EnginePositionEntity entity = (EnginePositionEntity)((Object)CrmBeanUtil.copy((Object)enginePositionReqVo, EnginePositionEntity.class));
        this.convertPosition(enginePositionReqVo, entity);
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(EnginePositionReqVo enginePositionReqVo) {
        List ids = enginePositionReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        this.removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(EnginePositionReqVo enginePositionReqVo) {
        List ids = enginePositionReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(EnginePositionReqVo enginePositionReqVo) {
        List ids = enginePositionReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    private String generateUnionName(String orgName, String positionName, String userName) {
        return (orgName == null ? "" : orgName) + "/" + (positionName == null ? "" : positionName) + "/" + (userName == null ? "" : userName);
    }

    @Override
    public List<EnginePositionRespVo> findCurrentAndSubList(EnginePositionReqVo enginePositionReqVo) {
        List collect;
        List positionCodeList = enginePositionReqVo.getPositionCodeList();
        List ids = Optional.ofNullable(enginePositionReqVo.getIds()).orElse(new ArrayList());
        List<EnginePositionRespVo> list = this.enginePositionMapper.listCondition(new EnginePositionReqVo());
        if (CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty((Collection)positionCodeList) && CollectionUtils.isEmpty((Collection)ids)) {
            return list;
        }
        if (!CollectionUtils.isEmpty((Collection)positionCodeList) && !CollectionUtils.isEmpty(collect = list.stream().filter(x -> positionCodeList.contains(x.getPositionCode())).map(UuidVo::getId).collect(Collectors.toList()))) {
            ids.addAll(collect);
            ids = ids.stream().distinct().collect(Collectors.toList());
        }
        ArrayList<EnginePositionRespVo> result = new ArrayList<EnginePositionRespVo>();
        List finalIds = ids;
        List collect2 = list.stream().filter(x -> finalIds.contains(x.getId())).collect(Collectors.toList());
        while (!CollectionUtils.isEmpty(collect2)) {
            result.addAll(collect2);
            List parentIdList = collect2.stream().map(UuidVo::getId).collect(Collectors.toList());
            collect2 = list.stream().filter(x -> parentIdList.contains(x.getParentId())).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public List<String> findCurrentAndSubPositionCodeList(EnginePositionReqVo enginePositionReqVo) {
        return this.findCurrentAndSubList(enginePositionReqVo).stream().map(EnginePositionRespVo::getPositionCode).collect(Collectors.toList());
    }
}

