/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.productlevel.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.material.model.MdmMaterialEntity;
import com.biz.crm.material.service.MdmMaterialService;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.productlevel.mapper.MdmProductLevelMapper;
import com.biz.crm.productlevel.model.MdmProductLevelEntity;
import com.biz.crm.productlevel.service.MdmProductLevelService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.utils.TreeRuleCodeUtil;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmProductLevelServiceExpandImpl"})
public class MdmProductLevelServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmProductLevelMapper, MdmProductLevelEntity>
implements MdmProductLevelService {
    private static final Logger log = LoggerFactory.getLogger(MdmProductLevelServiceImpl.class);
    @Resource
    private MdmProductLevelMapper mdmProductLevelMapper;
    @Resource
    private MdmMaterialService mdmMaterialService;

    @Override
    public PageResult<MdmProductLevelRespVo> findList(MdmProductLevelReqVo mdmProductLevelReqVo) {
        MdmProductLevelEntity one;
        Page page = PageUtil.buildPage((Integer)mdmProductLevelReqVo.getPageNum(), (Integer)mdmProductLevelReqVo.getPageSize());
        if (StringUtils.isNotEmpty((CharSequence)mdmProductLevelReqVo.getCode()) && (one = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getProductLevelCode, (Object)mdmProductLevelReqVo.getCode())).one())) != null) {
            mdmProductLevelReqVo.setRuleCode(one.getRuleCode());
        }
        List<MdmProductLevelRespVo> list = this.mdmProductLevelMapper.findList((Page<MdmProductLevelRespVo>)page, mdmProductLevelReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmProductLevelRespVo detail(String id, String productLevelCode) {
        MdmProductLevelEntity one;
        if ((StringUtils.isNotEmpty((CharSequence)id) || StringUtils.isNotEmpty((CharSequence)productLevelCode)) && (one = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((CharSequence)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((CharSequence)productLevelCode), MdmProductLevelEntity::getProductLevelCode, (Object)productLevelCode)).one())) != null) {
            MdmProductLevelEntity parent;
            MdmProductLevelRespVo respVo = (MdmProductLevelRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmProductLevelRespVo.class);
            if (StringUtils.isNotEmpty((CharSequence)one.getParentCode()) && (parent = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getProductLevelCode, (Object)one.getParentCode())).select(new SFunction[]{MdmProductLevelEntity::getProductLevelName}).one())) != null) {
                respVo.setParentName(parent.getProductLevelName());
            }
            return respVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmProductLevelReqVo mdmProductLevelReqVo) {
        MdmProductLevelEntity entity;
        Assert.notNull((Object)mdmProductLevelReqVo, (String)"\u7a7a\u53c2\u6570");
        Assert.hasText((String)mdmProductLevelReqVo.getProductLevelName(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmProductLevelReqVo.getProductLevelType(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((CharSequence)mdmProductLevelReqVo.getParentCode())) {
            MdmProductLevelRespVo parent = this.detail(null, mdmProductLevelReqVo.getParentCode());
            Assert.notNull((Object)parent, (String)"\u4e0a\u7ea7\u7f16\u7801\u65e0\u6548");
        }
        if (StringUtils.isBlank((CharSequence)(entity = (MdmProductLevelEntity)((Object)CrmBeanUtil.copy((Object)mdmProductLevelReqVo, MdmProductLevelEntity.class))).getProductLevelCode())) {
            entity.setProductLevelCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_PRODUCT_LEVEL_CODE.getCode()));
        }
        entity.setRuleCode(this.generateRuleCodeByParentCode(entity.getParentCode()));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmProductLevelReqVo mdmProductLevelReqVo) {
        Assert.notNull((Object)mdmProductLevelReqVo, (String)"\u7a7a\u53c2\u6570");
        Assert.hasText((String)mdmProductLevelReqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmProductLevelReqVo.getProductLevelName(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmProductLevelReqVo.getProductLevelType(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        MdmProductLevelEntity entity = (MdmProductLevelEntity)((Object)this.getById((Serializable)((Object)mdmProductLevelReqVo.getId())));
        Assert.notNull((Object)((Object)entity), (String)"id\u65e0\u6548");
        boolean updateRuleCode = false;
        int levelNum = 1;
        if (StringUtils.isEmpty((CharSequence)mdmProductLevelReqVo.getParentCode())) {
            if (StringUtils.isNotEmpty((CharSequence)entity.getParentCode())) {
                updateRuleCode = true;
                entity.setParentCode("");
            }
        } else {
            MdmProductLevelRespVo parent = this.detail(null, mdmProductLevelReqVo.getParentCode());
            Assert.notNull((Object)parent, (String)"\u4e0a\u7ea7\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u5b58\u5728");
            Assert.isTrue((!parent.getId().equals(entity.getId()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u80fd\u662f\u81ea\u5df1");
            if (!parent.getProductLevelCode().equals(entity.getParentCode())) {
                Assert.isTrue((!entity.getRuleCode().startsWith(parent.getRuleCode()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u80fd\u662f\u5f53\u524d\u5c42\u7ea7\u7684\u4e0b\u7ea7");
                entity.setParentCode(parent.getProductLevelCode());
                updateRuleCode = true;
                levelNum = parent.getLevelNum() + 1;
            }
        }
        entity.setProductLevelType(mdmProductLevelReqVo.getProductLevelType());
        entity.setProductLevelName(mdmProductLevelReqVo.getProductLevelName());
        entity.setRemarks(mdmProductLevelReqVo.getRemarks());
        this.updateById((Object)entity);
        if (updateRuleCode) {
            String ruleCode = this.generateRuleCodeByParentCode(entity.getParentCode());
            this.updateCurAndChildren(entity.getId(), ruleCode, levelNum);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u53c2\u6570\u4e3a\u7a7a");
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmProductLevelEntity entity = (MdmProductLevelEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)entity), (String)"\u65e0\u6548\u7684id");
            List children = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getParentCode, (Object)entity.getProductLevelCode())).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)children)) {
                throw new BusinessException("\u5f53\u524d\u4ea7\u54c1\u5c42\u7ea7\u5305\u542b\u5b50\u5c42\u7ea7\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u82e5\u9700\u8981\u5220\u9664\u8bf7\u5148\u5220\u9664\u5b50\u5c42\u7ea7");
            }
            List materialList = ((LambdaQueryChainWrapper)this.mdmMaterialService.lambdaQuery().eq(MdmMaterialEntity::getProductLevelCode, (Object)entity.getProductLevelCode())).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)materialList)) {
                throw new BusinessException("\u5f53\u524d\u4ea7\u54c1\u5c42\u7ea7\u5df2\u5173\u8054\u7269\u6599\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u82e5\u9700\u8981\u5220\u9664\u8bf7\u5148\u5220\u9664\u5173\u8054\u7269\u6599");
            }
        });
        this.removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmProductLevelEntity entity = (MdmProductLevelEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)entity), (String)"\u65e0\u6548\u7684id");
            Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(entity.getEnableStatus()), (String)"\u8be5\u4ea7\u54c1\u5c42\u7ea7\u5df2\u7ecf\u662f\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u518d\u542f\u7528");
            List<MdmProductLevelRespVo> parentList = this.getParentList((String)id, null);
            if (CollectionUtil.listNotEmptyNotSizeZero(parentList)) {
                parentList.forEach(item -> Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus()), (String)"\u4ea7\u54c1\u5c42\u7ea7\u4e0a\u7ea7\u5b58\u5728\u672a\u542f\u7528\u7684\u4ea7\u54c1\u5c42\u7ea7\uff0c\u8bf7\u5148\u542f\u7528"));
            }
            entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            this.updateById((Object)entity);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmProductLevelEntity entity = (MdmProductLevelEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)entity), (String)"\u65e0\u6548\u7684id");
            Assert.isTrue((boolean)CrmEnableStatusEnum.DISABLE.getCode().equals(entity.getEnableStatus()), (String)"\u8be5\u4ea7\u54c1\u5c42\u7ea7\u5df2\u7ecf\u662f\u7981\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u518d\u7981\u7528");
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().likeRight(CrmTreeEntity::getRuleCode, (Object)entity.getRuleCode())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
        });
    }

    @Override
    public List<String> getCurrentAndSubLevelCode(String productLevelCode) {
        List<MdmProductLevelRespVo> childrenList;
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)productLevelCode) && CollectionUtil.listNotEmptyNotSizeZero(childrenList = this.getChildrenList(null, productLevelCode))) {
            list.addAll(childrenList.stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList()));
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock
    public void resetRuleCode() {
        List allList = this.lambdaQuery().list();
        allList.forEach(item -> item.setRuleCode(item.getId()));
        this.updateBatchById(allList);
        List topList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmProductLevelEntity::getParentCode)).or()).eq(MdmProductLevelEntity::getParentCode, (Object)"")).list();
        for (int i = 0; i < topList.size(); ++i) {
            this.updateCurAndChildren(((MdmProductLevelEntity)((Object)topList.get(i))).getProductLevelCode(), TreeRuleCodeUtil.numToSingleCode(i + 1), 1);
        }
    }

    @Override
    public List<MdmProductLevelRespVo> getParentList(String id, String productLevelCode) {
        List parentList;
        Set<String> parentRuleCodes;
        MdmProductLevelEntity one;
        ArrayList<MdmProductLevelRespVo> list = new ArrayList<MdmProductLevelRespVo>();
        if (StringUtils.isEmpty((CharSequence)id) && StringUtils.isEmpty((CharSequence)productLevelCode) && (one = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((CharSequence)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((CharSequence)productLevelCode), MdmProductLevelEntity::getProductLevelCode, (Object)productLevelCode)).one())) != null && !(parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes(one.getRuleCode())).isEmpty() && CollectionUtil.listNotEmptyNotSizeZero((List)(parentList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(CrmTreeEntity::getRuleCode, parentRuleCodes)).list()))) {
            list.addAll(CrmBeanUtil.copyList((List)parentList, MdmProductLevelRespVo.class));
        }
        return list;
    }

    @Override
    public List<MdmProductLevelRespVo> getChildrenList(String id, String productLevelCode) {
        List children;
        MdmProductLevelEntity one;
        ArrayList<MdmProductLevelRespVo> list = new ArrayList<MdmProductLevelRespVo>();
        if ((StringUtils.isNotEmpty((CharSequence)id) || StringUtils.isNotEmpty((CharSequence)productLevelCode)) && (one = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((CharSequence)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((CharSequence)productLevelCode), MdmProductLevelEntity::getProductLevelCode, (Object)productLevelCode)).one())) != null && CollectionUtil.listNotEmptyNotSizeZero((List)(children = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeEntity::getRuleCode, (Object)one.getRuleCode())).list()))) {
            list.addAll(CrmBeanUtil.copyList((List)children, MdmProductLevelRespVo.class));
        }
        return list;
    }

    @Override
    public List<MdmProductLevelRespVo> productLevelSelectList(MdmProductLevelSelectReqVo reqVo) {
        List entityList;
        ArrayList<MdmProductLevelRespVo> list = new ArrayList<MdmProductLevelRespVo>();
        List<Object> underCodes = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getUnderProductLevelCode())) {
            underCodes = this.getCurrentAndSubLevelCode(reqVo.getUnderProductLevelCode());
        }
        List<Object> notUnderCodes = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getNotUnderProductLevelCode())) {
            notUnderCodes = this.getCurrentAndSubLevelCode(reqVo.getNotUnderProductLevelCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(entityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((CharSequence)reqVo.getProductLevelType()), MdmProductLevelEntity::getProductLevelType, (Object)reqVo.getProductLevelType())).like(StringUtils.isNotEmpty((CharSequence)reqVo.getProductLevelCode()), MdmProductLevelEntity::getProductLevelCode, (Object)reqVo.getProductLevelCode())).like(StringUtils.isNotEmpty((CharSequence)reqVo.getProductLevelName()), MdmProductLevelEntity::getProductLevelName, (Object)reqVo.getProductLevelName())).in(CollectionUtil.listNotEmptyNotSizeZero(underCodes), MdmProductLevelEntity::getProductLevelCode, underCodes)).notIn(CollectionUtil.listNotEmptyNotSizeZero(notUnderCodes), MdmProductLevelEntity::getProductLevelCode, notUnderCodes)).list()))) {
            list.addAll(CrmBeanUtil.copyList((List)entityList, MdmProductLevelRespVo.class));
        }
        return list;
    }

    private void updateCurAndChildren(String productLevelCode, String ruleCode, int levelNum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmProductLevelEntity::getProductLevelCode, (Object)productLevelCode)).set(CrmTreeEntity::getRuleCode, (Object)ruleCode)).set(CrmTreeEntity::getLevelNum, (Object)levelNum)).update();
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getParentCode, (Object)productLevelCode)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmProductLevelEntity)((Object)list.get(i))).getProductLevelCode(), ruleCode + TreeRuleCodeUtil.numToSingleCode(i + 1), levelNum + 1);
            }
        }
    }

    private String generateRuleCodeByParentCode(String parentCode) {
        MdmProductLevelEntity parent;
        String ruleCode = "";
        boolean top = true;
        String prefix = "";
        if (StringUtils.isNotEmpty((CharSequence)parentCode) && (parent = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getProductLevelCode, (Object)parentCode)).one())) != null) {
            top = false;
            prefix = parent.getRuleCode();
        }
        List list = null;
        list = top ? ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmProductLevelEntity::getParentCode)).or()).eq(MdmProductLevelEntity::getParentCode, (Object)"")).list() : ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getParentCode, (Object)parentCode)).list();
        if (CollectionUtil.listEmpty((List)list)) {
            ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode(1);
        } else {
            LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
            for (MdmProductLevelEntity item : list) {
                if (!StringUtils.isNotEmpty((CharSequence)item.getRuleCode())) continue;
                Integer integer = Integer.valueOf(item.getRuleCode().substring(item.getRuleCode().length() - 3));
                set.add(integer);
            }
            for (int i = 1; i < 999; ++i) {
                if (set.contains(i)) continue;
                ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode(i);
                break;
            }
        }
        return ruleCode;
    }
}

