/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.terminal.mapper.MdmTerminalContactMapper;
import com.biz.crm.terminal.model.MdmTerminalContactEntity;
import com.biz.crm.terminal.service.MdmTerminalContactService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"MdmTerminalContactServiceExpandImpl"})
public class MdmTerminalContactServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmTerminalContactMapper, MdmTerminalContactEntity>
implements MdmTerminalContactService {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalContactServiceImpl.class);
    @Resource
    private MdmTerminalContactMapper mdmTerminalContactMapper;

    @Override
    public List<MdmTerminalContactEntity> getListByTerminalCode(String terminalCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"terminal_code", (Object)terminalCode);
        List list = this.list((Wrapper)queryWrapper);
        list = list == null ? new ArrayList() : list;
        return list;
    }

    @Override
    public void saveList(List<MdmTerminalContactVo> contacts) {
        if (CollectionUtil.listEmpty(contacts)) {
            return;
        }
        List entities = CrmBeanUtil.copyList(contacts, MdmTerminalContactEntity.class);
        this.saveBatch(entities);
    }

    @Override
    public void updateList(List<MdmTerminalContactVo> contacts, String terminalCode) {
        if (StringUtils.isEmpty((String)terminalCode)) {
            throw new BusinessException("\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.listEmpty(contacts)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"terminal_code", (Object)terminalCode);
            this.remove((Wrapper)queryWrapper);
            return;
        }
        contacts.forEach(item -> item.setTerminalCode(terminalCode));
        List<MdmTerminalContactEntity> oldList = this.getListByTerminalCode(terminalCode);
        ArrayList<MdmTerminalContactVo> addList = new ArrayList<MdmTerminalContactVo>();
        ArrayList<MdmTerminalContactVo> updateList = new ArrayList<MdmTerminalContactVo>();
        ArrayList deleteList = new ArrayList();
        HashMap itemMap = oldList.stream().collect(Collectors.toMap(BaseIdEntity::getId, item -> item));
        itemMap = itemMap == null ? new HashMap() : itemMap;
        for (MdmTerminalContactVo mdmTerminalContactVo : contacts) {
            if (itemMap.containsKey(mdmTerminalContactVo.getId())) {
                updateList.add(mdmTerminalContactVo);
                itemMap.remove(mdmTerminalContactVo.getId());
                continue;
            }
            addList.add(mdmTerminalContactVo);
        }
        if (!itemMap.isEmpty()) {
            for (Map.Entry entry : itemMap.entrySet()) {
                deleteList.add(entry.getValue());
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
            List entities = CrmBeanUtil.copyList(addList, MdmTerminalContactEntity.class);
            this.saveBatch(entities);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(updateList)) {
            List updateEntitys = CrmBeanUtil.copyList(updateList, MdmTerminalContactEntity.class);
            this.updateBatchById(updateEntitys);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteList)) {
            List ids = deleteList.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
            this.removeByIds(ids);
        }
    }

    @Override
    public void deleteByCodes(List<String> terminalCodes) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"terminal_code", terminalCodes);
        this.remove((Wrapper)queryWrapper);
    }
}

