/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.availablelistrule.advise.Advise;
import com.biz.crm.availablelistrule.advise.strategy.TerminalChangeAdviseTargetStrategy;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerTerminalService;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelationTerminalPageReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelationTerminalPageRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.service.MdmTerminalContactService;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.terminal.service.MdmTerminalSupplyDetailService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.terminal.vo.UpdateTerminalCusOrgCodeVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.utils.DatabaseTypeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmTerminalServiceExpandImpl"})
public class MdmTerminalServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmTerminalMapper, MdmTerminalEntity>
implements MdmTerminalService {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalServiceImpl.class);
    @Resource
    private MdmTerminalMapper mdmTerminalMapper;
    @Autowired
    private MdmTerminalContactService mdmTerminalContactService;
    @Autowired
    private MdmTerminalSupplyService mdmTerminalSupplyService;
    @Resource
    private TerminalChangeAdviseTargetStrategy terminalChangeAdviseTargetStrategy;
    @Resource
    private Advise advise;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmCustomerTerminalService mdmCustomerTerminalService;
    @Resource
    private MdmTerminalSupplyDetailService mdmTerminalMediaService;
    @Resource
    private MdmPositionService mdmPositionService;

    @Override
    public PageResult<MdmTerminalVo> findList(MdmTerminalVo mdmTerminalReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmTerminalReqVo.getPageNum(), (Integer)mdmTerminalReqVo.getPageSize());
        if (!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getCode())) {
            List<String> orgCodeList = this.mdmOrgService.findAllChildrenOrgCodeList(null, mdmTerminalReqVo.getCode());
            mdmTerminalReqVo.setOrgCodeList(orgCodeList);
        }
        List<MdmTerminalVo> list = this.mdmTerminalMapper.findList((Page<MdmTerminalVo>)page, mdmTerminalReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmTerminalVo query(String id, String terminalCode) {
        if (StringUtils.isEmpty((CharSequence)id) && StringUtils.isEmpty((CharSequence)terminalCode)) {
            return null;
        }
        MdmTerminalVo mdmTerminalVo = new MdmTerminalVo();
        MdmTerminalEntity mdmTerminalEntity = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            mdmTerminalEntity = (MdmTerminalEntity)((Object)this.getById((Serializable)((Object)id)));
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"terminal_code", (Object)terminalCode);
            List list = this.list((Wrapper)queryWrapper);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                mdmTerminalEntity = (MdmTerminalEntity)((Object)list.get(0));
            }
        }
        if (mdmTerminalEntity == null) {
            return null;
        }
        ArrayList mdmTerminalContactEntities = this.mdmTerminalContactService.getListByTerminalCode(mdmTerminalEntity.getTerminalCode());
        mdmTerminalContactEntities = mdmTerminalContactEntities == null ? new ArrayList() : mdmTerminalContactEntities;
        mdmTerminalVo.setContacts(CrmBeanUtil.copyList(mdmTerminalContactEntities, MdmTerminalContactVo.class));
        List<MdmTerminalSupplyVo> mdmTerminalSupplyVos = this.mdmTerminalSupplyService.getMdmTerminalSupply(mdmTerminalEntity.getTerminalCode());
        mdmTerminalVo.setSupplys(mdmTerminalSupplyVos);
        return mdmTerminalVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmTerminalVo mdmTerminalVo) {
        if (StringUtils.isEmpty((CharSequence)mdmTerminalVo.getTerminalCode())) {
            mdmTerminalVo.setTerminalCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_TERMINAL.getCode()));
        } else {
            Integer count = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalEntity::getTerminalCode, (Object)mdmTerminalVo.getTerminalCode())).count();
            Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)(mdmTerminalVo.getTerminalCode() + "\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728"));
        }
        MdmTerminalEntity entity = (MdmTerminalEntity)((Object)CrmBeanUtil.copy((Object)mdmTerminalVo, MdmTerminalEntity.class));
        this.save((Object)entity);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)mdmTerminalVo.getContacts())) {
            mdmTerminalVo.getContacts().forEach(item -> item.setTerminalCode(entity.getTerminalCode()));
            this.mdmTerminalContactService.saveList(mdmTerminalVo.getContacts());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)mdmTerminalVo.getSupplys())) {
            this.mdmTerminalSupplyService.saveList(mdmTerminalVo.getSupplys());
        }
        this.sendChangeMsg(Collections.singletonList(mdmTerminalVo.getTerminalCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmTerminalVo mdmTerminalVo) {
        String id = mdmTerminalVo.getId();
        String terminalCode = mdmTerminalVo.getTerminalCode();
        Assert.hasText((String)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)id, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmTerminalEntity entity = (MdmTerminalEntity)((Object)this.getById((Serializable)((Object)mdmTerminalVo.getId())));
        Assert.notNull((Object)((Object)entity), (String)"\u7ec8\u7aef\u4e0d\u5b58\u5728");
        Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ne(BaseIdEntity::getId, (Object)id)).eq(MdmTerminalEntity::getTerminalCode, (Object)terminalCode)).count();
        Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728");
        this.updateById(CrmBeanUtil.copy((Object)mdmTerminalVo, MdmTerminalEntity.class));
        this.mdmTerminalContactService.updateList(mdmTerminalVo.getContacts(), mdmTerminalVo.getTerminalCode());
        this.mdmTerminalSupplyService.updateList(mdmTerminalVo.getSupplys(), mdmTerminalVo.getTerminalCode());
        this.sendChangeMsg(Collections.singletonList(mdmTerminalVo.getTerminalCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e");
        }
        List list = this.listByIds(ids);
        if (CollectionUtil.listEmpty((List)list)) {
            return;
        }
        List<String> terminalCodes = list.stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList());
        this.mdmTerminalContactService.deleteByCodes(terminalCodes);
        this.mdmTerminalSupplyService.deleteByCodes(terminalCodes);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e");
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((ids.size() == list.size() ? 1 : 0) != 0, (String)"\u53ea\u80fd\u542f\u7528\u72b6\u6001\u4e3a\u201d\u7981\u7528\u201c\u7684\u7ec8\u7aef");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e");
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((ids.size() == list.size() ? 1 : 0) != 0, (String)"\u53ea\u80fd\u7981\u7528\u72b6\u6001\u4e3a\u201d\u542f\u7528\u201c\u7684\u7ec8\u7aef");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateCusOrgCode(UpdateTerminalCusOrgCodeVo vo) {
        if (CollectionUtil.listEmpty(vo.getIds()) || StringUtils.isEmpty((CharSequence)vo.getCustomerOrgCode())) {
            throw new BusinessException("\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u6216\u7ec8\u7aef\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, vo.getIds())).set(MdmTerminalEntity::getCustomerOrgCode, (Object)vo.getCustomerOrgCode())).update();
    }

    @Override
    public List<String> findByOrgCodeList(List<String> list) {
        if (CollectionUtil.listEmpty(list)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalEntity::getOrgCode, list)).select(new SFunction[]{MdmTerminalEntity::getTerminalCode}).last(DatabaseTypeUtil.SEGMENT_ITEM)).list().stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> findOrgCodeByTerminalCodeList(List<String> terminalCodeList) {
        if (CollectionUtil.listEmpty(terminalCodeList)) {
            return Collections.emptyMap();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalEntity::getTerminalCode, terminalCodeList)).select(new SFunction[]{MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getOrgCode}).list();
        if (CollectionUtil.listEmpty((List)list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.toMap(MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getOrgCode));
    }

    @Override
    public List<MdmTerminalVo> findCurrentAndSubTerminalList(List<String> orgCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(orgCodes)) {
            List<MdmOrgRespVo> mdmOrgRespVos = this.mdmOrgService.findAllChildrenOrgListByList(null, orgCodes);
            if (CollectionUtil.listNotEmptyNotSizeZero(mdmOrgRespVos)) {
                orgCodes = mdmOrgRespVos.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            }
        } else {
            return new ArrayList<MdmTerminalVo>();
        }
        return this.mdmTerminalMapper.findCurrentAndSubTerminalList(orgCodes);
    }

    @Override
    public List<MdmTerminalVo> listCondition(MdmTerminalVo mdmTerminalReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getId()), BaseIdEntity::getId, (Object)mdmTerminalReqVo.getId())).eq(!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getFormInstanceId()), CrmBaseEntity::getFormInstanceId, (Object)mdmTerminalReqVo.getFormInstanceId())).eq(!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)mdmTerminalReqVo.getEnableStatus())).like(!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getTerminalCode()), MdmTerminalEntity::getTerminalCode, (Object)mdmTerminalReqVo.getTerminalCode())).like(!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getTerminalName()), MdmTerminalEntity::getTerminalName, (Object)mdmTerminalReqVo.getTerminalName())).in(CollectionUtil.listNotEmptyNotSizeZero((List)mdmTerminalReqVo.getTerminalCodeList()), MdmTerminalEntity::getTerminalCode, (Collection)mdmTerminalReqVo.getTerminalCodeList())).in(CollectionUtil.listNotEmptyNotSizeZero((List)mdmTerminalReqVo.getOrgCodeList()), MdmTerminalEntity::getOrgCode, (Collection)mdmTerminalReqVo.getOrgCodeList())).last(DatabaseTypeUtil.SEGMENT_ITEM)).list();
        return CrmBeanUtil.copyList((List)list, MdmTerminalVo.class);
    }

    private void sendChangeMsg(List<String> terminalCodeList) {
        if (CollectionUtil.listEmpty(terminalCodeList)) {
            return;
        }
        this.advise.adviseTarget(this.terminalChangeAdviseTargetStrategy, terminalCodeList);
    }

    @Override
    public List<MdmTerminalVo> findPositionTerminalList(String posId, String posCode) {
        if (StringUtils.isEmpty((CharSequence)posCode) && StringUtils.isEmpty((CharSequence)posId)) {
            return new ArrayList<MdmTerminalVo>();
        }
        return this.mdmTerminalMapper.findPositionTerminalList(posId, posCode);
    }

    @Override
    public List<MdmTerminalVo> findCurrentAndSybPositionTerminalList(String posId, String posCode) {
        List<String> positionCodeList = this.mdmPositionService.findAllChildrenPositionCodeList(posId, posCode);
        if (CollectionUtil.listEmpty(positionCodeList)) {
            return new ArrayList<MdmTerminalVo>();
        }
        return this.mdmTerminalMapper.findPositionsTerminalList(positionCodeList);
    }

    @Override
    public List<MdmTerminalContactVo> terminalContact(String primary, String posCode) {
        if (StringUtils.isEmpty((CharSequence)posCode)) {
            return new ArrayList<MdmTerminalContactVo>();
        }
        List<MdmTerminalContactVo> list = this.mdmTerminalMapper.terminalContact(primary, posCode);
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateTerminalOrg(MdmOrgTerminalReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getTerminalCodeList(), (String)"\u7f3a\u5931\u7ec8\u7aef\u7f16\u7801");
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        MdmOrgRespVo org = this.mdmOrgService.query(new MdmOrgReqVo().setOrgCode(reqVo.getOrgCode()));
        Assert.notNull((Object)org, (String)"\u672a\u627e\u5230\u7ec4\u7ec7");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmTerminalEntity::getTerminalCode, (Collection)reqVo.getTerminalCodeList())).set(MdmTerminalEntity::getOrgCode, (Object)reqVo.getOrgCode())).update();
    }

    @Override
    public PageResult<MdmUserRelationTerminalPageRespVo> findTerminalUnRelationAnyUser(MdmUserRelationTerminalPageReqVo mdmUserRelationTerminalPageReqVo) {
        return null;
    }

    @Override
    public PageResult<MdmUserRelationTerminalPageRespVo> findUnRelationCurrentUser(MdmUserRelationTerminalPageReqVo mdmUserRelationTerminalPageReqVo) {
        return null;
    }
}

