/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyDetailVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.terminal.mapper.MdmTerminalSupplyMapper;
import com.biz.crm.terminal.model.MdmTerminalSupplyDetailEntity;
import com.biz.crm.terminal.model.MdmTerminalSupplyEntity;
import com.biz.crm.terminal.service.MdmTerminalSupplyDetailService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.bizunited.platform.common.vo.UuidVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@ConditionalOnMissingBean(name={"MdmTerminalSupplyServiceExpandImpl"})
public class MdmTerminalSupplyServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmTerminalSupplyMapper, MdmTerminalSupplyEntity>
implements MdmTerminalSupplyService {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalSupplyServiceImpl.class);
    @Autowired
    private MdmTerminalSupplyDetailService mdmTerminalSupplyDetailService;

    @Override
    public List<MdmTerminalSupplyVo> getMdmTerminalSupply(String terminalCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"terminal_code", (Object)terminalCode);
        List list = this.list((Wrapper)queryWrapper);
        list = list == null ? new ArrayList() : list;
        List vos = CrmBeanUtil.copyList((List)list, MdmTerminalSupplyVo.class);
        List<String> ids = vos.stream().map(UuidVo::getId).collect(Collectors.toList());
        if (CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            List<MdmTerminalSupplyDetailEntity> detailEntities = this.mdmTerminalSupplyDetailService.getListBySupplyIdOrDataType(ids, null);
            List mdmTerminalSupplyDetailVos = CrmBeanUtil.copyList(detailEntities, MdmTerminalSupplyDetailVo.class);
            HashMap listmap = new HashMap();
            mdmTerminalSupplyDetailVos.stream().collect(Collectors.groupingBy(MdmTerminalSupplyDetailVo::getSupplyId, Collectors.toList())).forEach((supplyId, tempList) -> listmap.put(supplyId, tempList));
            for (MdmTerminalSupplyVo vo : vos) {
                if (!listmap.containsKey(vo.getId())) continue;
                vo.setDetails((List)listmap.get(vo.getId()));
            }
        }
        return vos;
    }

    @Override
    public void saveList(List<MdmTerminalSupplyVo> supplys) {
        if (CollectionUtil.listEmpty(supplys)) {
            return;
        }
        for (MdmTerminalSupplyVo item : supplys) {
            MdmTerminalSupplyEntity entity = (MdmTerminalSupplyEntity)((Object)CrmBeanUtil.copy((Object)item, MdmTerminalSupplyEntity.class));
            this.save((Object)entity);
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)item.getDetails())) continue;
            item.getDetails().forEach(itemTemp -> itemTemp.setSupplyId(entity.getId()));
        }
    }

    @Override
    public void updateList(List<MdmTerminalSupplyVo> supplys, String terminalCode) {
        if (StringUtils.isEmpty((String)terminalCode)) {
            throw new BusinessException("\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.listEmpty(supplys)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"terminal_code", (Object)terminalCode);
            this.remove((Wrapper)queryWrapper);
            return;
        }
        for (MdmTerminalSupplyVo item2 : supplys) {
            item2.setTerminalCode(terminalCode);
            if (!StringUtils.isNotEmpty((String)item2.getId())) continue;
            this.mdmTerminalSupplyDetailService.updateList(item2.getDetails(), item2.getId());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"terminal_code", (Object)terminalCode);
        List oldList = this.list((Wrapper)queryWrapper);
        ArrayList<MdmTerminalSupplyVo> addList = new ArrayList<MdmTerminalSupplyVo>();
        ArrayList<MdmTerminalSupplyVo> updateList = new ArrayList<MdmTerminalSupplyVo>();
        ArrayList deleteList = new ArrayList();
        HashMap itemMap = oldList.stream().collect(Collectors.toMap(BaseIdEntity::getId, item -> item));
        itemMap = itemMap == null ? new HashMap() : itemMap;
        for (MdmTerminalSupplyVo mdmTerminalSupplyVo : supplys) {
            if (itemMap.containsKey(mdmTerminalSupplyVo.getId())) {
                updateList.add(mdmTerminalSupplyVo);
                itemMap.remove(mdmTerminalSupplyVo.getId());
                continue;
            }
            addList.add(mdmTerminalSupplyVo);
        }
        if (!itemMap.isEmpty()) {
            for (Map.Entry entry : itemMap.entrySet()) {
                deleteList.add(entry.getValue());
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
            for (MdmTerminalSupplyVo mdmTerminalSupplyVo : addList) {
                MdmTerminalSupplyEntity entity = (MdmTerminalSupplyEntity)((Object)CrmBeanUtil.copy((Object)mdmTerminalSupplyVo, MdmTerminalSupplyEntity.class));
                this.save((Object)entity);
                this.mdmTerminalSupplyDetailService.updateList(mdmTerminalSupplyVo.getDetails(), entity.getId());
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(updateList)) {
            List updateEntitys = CrmBeanUtil.copyList(updateList, MdmTerminalSupplyEntity.class);
            this.updateBatchById(updateEntitys);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteList)) {
            List ids = deleteList.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
            this.removeByIds(ids);
        }
    }

    @Override
    public void deleteByCodes(List<String> terminalCodes) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"terminal_code", terminalCodes);
        List entities = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.listEmpty((List)entities)) {
            return;
        }
        List<String> ids = entities.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
        this.mdmTerminalSupplyDetailService.deleteBySupplyIds(ids);
        this.removeByIds(ids);
    }
}

