/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.model.MdmCustomerMsgEntity;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.constant.PositionOperationEnum;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserChangePasswordReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserCustomerEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserPositionEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserPageRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.org.model.MdmOrgEntity;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.model.MdmPositionUserEntity;
import com.biz.crm.position.service.MdmPositionRoleService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.position.service.MdmPositionUserService;
import com.biz.crm.positionlevel.service.MdmPositionLevelService;
import com.biz.crm.role.mode.MdmRoleCustomerEntity;
import com.biz.crm.role.mode.MdmRoleEntity;
import com.biz.crm.role.service.MdmRoleCustomerService;
import com.biz.crm.role.service.MdmRoleService;
import com.biz.crm.user.mapper.MdmUserMapper;
import com.biz.crm.user.model.MdmUserEntity;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.DatabaseTypeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmUserServiceExpandImpl"})
public class MdmUserServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmUserMapper, MdmUserEntity>
implements MdmUserService {
    private static final Logger log = LoggerFactory.getLogger(MdmUserServiceImpl.class);
    @Resource
    private MdmUserMapper mdmUserMapper;
    @Resource
    private MdmPositionUserService mdmPositionUserService;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmPositionRoleService mdmPositionRoleService;
    @Resource
    private MdmPositionLevelService mdmPositionLevelService;
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private MdmRoleCustomerService mdmRoleCustomerService;
    @Resource
    private MdmRoleService mdmRoleService;

    @Override
    public PageResult<MdmUserPageRespVo> findList(MdmUserPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmUserPageRespVo> list = this.mdmUserMapper.findList((Page<MdmUserPageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmUserRespVo query(MdmUserReqVo reqVo) {
        if (StringUtils.isNotEmpty((String)reqVo.getId()) || StringUtils.isNotEmpty((String)reqVo.getUserName())) {
            MdmUserEntity one = (MdmUserEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).eq(!StringUtils.isEmpty((String)reqVo.getUserName()), MdmUserEntity::getUserName, (Object)reqVo.getUserName())).one());
            MdmUserRespVo respVo = (MdmUserRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmUserRespVo.class);
            respVo.setUserPassword("");
            if (UserTypeEnum.USER.getCode().equals(respVo.getUserType())) {
                respVo.setPositionList(this.mdmPositionService.getUserAllPositionList(new MdmUserReqVo().setUserName(one.getUserName())));
            } else if (UserTypeEnum.CUSTOMER_ONE.getCode().equals(respVo.getUserType()) || UserTypeEnum.CUSTOMER_MANY.getCode().equals(respVo.getUserType())) {
                ArrayList customerList = new ArrayList();
                List customerEntityList = ((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().eq(MdmCustomerMsgEntity::getUserName, (Object)one.getUserName())).list();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntityList)) {
                    Map<Object, Object> customerRoleListMap = new HashMap(16);
                    List roleCustomerEntityList = ((LambdaQueryChainWrapper)this.mdmRoleCustomerService.lambdaQuery().in(MdmRoleCustomerEntity::getCustomerCode, (Collection)customerEntityList.stream().map(MdmCustomerMsgEntity::getCustomerCode).collect(Collectors.toList()))).list();
                    Map<Object, Object> roleCodeNameMap = new HashMap(16);
                    if (CollectionUtil.listNotEmptyNotSizeZero((List)roleCustomerEntityList)) {
                        customerRoleListMap = roleCustomerEntityList.stream().collect(Collectors.groupingBy(MdmRoleCustomerEntity::getCustomerCode));
                        List roleEntityList = ((LambdaQueryChainWrapper)this.mdmRoleService.lambdaQuery().in(MdmRoleEntity::getRoleCode, (Collection)roleCustomerEntityList.stream().map(MdmRoleCustomerEntity::getRoleCode).distinct().collect(Collectors.toList()))).select(new SFunction[]{MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName}).list();
                        roleCodeNameMap = roleEntityList.stream().collect(Collectors.toMap(MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName));
                    }
                    HashMap map = customerRoleListMap;
                    HashMap finalRoleCodeNameMap = roleCodeNameMap;
                    customerList.addAll(customerEntityList.stream().map(item -> {
                        MdmCustomerMsgRespVo copy = (MdmCustomerMsgRespVo)CrmBeanUtil.copy((Object)item, MdmCustomerMsgRespVo.class);
                        if (map.containsKey(item.getCustomerCode())) {
                            copy.setRoleCode(((MdmRoleCustomerEntity)((Object)((Object)((List)map.get(item.getCustomerCode())).get(0)))).getRoleCode());
                            copy.setRoleName((String)finalRoleCodeNameMap.get(copy.getRoleCode()));
                        }
                        return copy;
                    }).collect(Collectors.toList()));
                    if (UserTypeEnum.CUSTOMER_ONE.getCode().equals(respVo.getUserType())) {
                        respVo.setRoleCode(((MdmCustomerMsgRespVo)customerList.get(0)).getRoleCode());
                        respVo.setRoleName(((MdmCustomerMsgRespVo)customerList.get(0)).getRoleName());
                        respVo.setCustomerCode(((MdmCustomerMsgRespVo)customerList.get(0)).getCustomerCode());
                        respVo.setCustomerName(((MdmCustomerMsgRespVo)customerList.get(0)).getCustomerName());
                    }
                }
                respVo.setCustomerList(customerList);
            }
            return respVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmUserEditReqVo reqVo) {
        this.verifyData(reqVo);
        MdmUserEntity entity = (MdmUserEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmUserEntity.class));
        if (StringUtils.isEmpty((String)entity.getUserCode())) {
            entity.setUserCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_USER_CODE.getCode()));
        }
        entity.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
        this.save((Object)entity);
        this.saveOrUpdateUserRelation(reqVo, entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmUserEditReqVo reqVo) {
        this.verifyData(reqVo);
        MdmUserEntity entity = (MdmUserEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
        this.saveOrUpdateUserRelation(reqVo, entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmUserReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmUserEntity one = (MdmUserEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)one), (String)"\u65e0\u6548\u7684\u7528\u6237");
            this.mdmPositionUserService.removeUser(one.getUserName());
            this.removeById((Serializable)((Object)one.getId()));
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmUserReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        for (String id : ids) {
            Assert.hasText((String)id, (String)"id\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmUserEntity user = (MdmUserEntity)((Object)this.getById((Serializable)((Object)id)));
            Assert.notNull((Object)((Object)user), (String)"id\u65e0\u6548");
            Assert.isTrue((boolean)CrmEnableStatusEnum.DISABLE.getCode().equals(user.getEnableStatus()), (String)("\u53ea\u80fd\u542f\u7528\u72b6\u6001\u4e3a\u201c" + CrmEnableStatusEnum.DISABLE.getDes() + "\u201d\u7684\u7528\u6237"));
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)id)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmUserReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        for (String id : ids) {
            Assert.hasText((String)id, (String)"id\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmUserEntity user = (MdmUserEntity)((Object)this.getById((Serializable)((Object)id)));
            Assert.notNull((Object)((Object)user), (String)"id\u65e0\u6548");
            Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(user.getEnableStatus()), (String)("\u53ea\u80fd\u7981\u7528\u72b6\u6001\u4e3a\u201c" + CrmEnableStatusEnum.ENABLE.getDes() + "\u201d\u7684\u7528\u6237"));
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)id)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changePassword(MdmUserChangePasswordReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        Assert.hasText((String)reqVo.getOldPassword(), (String)"\u7f3a\u5931\u539f\u5bc6\u7801");
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u65b0\u5bc6\u7801");
        MdmUserEntity user = (MdmUserEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getUserName, (Object)reqVo.getUserName())).one());
        Assert.notNull((Object)((Object)user), (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        String oldPasswordEncryption = Md5EncryptionAndDecryption.encryPwd((String)reqVo.getOldPassword());
        String newPasswordEncryption = Md5EncryptionAndDecryption.encryPwd((String)reqVo.getNewPassword());
        Assert.isTrue((boolean)user.getUserPassword().equals(oldPasswordEncryption), (String)"\u539f\u5bc6\u7801\u8f93\u5165\u9519\u8bef");
        Assert.isTrue((!oldPasswordEncryption.equals(newPasswordEncryption) ? 1 : 0) != 0, (String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u539f\u5bc6\u7801\u76f8\u540c");
        user.setUserPassword(newPasswordEncryption);
        this.updateById((Object)user);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unlock(MdmUserReqVo reqVo) {
        Assert.notNull((Object)reqVo.getIds(), (String)"\u7a7a\u53c2\u6570");
        Assert.isTrue((reqVo.getIds().size() == 1 ? 1 : 0) != 0, (String)"\u6682\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c");
        reqVo.getIds().forEach(id -> {
            MdmUserEntity one = (MdmUserEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)one), (String)"\u7528\u6237\u4e0d\u5b58\u5728");
            Assert.isTrue((!CrmEnableStatusEnum.ENABLE.getCode().equals(one.getLockState()) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u89e3\u9501\u201c\u9501\u5b9a\u201d\u7684\u7528\u6237");
            one.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
            this.updateById((Object)one);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void resetPassword(MdmUserReqVo reqVo) {
        Assert.notNull((Object)reqVo.getIds(), (String)"\u7a7a\u53c2\u6570");
        reqVo.getIds().forEach(id -> {
            MdmUserEntity one = (MdmUserEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)one), (String)"\u7528\u6237\u4e0d\u5b58\u5728");
            one.setUserPassword(Md5EncryptionAndDecryption.encryPwd((String)"000000"));
            this.updateById((Object)one);
        });
    }

    private void verifyData(MdmUserEditReqVo reqVo) {
        String userName = reqVo.getUserName();
        Assert.hasText((String)userName, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7528\u6237\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)reqVo.getGender(), (String)"\u6027\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getStartTime(), (String)"\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getEndTime(), (String)"\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        MdmUserEntity one = (MdmUserEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getUserName, (Object)userName)).one());
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            Assert.isNull((Object)((Object)one), (String)("\u5e10\u53f7[" + userName + "]\u5df2\u5b58\u5728"));
            Assert.hasText((String)reqVo.getUserPassword(), (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqVo.getUserPassword())) {
            reqVo.setUserPassword(one.getUserPassword());
        } else {
            reqVo.setUserPassword(Md5EncryptionAndDecryption.encryPwd((String)reqVo.getUserPassword()));
        }
        UserTypeEnum userTypeEnum = UserTypeEnum.getEnumByCode((String)reqVo.getUserType());
        Assert.notNull((Object)userTypeEnum, (String)"\u7528\u6237\u7c7b\u578b\u65e0\u6548");
        switch (userTypeEnum) {
            case USER: {
                List positionReqList = reqVo.getPositionList();
                Assert.notEmpty((Collection)positionReqList, (String)"\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                int count = 0;
                for (MdmUserPositionEditReqVo item : positionReqList) {
                    Assert.hasText((String)item.getOrgCode(), (String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
                    Assert.hasText((String)item.getOperationType(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    Assert.notNull((Object)item.getPrimaryFlag(), (String)"\u662f\u5426\u4e3b\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    PositionOperationEnum positionOperationEnum = PositionOperationEnum.getEnumByCode((String)item.getOperationType());
                    Assert.notNull((Object)positionOperationEnum, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
                    if (YesNoEnum.yesNoEnum.ONE.getValue().equals(item.getPrimaryFlag())) {
                        Assert.notEmpty((Collection)item.getRoleList(), (String)"\u4e3b\u804c\u4f4d\u7684\u6743\u9650\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a");
                        if (++count > 1) {
                            throw new BusinessException("\u53ea\u80fd\u6709\u4e00\u4e2a\u4e3b\u804c\u4f4d");
                        }
                    }
                    switch (positionOperationEnum) {
                        case NEW: {
                            Assert.hasText((String)item.getPositionLevelCode(), (String)"\u804c\u4f4d\u7ea7\u522b\u4e0d\u80fd\u4e3a\u7a7a");
                            break;
                        }
                        case HISTORY: {
                            Assert.hasText((String)item.getPositionCode(), (String)"\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                            break;
                        }
                    }
                }
                if (count != 0) break;
                throw new BusinessException("\u5fc5\u987b\u9009\u62e9\u4e00\u4e2a\u4e3b\u804c\u4f4d");
            }
            case CUSTOMER_ONE: {
                Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
            case CUSTOMER_MANY: {
                List customerList = reqVo.getCustomerList();
                Assert.notEmpty((Collection)customerList, (String)"\u5ba2\u6237\u7528\u6237\u5fc5\u987b\u5173\u8054\u5ba2\u6237");
                HashMap<String, MdmUserCustomerEditReqVo> customerUniqueMap = new HashMap<String, MdmUserCustomerEditReqVo>(16);
                for (MdmUserCustomerEditReqVo item : customerList) {
                    Assert.hasText((String)item.getCustomerCode(), (String)"\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
                    if (customerUniqueMap.containsKey(item.getCustomerCode())) {
                        throw new BusinessException("\u4e0d\u80fd\u91cd\u590d\u5173\u8054\u5ba2\u6237\u76f8\u540c\u5ba2\u6237");
                    }
                    customerUniqueMap.put(item.getCustomerCode(), item);
                }
                break;
            }
        }
    }

    private void saveOrUpdateUserRelation(MdmUserEditReqVo reqVo, MdmUserEntity userEntity) {
        UserTypeEnum userTypeEnum = UserTypeEnum.getEnumByCode((String)userEntity.getUserType());
        switch (userTypeEnum) {
            case USER: {
                this.updateUserPositionRelation(reqVo, userEntity);
                break;
            }
            case CUSTOMER_ONE: {
                reqVo.setCustomerList(Collections.singletonList(new MdmUserCustomerEditReqVo().setCustomerCode(reqVo.getCustomerCode()).setRoleCode(reqVo.getRoleCode())));
                this.updateUserCustomerRelation(reqVo, userEntity);
                break;
            }
            case CUSTOMER_MANY: {
                this.updateUserCustomerRelation(reqVo, userEntity);
                break;
            }
        }
    }

    private void updateUserPositionRelation(MdmUserEditReqVo reqVo, MdmUserEntity userEntity) {
        this.mdmPositionUserService.removeUser(userEntity.getUserName());
        for (MdmUserPositionEditReqVo item : reqVo.getPositionList()) {
            MdmOrgEntity org = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.mdmOrgService.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)item.getOrgCode())).one());
            Assert.notNull((Object)((Object)org), (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            MdmPositionEntity position = null;
            MdmPositionReqVo copy = (MdmPositionReqVo)CrmBeanUtil.copy((Object)item, MdmPositionReqVo.class);
            if (PositionOperationEnum.NEW.getCode().equals(item.getOperationType())) {
                String positionCode = this.mdmPositionService.saveAndReturnPositionCode(copy);
                position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)positionCode)).one());
            } else if (PositionOperationEnum.HISTORY.getCode().equals(item.getOperationType())) {
                this.mdmPositionService.update(copy);
                position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)item.getPositionCode())).one());
                Assert.notNull((Object)((Object)position), (String)"\u804c\u4f4d\u4e0d\u5b58\u5728");
                this.mdmPositionUserService.removePositionCode(position.getPositionCode());
                this.mdmPositionRoleService.removePositionCode(position.getPositionCode());
            } else {
                throw new BusinessException("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5b58\u5728");
            }
            MdmPositionUserEntity positionUser = new MdmPositionUserEntity();
            positionUser.setUserName(userEntity.getUserName());
            positionUser.setPositionCode(position.getPositionCode());
            this.mdmPositionUserService.save((Object)positionUser);
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)item.getRoleList())) continue;
            List roleCodeList = item.getRoleList();
            this.mdmPositionRoleService.addRole(roleCodeList, position.getPositionCode());
        }
    }

    private void updateUserCustomerRelation(MdmUserEditReqVo reqVo, MdmUserEntity userEntity) {
        boolean setPrimary = false;
        for (MdmUserCustomerEditReqVo item : reqVo.getCustomerList()) {
            MdmCustomerMsgEntity customer = (MdmCustomerMsgEntity)((Object)((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().eq(MdmCustomerMsgEntity::getCustomerCode, (Object)item.getCustomerCode())).one());
            Assert.notNull((Object)((Object)customer), (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
            customer.setUserName(userEntity.getUserName());
            customer.setCustomerPrimary(setPrimary ? YesNoEnum.yesNoEnum.ZERO.getValue() : YesNoEnum.yesNoEnum.ONE.getValue());
            this.mdmCustomerMsgService.updateById((Object)customer);
            setPrimary = true;
            if (!StringUtils.isNotEmpty((String)item.getRoleCode())) continue;
            this.mdmRoleCustomerService.replaceCustomerRole(customer.getCustomerCode(), item.getRoleCode());
        }
    }

    private String generatePositionName(String positionLevelCode, String positionLevelName) {
        List positionList = ((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionLevelCode, (Object)positionLevelCode)).list();
        if (CollectionUtils.isEmpty((Collection)positionList)) {
            return positionLevelName + "_1";
        }
        Integer max = 1;
        for (MdmPositionEntity item : positionList) {
            Integer cur;
            String[] array1 = item.getPositionName().split("[\\D]+");
            String s = array1[array1.length - 1];
            if (!StringUtils.isNotEmpty((String)s) || (cur = Integer.valueOf(s)) <= max) continue;
            max = cur;
        }
        return positionLevelName + "_" + (max + 1);
    }

    @Override
    public MdmUserRespVo queryBasic(MdmUserReqVo mdmUserReqVo) {
        MdmUserEntity one = (MdmUserEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)mdmUserReqVo.getUserCode()), MdmUserEntity::getUserCode, (Object)mdmUserReqVo.getUserCode())).eq(!StringUtils.isEmpty((String)mdmUserReqVo.getUserName()), MdmUserEntity::getUserName, (Object)mdmUserReqVo.getUserName())).eq(!StringUtils.isEmpty((String)mdmUserReqVo.getId()), BaseIdEntity::getId, (Object)mdmUserReqVo.getId())).eq(!StringUtils.isEmpty((String)mdmUserReqVo.getUserType()), MdmUserEntity::getUserType, (Object)mdmUserReqVo.getUserType())).one());
        return (MdmUserRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmUserRespVo.class);
    }

    @Override
    public PageResult<MdmUserRespVo> pageBasic(MdmUserReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmUserRespVo> list = this.mdmUserMapper.pageBasic((Page<MdmUserRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmUserRespVo> listDetail(MdmUserReqVo mdmUserReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(!StringUtils.isEmpty((String)mdmUserReqVo.getUserName()), MdmUserEntity::getUserName, (Object)mdmUserReqVo.getUserName())).like(!StringUtils.isEmpty((String)mdmUserReqVo.getUserCode()), MdmUserEntity::getUserCode, (Object)mdmUserReqVo.getUserCode())).like(!StringUtils.isEmpty((String)mdmUserReqVo.getFullName()), MdmUserEntity::getFullName, (Object)mdmUserReqVo.getFullName())).eq(!StringUtils.isEmpty((String)mdmUserReqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)mdmUserReqVo.getEnableStatus())).eq(!StringUtils.isEmpty((String)mdmUserReqVo.getUserType()), MdmUserEntity::getUserType, (Object)mdmUserReqVo.getUserType())).last(DatabaseTypeUtil.SEGMENT_ITEM)).list();
        return CrmBeanUtil.copyList((List)list, MdmUserRespVo.class);
    }
}

