/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.common.service.BaseTreeService;
import com.biz.crm.cusorg.entity.MdmCusOrgEntity;
import com.biz.crm.cusorg.service.MdmCusOrgService;
import com.biz.crm.function.model.MdmFunctionEntity;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.nebular.mdm.permission.BaseTreeReqVo;
import com.biz.crm.nebular.mdm.permission.BaseTreeRespVo;
import com.biz.crm.org.model.MdmOrgEntity;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.productlevel.model.MdmProductLevelEntity;
import com.biz.crm.productlevel.service.MdmProductLevelService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.TreeRuleCodeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BaseTreeServiceImpl
implements BaseTreeService {
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmProductLevelService mdmProductLevelService;
    @Resource
    private MdmCusOrgService mdmCusOrgService;
    @Resource
    private MdmFunctionService mdmFunctionService;

    @Override
    public List<BaseTreeRespVo> orgTree(BaseTreeReqVo baseTreeReqVo) {
        List<BaseTreeRespVo> tree = new ArrayList<BaseTreeRespVo>();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmOrgService.lambdaQuery().like(!StringUtils.isEmpty((String)baseTreeReqVo.getName()), MdmOrgEntity::getOrgName, (Object)baseTreeReqVo.getName())).or()).like(!StringUtils.isEmpty((String)baseTreeReqVo.getName()), MdmOrgEntity::getOrgCode, (Object)baseTreeReqVo.getName())).select(new SFunction[]{BaseIdEntity::getId, MdmOrgEntity::getParentCode, MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName, CrmTreeTenEntity::getRuleCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            Set<String> set = TreeRuleCodeUtil.splitParentRuleCodes(list.stream().map(CrmTreeTenEntity::getRuleCode).collect(Collectors.toList()));
            if (!set.isEmpty()) {
                list = ((LambdaQueryChainWrapper)this.mdmOrgService.lambdaQuery().in(CrmTreeTenEntity::getRuleCode, set)).list();
            }
            List<BaseTreeRespVo> collect = list.stream().map(x -> {
                BaseTreeRespVo baseTreeRespVo = new BaseTreeRespVo();
                baseTreeRespVo.setId(x.getId());
                baseTreeRespVo.setParentCode(x.getParentCode());
                baseTreeRespVo.setCode(x.getOrgCode());
                baseTreeRespVo.setName(x.getOrgName());
                return baseTreeRespVo;
            }).collect(Collectors.toList());
            tree = this.generateTreeByParentCode(collect);
        }
        return tree;
    }

    @Override
    public List<BaseTreeRespVo> menuTree(BaseTreeReqVo baseTreeReqVo) {
        List<BaseTreeRespVo> tree = new ArrayList<BaseTreeRespVo>();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmFunctionService.lambdaQuery().like(StringUtils.isNotEmpty((String)baseTreeReqVo.getName()), MdmFunctionEntity::getFunctionName, (Object)baseTreeReqVo.getName())).or()).like(StringUtils.isNotEmpty((String)baseTreeReqVo.getName()), MdmFunctionEntity::getFunctionCode, (Object)baseTreeReqVo.getName())).select(new SFunction[]{BaseIdEntity::getId, MdmFunctionEntity::getFunctionCode, MdmFunctionEntity::getFunctionName, MdmFunctionEntity::getParentCode}).list();
        if (StringUtils.isNotEmpty((String)baseTreeReqVo.getName()) && CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            HashSet<String> set = new HashSet<String>();
            for (MdmFunctionEntity item : list) {
                MdmFunctionEntity one;
                set.add(item.getFunctionCode());
                String parentCode = item.getParentCode();
                while (StringUtils.isNotEmpty((String)parentCode) && (one = (MdmFunctionEntity)((Object)((LambdaQueryChainWrapper)this.mdmFunctionService.lambdaQuery().eq(MdmFunctionEntity::getFunctionCode, (Object)parentCode)).select(new SFunction[]{MdmFunctionEntity::getFunctionCode, MdmFunctionEntity::getParentCode}).one())) != null && !set.contains(one.getFunctionCode())) {
                    set.add(one.getFunctionCode());
                    parentCode = one.getParentCode();
                }
            }
            if (!set.isEmpty()) {
                list = ((LambdaQueryChainWrapper)this.mdmFunctionService.lambdaQuery().in(MdmFunctionEntity::getFunctionCode, set)).select(new SFunction[]{BaseIdEntity::getId, MdmFunctionEntity::getFunctionCode, MdmFunctionEntity::getFunctionName, MdmFunctionEntity::getParentCode}).list();
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            List<BaseTreeRespVo> collect = list.stream().map(x -> {
                BaseTreeRespVo baseTreeRespVo = new BaseTreeRespVo();
                baseTreeRespVo.setId(x.getId());
                baseTreeRespVo.setParentCode(x.getParentCode());
                baseTreeRespVo.setCode(x.getFunctionCode());
                baseTreeRespVo.setName(x.getFunctionName());
                return baseTreeRespVo;
            }).collect(Collectors.toList());
            tree = this.generateTreeByParentCode(collect);
        }
        return tree;
    }

    @Override
    public List<BaseTreeRespVo> productLevelTree(BaseTreeReqVo baseTreeReqVo) {
        Set<String> set;
        List<BaseTreeRespVo> tree = new ArrayList<BaseTreeRespVo>();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmProductLevelService.lambdaQuery().like(StringUtils.isNotEmpty((String)baseTreeReqVo.getName()), MdmProductLevelEntity::getProductLevelName, (Object)baseTreeReqVo.getName())).or()).like(StringUtils.isNotEmpty((String)baseTreeReqVo.getName()), MdmProductLevelEntity::getProductLevelCode, (Object)baseTreeReqVo.getName())).select(new SFunction[]{CrmTreeEntity::getRuleCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list) && !(set = TreeRuleCodeUtil.splitParentRuleCodes(list.stream().map(CrmTreeEntity::getRuleCode).collect(Collectors.toList()))).isEmpty()) {
            list = ((LambdaQueryChainWrapper)this.mdmProductLevelService.lambdaQuery().in(CrmTreeEntity::getRuleCode, set)).select(new SFunction[]{BaseIdEntity::getId, MdmProductLevelEntity::getProductLevelCode, MdmProductLevelEntity::getProductLevelName, MdmProductLevelEntity::getParentCode, CrmTreeEntity::getRuleCode}).list();
            List<BaseTreeRespVo> collect = list.stream().map(x -> {
                BaseTreeRespVo baseTreeRespVo = new BaseTreeRespVo();
                baseTreeRespVo.setId(x.getId());
                baseTreeRespVo.setParentCode(x.getParentCode());
                baseTreeRespVo.setCode(x.getProductLevelCode());
                baseTreeRespVo.setName(x.getProductLevelName());
                return baseTreeRespVo;
            }).collect(Collectors.toList());
            tree = this.generateTreeByParentCode(collect);
        }
        return tree;
    }

    @Override
    public List<BaseTreeRespVo> customerOrgTree(BaseTreeReqVo baseTreeReqVo) {
        Set<String> set;
        List<BaseTreeRespVo> tree = new ArrayList<BaseTreeRespVo>();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmCusOrgService.lambdaQuery().like(StringUtils.isNotEmpty((String)baseTreeReqVo.getName()), MdmCusOrgEntity::getCustomerOrgName, (Object)baseTreeReqVo.getName())).or()).like(StringUtils.isNotEmpty((String)baseTreeReqVo.getName()), MdmCusOrgEntity::getCustomerOrgCode, (Object)baseTreeReqVo.getName())).select(new SFunction[]{CrmTreeEntity::getRuleCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list) && !(set = TreeRuleCodeUtil.splitParentRuleCodes(list.stream().map(CrmTreeEntity::getRuleCode).collect(Collectors.toList()))).isEmpty()) {
            list = ((LambdaQueryChainWrapper)this.mdmCusOrgService.lambdaQuery().in(CrmTreeEntity::getRuleCode, set)).select(new SFunction[]{BaseIdEntity::getId, MdmCusOrgEntity::getCustomerOrgCode, MdmCusOrgEntity::getCustomerOrgName, MdmCusOrgEntity::getParentCode, CrmTreeEntity::getRuleCode}).list();
            List<BaseTreeRespVo> collect = list.stream().map(x -> {
                BaseTreeRespVo baseTreeRespVo = new BaseTreeRespVo();
                baseTreeRespVo.setId(x.getId());
                baseTreeRespVo.setParentCode(x.getParentCode());
                baseTreeRespVo.setCode(x.getCustomerOrgCode());
                baseTreeRespVo.setName(x.getCustomerOrgName());
                return baseTreeRespVo;
            }).collect(Collectors.toList());
            tree = this.generateTreeByParentCode(collect);
        }
        return tree;
    }

    private List<BaseTreeRespVo> generateTreeByParentCode(List<BaseTreeRespVo> totalList) {
        ArrayList<BaseTreeRespVo> treeList = new ArrayList<BaseTreeRespVo>();
        ArrayList<Object> curLevelList = new ArrayList<Object>();
        ArrayList<Object> restList = new ArrayList<Object>();
        Map<String, BaseTreeRespVo> totalMap = totalList.stream().collect(Collectors.toMap(BaseTreeRespVo::getCode, v -> v));
        for (BaseTreeRespVo item : totalList) {
            if (StringUtils.isEmpty((String)item.getParentCode()) || !totalMap.containsKey(item.getParentCode())) {
                treeList.add(item);
                curLevelList.add(item);
                continue;
            }
            restList.add(item);
        }
        while (curLevelList.size() > 0 && restList.size() > 0) {
            ArrayList<BaseTreeRespVo> restTempList = new ArrayList<BaseTreeRespVo>();
            ArrayList<BaseTreeRespVo> curLevelTempList = new ArrayList<BaseTreeRespVo>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(BaseTreeRespVo::getCode, BaseTreeRespVo::getCode));
            HashMap curLevelChildrenMap = new HashMap();
            for (BaseTreeRespVo baseTreeRespVo : restList) {
                if (curLevelMap.containsKey(baseTreeRespVo.getParentCode())) {
                    curLevelTempList.add(baseTreeRespVo);
                    ArrayList<BaseTreeRespVo> childrenList = new ArrayList<BaseTreeRespVo>();
                    if (curLevelChildrenMap.containsKey(baseTreeRespVo.getParentCode())) {
                        childrenList.addAll((Collection)curLevelChildrenMap.get(baseTreeRespVo.getParentCode()));
                    }
                    childrenList.add(baseTreeRespVo);
                    curLevelChildrenMap.put(baseTreeRespVo.getParentCode(), childrenList);
                    continue;
                }
                restTempList.add(baseTreeRespVo);
            }
            for (BaseTreeRespVo baseTreeRespVo : curLevelList) {
                if (!curLevelChildrenMap.containsKey(baseTreeRespVo.getCode())) continue;
                baseTreeRespVo.setChildren((List)curLevelChildrenMap.get(baseTreeRespVo.getCode()));
            }
            curLevelList.clear();
            curLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }
        return treeList;
    }
}

