/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.availablelistrule.advise.Advise;
import com.biz.crm.availablelistrule.advise.strategy.CustomerChangeAdviseTargetStrategy;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.manager.MdmCustomerMsgBuilder;
import com.biz.crm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.customer.model.MdmCustomerContactEntity;
import com.biz.crm.customer.model.MdmCustomerMsgEntity;
import com.biz.crm.customer.model.MdmCustomerTerminalEntity;
import com.biz.crm.customer.service.MdmCustomerContactService;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerSaleAreaService;
import com.biz.crm.customer.service.MdmCustomerTerminalService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.customer.CustomerCodeConditionReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgContactPageRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerSaleAreaReqVo;
import com.biz.crm.nebular.mdm.customer.MdmPositionCustomerSearchReqVo;
import com.biz.crm.nebular.mdm.customer.MdmUpdateCusOrgCodeReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerUpdateReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.model.MdmPositionCustomerEntity;
import com.biz.crm.position.service.MdmPositionCustomerService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.utils.DatabaseTypeUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmCustomerMsgServiceExpandImpl"})
public class MdmCustomerMsgServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmCustomerMsgMapper, MdmCustomerMsgEntity>
implements MdmCustomerMsgService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerMsgServiceImpl.class);
    @Resource
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;
    @Resource
    private MdmCustomerContactService mdmCustomerContactService;
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmCustomerSaleAreaService mdmCustomerSaleAreaService;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private Advise advise;
    @Resource
    private CustomerChangeAdviseTargetStrategy customerChangeAdviseTargetStrategy;
    @Resource
    private MdmPositionCustomerService mdmPositionCustomerService;
    @Resource
    private MdmCustomerTerminalService mdmCustomerTerminalService;

    @Override
    public PageResult<MdmCustomerMsgRespVo> findList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmCustomerMsgReqVo.getPageNum(), (Integer)mdmCustomerMsgReqVo.getPageSize());
        if (!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCode())) {
            mdmCustomerMsgReqVo.setOrgCodeList(this.mdmOrgService.findAllChildrenOrgCodeList(null, mdmCustomerMsgReqVo.getCode()));
        }
        List<MdmCustomerMsgRespVo> list = this.mdmCustomerMsgMapper.findList((Page<MdmCustomerMsgRespVo>)page, mdmCustomerMsgReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmCustomerMsgSelectRespVo> list(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getId()), BaseIdEntity::getId, (Object)mdmCustomerMsgReqVo.getId())).like(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCustomerCode()), MdmCustomerMsgEntity::getCustomerCode, (Object)mdmCustomerMsgReqVo.getCustomerCode())).like(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCustomerName()), MdmCustomerMsgEntity::getCustomerName, (Object)mdmCustomerMsgReqVo.getCustomerName())).eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getOrgCode()), MdmCustomerMsgEntity::getOrgCode, (Object)mdmCustomerMsgReqVo.getOrgCode())).eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCustomerOrgCode()), MdmCustomerMsgEntity::getCustomerOrgCode, (Object)mdmCustomerMsgReqVo.getCustomerOrgCode())).in(!CollectionUtils.isEmpty((Collection)mdmCustomerMsgReqVo.getCustomerCodeList()), MdmCustomerMsgEntity::getCustomerCode, (Collection)mdmCustomerMsgReqVo.getCustomerCodeList())).select(new SFunction[]{MdmCustomerMsgEntity::getCustomerCode, MdmCustomerMsgEntity::getCustomerName}).last(DatabaseTypeUtil.SEGMENT_ITEM)).list();
        return CrmBeanUtil.copyList((List)list, MdmCustomerMsgSelectRespVo.class);
    }

    @Override
    public List<MdmCustomerMsgSelectRespVo> findCustomerNotRelateUserSelectList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        return this.mdmCustomerMsgMapper.findCustomerNotRelateUserSelectList(null, mdmCustomerMsgReqVo);
    }

    @Override
    public List<String> findByOrgCodeList(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerMsgEntity::getOrgCode, list)).select(new SFunction[]{MdmCustomerMsgEntity::getCustomerCode}).last(DatabaseTypeUtil.SEGMENT_ITEM)).list().stream().map(MdmCustomerMsgEntity::getCustomerCode).collect(Collectors.toList());
    }

    @Override
    public MdmCustomerMsgRespVo query(String id, String customerCode) {
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
        mdmCustomerMsgReqVo.setCustomerCode(customerCode);
        mdmCustomerMsgReqVo.setId(id);
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = this.mdmCustomerMsgMapper.query(mdmCustomerMsgReqVo);
        return Optional.ofNullable(mdmCustomerMsgRespVo).map(x -> {
            this.setUpCustomer(mdmCustomerMsgRespVo);
            return mdmCustomerMsgRespVo;
        }).orElse(null);
    }

    protected void setUpCustomer(MdmCustomerMsgRespVo mdmCustomerMsgRespVo) {
        String customerCode = mdmCustomerMsgRespVo.getCustomerCode();
        mdmCustomerMsgRespVo.setMdmCustomerContactVos(this.mdmCustomerContactService.list(new MdmCustomerContactReqVo().setCustomerCode(customerCode)));
        mdmCustomerMsgRespVo.setMdmCustomerDockingVos(this.mdmPositionCustomerService.findDockingListByCustomerCode(new MdmCustomerDockingReqVo().setCustomerCode(customerCode)));
        mdmCustomerMsgRespVo.setMdmCustomerSaleAreaVos(this.mdmCustomerSaleAreaService.listCondition(new MdmCustomerSaleAreaReqVo().setCustomerCode(customerCode)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setUpCollateral(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.mdmCustomerContactService.setUpContact(mdmCustomerMsgReqVo.getMdmCustomerContactVos(), mdmCustomerMsgReqVo.getCustomerCode());
        this.mdmPositionCustomerService.setUpDocking(mdmCustomerMsgReqVo);
        this.mdmCustomerSaleAreaService.setUpArea(mdmCustomerMsgReqVo.getMdmCustomerSaleAreaVos(), mdmCustomerMsgReqVo.getCustomerCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        MdmCustomerMsgBuilder.builder(true, this).init(mdmCustomerMsgReqVo).valid().convert().persistence().after();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        MdmCustomerMsgBuilder.builder(false, this).init(mdmCustomerMsgReqVo).valid().convert().persistence().after();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List ids = mdmCustomerMsgReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).select(new SFunction[]{MdmCustomerMsgEntity::getCustomerCode}).list();
        Assert.notEmpty((Collection)list, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
        List customerCodeList = list.stream().map(MdmCustomerMsgEntity::getCustomerCode).collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)this.mdmPositionCustomerService.lambdaUpdate().in(MdmPositionCustomerEntity::getCustomerCode, customerCodeList)).remove();
        ((LambdaUpdateChainWrapper)this.mdmCustomerTerminalService.lambdaUpdate().in(MdmCustomerTerminalEntity::getCustomerCode, customerCodeList)).remove();
        ((LambdaUpdateChainWrapper)this.mdmCustomerContactService.lambdaUpdate().in(MdmCustomerContactEntity::getCustomerCode, customerCodeList)).remove();
        this.removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List ids = mdmCustomerMsgReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((ids.size() == list.size() ? 1 : 0) != 0, (String)"\u53ea\u80fd\u542f\u7528\u72b6\u6001\u4e3a\u201d\u7981\u7528\u201c\u7684\u5ba2\u6237\u4fe1\u606f");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)mdmCustomerMsgReqVo.getIds())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List ids = mdmCustomerMsgReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((ids.size() == list.size() ? 1 : 0) != 0, (String)"\u53ea\u80fd\u7981\u7528\u72b6\u6001\u4e3a\u201d\u542f\u7528\u201c\u7684\u5ba2\u6237\u4fe1\u606f");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)mdmCustomerMsgReqVo.getIds())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdateBatch(List<MdmCustomerContactReqVo> mdmCustomerContactReqVos) {
        if (!CollectionUtils.isEmpty(mdmCustomerContactReqVos)) {
            this.mdmCustomerContactService.saveOrUpdateBatch(CrmBeanUtil.copyList(mdmCustomerContactReqVos, MdmCustomerContactEntity.class));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrgCodeByCondition(MdmUpdateCusOrgCodeReqVo mdmUpdateCusOrgCodeReqVo) {
        List customerCodeList = mdmUpdateCusOrgCodeReqVo.getCustomerCodeList();
        String customerOrgCode = mdmUpdateCusOrgCodeReqVo.getCustomerOrgCode();
        if (CollectionUtils.isEmpty((Collection)customerCodeList) || StringUtils.isEmpty((String)customerOrgCode)) {
            throw new BusinessException("\u5ba2\u6237\u7f16\u7801\u96c6\u5408\u6216\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmCustomerMsgEntity::getCustomerCode, (Collection)customerCodeList)).set(MdmCustomerMsgEntity::getCustomerOrgCode, (Object)customerOrgCode)).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateCustomerOrg(MdmOrgCustomerUpdateReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getCustomerCodeList(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        MdmOrgRespVo org = this.mdmOrgService.query(new MdmOrgReqVo().setOrgCode(reqVo.getOrgCode()));
        Assert.notNull((Object)org, (String)"\u672a\u627e\u5230\u7ec4\u7ec7");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmCustomerMsgEntity::getCustomerCode, (Collection)reqVo.getCustomerCodeList())).set(MdmCustomerMsgEntity::getOrgCode, (Object)reqVo.getOrgCode())).update();
    }

    @Override
    public Map<String, String> findOrgCodeByCustomerCodeList(List<String> customerCodeList) {
        if (CollectionUtils.isEmpty(customerCodeList)) {
            return Collections.emptyMap();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerMsgEntity::getCustomerCode, customerCodeList)).select(new SFunction[]{MdmCustomerMsgEntity::getCustomerCode, MdmCustomerMsgEntity::getOrgCode}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.toMap(MdmCustomerMsgEntity::getCustomerCode, MdmCustomerMsgEntity::getOrgCode));
    }

    @Override
    public List<String> findAllCustomerCodeByUser(String userAccount) {
        if (StringUtils.isEmpty((String)userAccount)) {
            return Collections.emptyList();
        }
        return this.mdmCustomerMsgMapper.findAllCustomerCodeByUser(userAccount);
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCurrentAndSubCustomerList(MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo) {
        List<MdmOrgRespVo> orgRespVos;
        List orgCodeList = mdmCustomerOrgSearchReqVo.getOrgCodeList();
        if (!CollectionUtils.isEmpty((Collection)orgCodeList) && !CollectionUtils.isEmpty(orgRespVos = this.mdmOrgService.findAllChildrenOrgListByList(null, mdmCustomerOrgSearchReqVo.getOrgCodeList()))) {
            mdmCustomerOrgSearchReqVo.setOrgCodeList(orgRespVos.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList()));
        }
        return this.mdmCustomerMsgMapper.listCondition(mdmCustomerOrgSearchReqVo);
    }

    @Override
    public List<String> findCustomerCodeConditionList(CustomerCodeConditionReqVo customerCodeConditionReqVo) {
        if (CollectionUtil.listEmpty((List)customerCodeConditionReqVo.getChannelList()) && CollectionUtil.listEmpty((List)customerCodeConditionReqVo.getOrgCodeList())) {
            return Lists.newArrayList();
        }
        ArrayList merge = Lists.newArrayList();
        if (!CollectionUtil.listEmpty((List)customerCodeConditionReqVo.getChannelList())) {
            merge.addAll(((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerMsgEntity::getChannel, (Collection)customerCodeConditionReqVo.getChannelList())).select(new SFunction[]{MdmCustomerMsgEntity::getCustomerCode}).list());
        }
        if (!CollectionUtil.listEmpty((List)customerCodeConditionReqVo.getOrgCodeList())) {
            merge.addAll(((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerMsgEntity::getOrgCode, (Collection)customerCodeConditionReqVo.getOrgCodeList())).select(new SFunction[]{MdmCustomerMsgEntity::getCustomerCode}).list());
        }
        return merge.stream().map(MdmCustomerMsgEntity::getCustomerCode).collect(Collectors.toList());
    }

    @Override
    public List<MdmCustomerMsgRespVo> findPositionCustomerList(MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo) {
        return this.mdmCustomerMsgMapper.findPositionCustomerList(mdmPositionCustomerSearchReqVo);
    }

    @Override
    public MdmCustomerMsgRespVo queryBasic(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        MdmCustomerMsgEntity one = (MdmCustomerMsgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getId()), BaseIdEntity::getId, (Object)mdmCustomerMsgReqVo.getId())).eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCustomerCode()), MdmCustomerMsgEntity::getCustomerCode, (Object)mdmCustomerMsgReqVo.getCustomerCode())).eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getUserName()), MdmCustomerMsgEntity::getUserName, (Object)mdmCustomerMsgReqVo.getUserName())).eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCustomerPrimary()), MdmCustomerMsgEntity::getCustomerPrimary, (Object)mdmCustomerMsgReqVo.getCustomerPrimary())).eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)mdmCustomerMsgReqVo.getEnableStatus())).one());
        return (MdmCustomerMsgRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmCustomerMsgRespVo.class);
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCurrentAndSubPositionCustomer(MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo) {
        String positionCode = mdmPositionCustomerSearchReqVo.getPositionCode();
        Assert.hasText((String)positionCode, (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        mdmPositionCustomerSearchReqVo.setPositionCodeList(this.mdmPositionService.findAllChildrenPositionCodeList(null, positionCode));
        return this.findPositionCustomerList(mdmPositionCustomerSearchReqVo);
    }

    @Override
    @Async
    public void sendCustomerChangeMsg(List<String> customerCodeList) {
        log.info("\u901a\u77e5\u5ba2\u6237\u4fe1\u606f\u6216\u5ba2\u6237\u7684\u7ec4\u7ec7\u53d1\u751f\u53d8\u5316,\u5ba2\u6237\u7f16\u7801\u96c6\u5408:{}", customerCodeList);
        if (!CollectionUtils.isEmpty(customerCodeList)) {
            this.advise.adviseTarget(this.customerChangeAdviseTargetStrategy, customerCodeList);
        }
    }

    @Override
    public PageResult<MdmCustomerMsgContactPageRespVo> listAndContactPage(MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo) {
        UserRedis user = UserUtils.getUser();
        Assert.notNull((Object)user, (String)"\u5f53\u524d\u7528\u6237\u4f1a\u8bdd\u4e0d\u5b58\u5728");
        String positionCode = user.getPoscode();
        Assert.hasText((String)positionCode, (String)"\u7528\u6237\u5f53\u524d\u804c\u4f4d\u4e0d\u5b58\u5728");
        List<String> customerCodeList = this.mdmPositionCustomerService.findCustomerCodeByPosition(Collections.singletonList(positionCode));
        log.info("\u5ba2\u6237\u4fe1\u606f\uff1a\u5173\u8054\u804c\u4f4d\u7684\u5ba2\u6237:{}", customerCodeList);
        if (CollectionUtils.isEmpty(customerCodeList)) {
            return new PageResult();
        }
        mdmCustomerContactPageReqVo.setCustomerCodeList(customerCodeList);
        Page page = PageUtil.buildPage((Integer)mdmCustomerContactPageReqVo.getPageNum(), (Integer)mdmCustomerContactPageReqVo.getPageSize());
        List<MdmCustomerMsgContactPageRespVo> mdmCustomerMsgRespVos = this.mdmCustomerMsgMapper.listAndContactPage((Page<MdmCustomerMsgRespVo>)page, mdmCustomerContactPageReqVo);
        return PageResult.builder().data(mdmCustomerMsgRespVos).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmCustomerDockingRespVo> dockingList(MdmCustomerDockingReqVo mdmCustomerDockingReqVo) {
        Assert.hasText((String)mdmCustomerDockingReqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return this.mdmPositionCustomerService.findDockingListByCustomerCode(mdmCustomerDockingReqVo);
    }
}

