/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.dict.model.MdmDictAttrConfEntity;
import com.biz.crm.dict.service.MdmDictAttrConfService;
import com.biz.crm.nebular.mdm.dict.req.MdmDictAttrConfReqVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictAttrConfRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmdictattrconf"})
@Api(tags={"MDM-\u6570\u636e\u5b57\u5178-\u6269\u5c55\u5b57\u6bb5\u914d\u7f6e\u8868"})
@CrmGlobalLog
public class MdmDictAttrConfController {
    private static final Logger log = LoggerFactory.getLogger(MdmDictAttrConfController.class);
    @Autowired
    private MdmDictAttrConfService mdmDictAttrConfService;

    @ApiImplicitParams(value={@ApiImplicitParam(name="dictTypeCode", value="\u5b57\u5178\u7c7b\u578b", required=true, paramType="query")})
    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmDictMethod
    public Result<List<MdmDictAttrConfEntity>> list(@RequestParam(value="dictTypeCode") String dictTypeCode) {
        List<MdmDictAttrConfEntity> list = this.mdmDictAttrConfService.findList(dictTypeCode);
        return Result.ok(list);
    }

    @ApiOperation(value="\u67e5\u8be2\u6269\u5c55\u5b57\u6bb5\u5217\u8868")
    @PostMapping(value={"/findAttrConfList"})
    @CrmDictMethod
    public Result<List<MdmDictAttrConfRespVo>> findAttrConfList(@RequestBody MdmDictAttrConfReqVo mdmDictAttrConfReqVo) {
        return Result.ok(this.mdmDictAttrConfService.findAttrConfList(mdmDictAttrConfReqVo));
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET", notes="\u67e5\u8be2\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/query"})
    @CrmDictMethod
    public Result<MdmDictAttrConfEntity> query(@RequestParam(value="id", required=true) String id) {
        MdmDictAttrConfEntity entity = this.mdmDictAttrConfService.detail(id);
        return Result.ok((Object)((Object)entity));
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody MdmDictAttrConfEntity entity) {
        this.mdmDictAttrConfService.saveEntity(entity);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result update(@RequestBody MdmDictAttrConfEntity entity) {
        this.mdmDictAttrConfService.updateEntity(entity);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.mdmDictAttrConfService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }
}

