/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.humanarea.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.humanarea.mapper.MdmCommonQueryMapper;
import com.biz.crm.humanarea.service.MdmCommonQueryService;
import com.biz.crm.nebular.mdm.CrmTreeTenVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgRelationQueryReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgRelationRespVo;
import com.biz.crm.nebular.mdm.humanarea.EnginePositionRespVo;
import com.biz.crm.org.model.EngineOrgEntity;
import com.biz.crm.org.service.IEngineOrgService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"MdmCommonQueryServiceExpandImpl"})
public class MdmCommonQueryServiceImpl<M extends BaseMapper<T>, T>
implements MdmCommonQueryService {
    private static final Logger log = LoggerFactory.getLogger(MdmCommonQueryServiceImpl.class);
    @Resource
    private MdmCommonQueryMapper mdmCommonQueryMapper;
    @Resource
    private IEngineOrgService engineOrgService;

    @Override
    public List<EngineOrgRelationRespVo> findOrgRelationList(EngineOrgRelationQueryReqVo reqVo) {
        ArrayList<EngineOrgRelationRespVo> list = new ArrayList();
        List orgCodeList = reqVo.getOrgCodeList();
        if (CollectionUtil.listEmpty((List)orgCodeList)) {
            return new ArrayList<EngineOrgRelationRespVo>();
        }
        List orgList = ((LambdaQueryChainWrapper)this.engineOrgService.lambdaQuery().in(EngineOrgEntity::getOrgCode, (Collection)orgCodeList)).list();
        if (CollectionUtil.listEmpty((List)orgList)) {
            return new ArrayList<EngineOrgRelationRespVo>();
        }
        List<Object> positionList = new ArrayList();
        if (Integer.valueOf(YesNoEnum.yesNoEnum.ONE.getValue()).equals(reqVo.getPositionQueryType())) {
            positionList = this.mdmCommonQueryMapper.findPositionUserOrgList(new ArrayList<String>(), CrmEnableStatusEnum.ENABLE.getCode());
            Map<Object, Object> ruleCodeMap = new HashMap(16);
            if (CollectionUtil.listNotEmptyNotSizeZero(positionList)) {
                ruleCodeMap = positionList.stream().collect(Collectors.groupingBy(CrmTreeTenVo::getRuleCode));
            }
            for (EngineOrgEntity item : orgList) {
                EngineOrgRelationRespVo copy = (EngineOrgRelationRespVo)CrmBeanUtil.copy((Object)((Object)item), EngineOrgRelationRespVo.class);
                ArrayList orgPositionList = new ArrayList();
                for (Map.Entry<Object, Object> entry : ruleCodeMap.entrySet()) {
                    if (!((String)entry.getKey()).startsWith(item.getRuleCode())) continue;
                    orgPositionList.addAll((Collection)entry.getValue());
                }
                copy.setPositionList(orgPositionList);
                list.add(copy);
            }
        } else if (Integer.valueOf(YesNoEnum.yesNoEnum.ZERO.getValue()).equals(reqVo.getPositionQueryType())) {
            positionList = this.mdmCommonQueryMapper.findPositionUserOrgList(orgCodeList, CrmEnableStatusEnum.ENABLE.getCode());
            Map<Object, Object> orgCodeMap = new HashMap(16);
            if (CollectionUtil.listNotEmptyNotSizeZero(positionList)) {
                orgCodeMap = positionList.stream().collect(Collectors.groupingBy(EnginePositionRespVo::getOrgCode));
            }
            for (EngineOrgEntity item : orgList) {
                EngineOrgRelationRespVo copy = (EngineOrgRelationRespVo)CrmBeanUtil.copy((Object)((Object)item), EngineOrgRelationRespVo.class);
                if (orgCodeMap.containsKey(item.getOrgCode())) {
                    copy.setPositionList((List)orgCodeMap.get(item.getOrgCode()));
                }
                list.add(copy);
            }
        } else {
            list = CrmBeanUtil.copyList((List)orgList, EngineOrgRelationRespVo.class);
        }
        return list;
    }
}

