/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.position.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.position.req.MdmPositionCurrentUserReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionPageReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionSelectReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionSelectRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmPositionController"})
@Api(tags={"MDM-\u804c\u4f4d\u7ba1\u7406"})
public class MdmPositionController {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionController.class);
    @Autowired
    private MdmPositionService mdmPositionService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/pageList"})
    @CrmLog
    public Result<PageResult<MdmPositionPageRespVo>> pageList(@RequestBody MdmPositionPageReqVo reqVo) {
        PageResult<MdmPositionPageRespVo> result = this.mdmPositionService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="positionCode", value="\u7f16\u7801\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/detail"})
    @CrmLog
    @CrmDictMethod
    public Result<MdmPositionRespVo> detail(@RequestParam(value="id", required=false) String id, @RequestParam(value="positionCode", required=false) String positionCode) {
        MdmPositionRespVo respVo = this.mdmPositionService.detail(id, positionCode);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody MdmPositionReqVo mdmPositionReqVo) {
        this.mdmPositionService.save(mdmPositionReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody MdmPositionReqVo mdmPositionReqVo) {
        this.mdmPositionService.update(mdmPositionReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.mdmPositionService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.mdmPositionService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.mdmPositionService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u67e5\u8be2\u804c\u4f4d\u4e0b\u62c9\u6846\u5217\u8868")
    @PostMapping(value={"/positionSelectList"})
    @CrmLog
    public Result<List<MdmPositionSelectRespVo>> positionSelectList(@RequestBody MdmPositionSelectReqVo reqVo) {
        return Result.ok(this.mdmPositionService.findPositionSelectList(reqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u804c\u4f4d\u4e0b\u62c9\u6846\u5217\u8868\uff08\u6392\u9664\u5df2\u5173\u8054\u7528\u6237\u7684\u4e3b\u804c\u4f4d\uff09\uff08\u7528\u6237\u65b0\u589e\u7f16\u8f91\u9009\u62e9\u5173\u8054\u804c\u4f4d\uff09")
    @PostMapping(value={"/positionCanUsedToRelateUserList"})
    @CrmLog
    public Result<List<MdmPositionSelectRespVo>> positionCanUsedToRelateUserList(@RequestBody MdmPositionSelectReqVo reqVo) {
        return Result.ok(this.mdmPositionService.positionCanUsedToRelateUserList(reqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u804c\u4f4d\u9009\u62e9\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/positionSelectPage"})
    @CrmLog
    public Result<PageResult<MdmPositionSelectRespVo>> positionSelectPage(@RequestBody MdmPositionSelectReqVo reqVo) {
        return Result.ok(this.mdmPositionService.positionSelectPage(reqVo));
    }

    @ApiOperation(value="\u6839\u636euserName\u83b7\u53d6\u7528\u6237\u4e3b\u804c\u4f4d")
    @PostMapping(value={"/getUserPrimaryPosition"})
    @CrmLog
    public Result<MdmPositionRespVo> getUserPrimaryPosition(@RequestBody MdmUserReqVo reqVo) {
        return Result.ok((Object)this.mdmPositionService.getUserPrimaryPosition(reqVo));
    }

    @ApiOperation(value="\u6839\u636euserName\u83b7\u53d6\u7528\u6237\u5f53\u524d\u804c\u4f4d")
    @PostMapping(value={"/getUserCurrentPosition"})
    @CrmLog
    public Result<MdmPositionRespVo> getUserCurrentPosition(@RequestBody MdmUserReqVo reqVo) {
        return Result.ok((Object)this.mdmPositionService.getUserCurrentPosition(reqVo));
    }

    @ApiOperation(value="\u6839\u636euserName\u83b7\u53d6\u7528\u6237\u5168\u90e8\u804c\u4f4d")
    @PostMapping(value={"/getUserAllPositionList"})
    @CrmLog
    public Result<List<MdmPositionRespVo>> getUserAllPositionList(@RequestBody MdmUserReqVo reqVo) {
        return Result.ok(this.mdmPositionService.getUserAllPositionList(reqVo));
    }

    @ApiOperation(value="\u5207\u6362\u7528\u6237\u4e3b\u804c\u4f4d")
    @PostMapping(value={"/changeUserPrimaryPosition"})
    @CrmLog
    public Result changeUserPrimaryPosition(@RequestBody MdmPositionReqVo reqVo) {
        this.mdmPositionService.changeUserPrimaryPosition(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5207\u6362\u7528\u6237\u5f53\u524d\u804c\u4f4d")
    @PostMapping(value={"/changeUserCurrentPosition"})
    @CrmLog
    public Result changeUserCurrentPosition(@RequestBody MdmPositionReqVo reqVo) {
        this.mdmPositionService.changeUserCurrentPosition(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u4ee5\u804c\u4f4d\u7ef4\u5ea6\u7684\u804c\u4f4d\u53ca\u5173\u8054\u7528\u6237\u3001\u7ec4\u7ec7\u3001\u4e0a\u7ea7\u4fe1\u606f")
    @PostMapping(value={"/findPositionUserOrgList"})
    @CrmLog
    public Result<List<MdmPositionUserOrgRespVo>> findPositionUserOrgList(@RequestBody MdmPositionUserOrgReqVo reqVo) {
        return Result.ok(this.mdmPositionService.findPositionUserOrgList(reqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u4ee5\u804c\u4f4d\u7ef4\u5ea6\u7684\u804c\u4f4d\u53ca\u5173\u8054\u7528\u6237\u3001\u7ec4\u7ec7\u3001\u4e0a\u7ea7\u4fe1\u606f\uff08\u5206\u9875\uff09")
    @PostMapping(value={"/findPositionUserOrgPageList"})
    @CrmLog
    public Result<PageResult<MdmPositionUserOrgRespVo>> findPositionUserOrgPageList(@RequestBody MdmPositionUserOrgReqVo reqVo) {
        return Result.ok(this.mdmPositionService.findPositionUserOrgPageList(reqVo));
    }

    @ApiOperation(value="\u4ee5\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u672c\u4eba\u53ca\u540c\u7ec4\u7ec7\u7684\u4eba\u53ca\u4e0b\u5c5e\uff08\u5206\u9875\uff09")
    @PostMapping(value={"/findCurrentPositionUserOrgPageList"})
    @CrmLog
    public Result<PageResult<MdmPositionUserOrgRespVo>> findCurrentPositionUserOrgPageList(@RequestBody MdmPositionCurrentUserReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        if (null == user) {
            throw new BusinessException("\u65e0\u6cd5\u83b7\u53d6\u767b\u9646\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u767b\u9646");
        }
        String orgCode = user.getOrgcode();
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            throw new BusinessException("\u65e0\u6cd5\u83b7\u53d6\u767b\u9646\u8005\u5f53\u524d\u7ec4\u7ec7\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u767b\u9646");
        }
        MdmPositionUserOrgReqVo orgReqVo = (MdmPositionUserOrgReqVo)CrmBeanUtil.copy((Object)reqVo, MdmPositionUserOrgReqVo.class);
        if (null == reqVo.getCurrentLoginOrg() || reqVo.getCurrentLoginOrg().booleanValue()) {
            orgReqVo.setAllUnderThisOrgCode(orgCode);
        } else {
            orgReqVo.setAllUnderThisOrgCodeExcludeSelf(orgCode);
        }
        orgReqVo.setPrimaryFlag(YesNoEnum.yesNoEnum.ONE.getValue());
        orgReqVo.setUnionFuzzyQuery1(reqVo.getUserNameOrFullName());
        return Result.ok(this.mdmPositionService.findPositionUserOrgPageList(orgReqVo));
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u4e0e\u804c\u4f4d\u5173\u8054\u7684\u7ec4\u7ec7\u7f16\u7801")
    @PostMapping(value={"/batchUpdatePositionOrg"})
    public Result batchUpdatePositionOrg(@RequestBody MdmPositionUserOrgReqVo reqVo) {
        this.mdmPositionService.batchUpdatePositionOrg(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u91cd\u7f6e\u964d\u7ef4\u7f16\u7801")
    @PostMapping(value={"/resetPositionRuleCode"})
    public Result resetPositionRuleCode() {
        this.mdmPositionService.resetPositionRuleCode();
        return Result.ok();
    }
}

