/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pricesetting.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceSettingRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.pricesetting.mapper.MdmPriceSettingMapper;
import com.biz.crm.pricesetting.model.MdmPriceSettingEntity;
import com.biz.crm.pricesetting.service.IMdmPriceSettingService;
import com.biz.crm.pricesetting.service.impl.MdmPriceSettingServiceHelper;
import com.biz.crm.product.service.MdmProductService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"MdmPriceSettingServiceExpandImpl"})
public class MdmPriceSettingServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPriceSettingMapper, MdmPriceSettingEntity>
implements IMdmPriceSettingService {
    private static final Logger log = LoggerFactory.getLogger(MdmPriceSettingServiceImpl.class);
    @Resource
    private MdmPriceSettingMapper mdmPriceSettingMapper;
    @Resource
    private MdmPriceSettingServiceHelper mdmPriceSettingServiceHelper;
    @Resource
    private MdmProductService mdmProductService;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;

    @Override
    public PageResult<MdmPriceSettingRespVo> findList(MdmPriceSettingReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmPriceSettingRespVo> list = this.mdmPriceSettingMapper.findList((Page<MdmPriceSettingRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmPriceSettingRespVo query(MdmPriceSettingReqVo reqVo) {
        MdmProductRespVo mdmProductRespVo;
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u67e5\u8be2\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmPriceSettingEntity mdmPriceSettingEntity = (MdmPriceSettingEntity)((Object)this.mdmPriceSettingMapper.selectById((Serializable)((Object)reqVo.getId())));
        if (ObjectUtils.isEmpty((Object)((Object)mdmPriceSettingEntity))) {
            return new MdmPriceSettingRespVo();
        }
        MdmPriceSettingRespVo mdmPriceSettingRespVo = (MdmPriceSettingRespVo)CrmBeanUtil.copy((Object)((Object)mdmPriceSettingEntity), MdmPriceSettingRespVo.class);
        if (StringUtils.isNotEmpty((String)mdmPriceSettingRespVo.getProductCode()) && !ObjectUtils.isEmpty((Object)(mdmProductRespVo = this.mdmProductService.detail(null, mdmPriceSettingRespVo.getProductCode())))) {
            mdmPriceSettingRespVo.setMdmProductRespVo(mdmProductRespVo);
        }
        return mdmPriceSettingRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmPriceSettingReqVo reqVo) {
        this.mdmPriceSettingServiceHelper.saveCheck(reqVo);
        this.mdmPriceSettingServiceHelper.dataUniqueSaveOrUpdate(reqVo);
    }

    @Override
    public Boolean checkDate(MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        this.mdmPriceSettingServiceHelper.saveCheck(mdmPriceSettingReqVo);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"condition_type_code", (Object)mdmPriceSettingReqVo.getConditionTypeCode());
        wrapper.eq((Object)"condition_group_code", (Object)mdmPriceSettingReqVo.getConditionGroupCode());
        this.mdmPriceSettingServiceHelper.setFieldCondition((QueryWrapper<MdmPriceSettingEntity>)wrapper, mdmPriceSettingReqVo);
        List mdmPriceSettingEntities = this.mdmPriceSettingMapper.selectList((Wrapper)wrapper);
        boolean flag = false;
        if (CollectionUtil.listNotEmpty((List)mdmPriceSettingEntities)) {
            long dateStart = DateUtil.str2Date((String)mdmPriceSettingReqVo.getBeginData().trim().concat(" ").concat(mdmPriceSettingReqVo.getBeginDataSecond()), (SimpleDateFormat)DateUtil.datetimeFormat).getTime();
            long dateEnd = DateUtil.str2Date((String)mdmPriceSettingReqVo.getEndData().trim().concat(" ").concat(mdmPriceSettingReqVo.getEndDataSecond()), (SimpleDateFormat)DateUtil.datetimeFormat).getTime();
            for (MdmPriceSettingEntity entity : mdmPriceSettingEntities) {
                if (StringUtils.isNotEmpty((String)mdmPriceSettingReqVo.getId()) && mdmPriceSettingReqVo.getId().equalsIgnoreCase(entity.getId())) continue;
                long oldStart = DateUtil.str2Date((String)entity.getBeginData().trim().concat(" ").concat(entity.getBeginDataSecond()), (SimpleDateFormat)DateUtil.datetimeFormat).getTime();
                long oldEnd = DateUtil.str2Date((String)entity.getEndData().trim().concat(" ").concat(entity.getEndDataSecond()), (SimpleDateFormat)DateUtil.datetimeFormat).getTime();
                if (dateEnd < oldStart || dateStart > oldEnd) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmPriceSettingReqVo reqVo) {
        this.mdmPriceSettingServiceHelper.saveCheck(reqVo);
        this.mdmPriceSettingServiceHelper.dataUniqueSaveOrUpdate(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmPriceSettingReqVo reqVo) {
        AssertUtils.isNotEmpty((Collection)reqVo.getIds(), (String)"\u5220\u9664\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List mdmPriceSettingEntities = this.mdmPriceSettingMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmPriceSettingEntities)) {
            this.mdmPriceSettingMapper.deleteBatchIds(reqVo.getIds());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmPriceSettingReqVo reqVo) {
        List mdmPriceSettingEntities = this.mdmPriceSettingMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmPriceSettingEntities)) {
            mdmPriceSettingEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmPriceSettingEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmPriceSettingReqVo reqVo) {
        List mdmPriceSettingEntities = this.mdmPriceSettingMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmPriceSettingEntities)) {
            mdmPriceSettingEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmPriceSettingEntities);
    }

    @Override
    public Map<String, BigDecimal> findPriceByGoodsAndCusCode(List<String> goodsCodes, String cusCodes) {
        HashMap<String, BigDecimal> reMap = new HashMap<String, BigDecimal>();
        if (org.springframework.util.CollectionUtils.isEmpty(goodsCodes)) {
            return reMap;
        }
        for (String goodsCode : goodsCodes) {
            reMap.put(goodsCode, BigDecimal.ONE);
        }
        return reMap;
    }

    @Override
    public List<MdmCustomerMsgSelectRespVo> findCustomerSelectList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        return this.mdmCustomerMsgService.list(mdmCustomerMsgReqVo);
    }

    @Override
    public List<MdmProductRespVo> findProductSelectList(MdmProductReqVo mdmProductReqVo) {
        return CrmBeanUtil.copyList((List)this.mdmProductService.list(), MdmProductRespVo.class);
    }
}

