/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserChangePasswordReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserPageRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmUserController"})
@Api(tags={"MDM-\u7528\u6237\u7ba1\u7406"})
public class MdmUserController {
    private static final Logger log = LoggerFactory.getLogger(MdmUserController.class);
    @Autowired
    private MdmUserService mdmUserService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageList"})
    @CrmLog
    public Result<PageResult<MdmUserPageRespVo>> pageList(@RequestBody MdmUserPageReqVo reqVo) {
        PageResult<MdmUserPageRespVo> result = this.mdmUserService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="userName", value="\u7528\u6237\u767b\u5f55\u540d", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/detail"})
    @CrmLog
    @CrmDictMethod
    public Result<MdmUserRespVo> detail(@RequestParam(value="id", required=false) String id, @RequestParam(value="userName", required=false) String userName) {
        MdmUserReqVo reqVo = new MdmUserReqVo();
        reqVo.setId(id);
        reqVo.setUserName(userName);
        return Result.ok((Object)this.mdmUserService.query(reqVo));
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody MdmUserEditReqVo reqVo) {
        this.mdmUserService.save(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody MdmUserEditReqVo reqVo) {
        this.mdmUserService.update(reqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.mdmUserService.deleteBatch(new MdmUserReqVo().setIds(ids));
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.mdmUserService.enableBatch(new MdmUserReqVo().setIds(ids));
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.mdmUserService.disableBatch(new MdmUserReqVo().setIds(ids));
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    @PostMapping(value={"/changePassword"})
    public Result changePassword(@RequestBody MdmUserChangePasswordReqVo reqVo) {
        this.mdmUserService.changePassword(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u91cd\u7f6e\u7528\u6237\u5bc6\u7801", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/resetPassword"})
    @CrmLog
    public Result resetPassword(@RequestBody List<String> ids) {
        this.mdmUserService.resetPassword(new MdmUserReqVo().setIds(ids));
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7528\u6237\u89e3\u9501", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/unlock"})
    @CrmLog
    public Result unlock(@RequestBody List<String> ids) {
        this.mdmUserService.unlock(new MdmUserReqVo().setIds(ids));
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7528\u6237\u57fa\u672c\u4fe1\u606f\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list_detail"})
    public Result<List<MdmUserRespVo>> listDetail(@RequestBody MdmUserReqVo mdmUserReqVo) {
        return Result.ok(this.mdmUserService.listDetail(mdmUserReqVo));
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u5f53\u524d\u804c\u4f4d\u5173\u8054\u7684\u4e2a\u4eba\u4fe1\u606f\u8be6\u60c5")
    @GetMapping(value={"/getCurUserPositionDetail"})
    public Result<MdmPositionUserOrgRespVo> getCurUserPositionDetail() {
        return Result.ok((Object)this.mdmUserService.getCurUserPositionDetail());
    }
}

