/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.bpmrole.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.bpmrole.mapper.MdmPositionBpmRoleMapper;
import com.biz.crm.bpmrole.model.MdmPositionBpmRoleEntity;
import com.biz.crm.bpmrole.service.MdmPositionBpmRoleService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmPositionBpmRoleServiceExpandImpl"})
public class MdmPositionBpmRoleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPositionBpmRoleMapper, MdmPositionBpmRoleEntity>
implements MdmPositionBpmRoleService {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionBpmRoleServiceImpl.class);
    @Resource
    private MdmPositionBpmRoleMapper mdmPositionBpmRoleMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addPositionBpmRole(String positionCode, String bpmRoleCode) {
        List list;
        if (StringUtils.isNotEmpty((String)positionCode) && StringUtils.isNotEmpty((String)bpmRoleCode) && CollectionUtil.listEmpty((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionBpmRoleEntity::getPositionCode, (Object)positionCode)).eq(MdmPositionBpmRoleEntity::getBpmRoleCode, (Object)bpmRoleCode)).list()))) {
            MdmPositionBpmRoleEntity entity = new MdmPositionBpmRoleEntity();
            entity.setPositionCode(positionCode);
            entity.setBpmRoleCode(bpmRoleCode);
            this.save((Object)entity);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addPositionBpmRoles(String positionCode, List<String> bpmRoleCodeList) {
        if (StringUtils.isNotEmpty((String)positionCode) && CollectionUtil.listNotEmptyNotSizeZero(bpmRoleCodeList)) {
            bpmRoleCodeList.forEach(bpmRoleCode -> this.addPositionBpmRole(positionCode, (String)bpmRoleCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBpmRolePositions(String bpmRoleCode, List<String> positionCodeList) {
        if (StringUtils.isNotEmpty((String)bpmRoleCode) && CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
            positionCodeList.forEach(positionCode -> this.addPositionBpmRole((String)positionCode, bpmRoleCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByPosition(String positionCode) {
        if (StringUtils.isNotEmpty((String)positionCode)) {
            this.removeByPositions(Collections.singletonList(positionCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByPositions(List<String> positionCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionBpmRoleEntity::getPositionCode, positionCodeList)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByBpmRole(String bpmRoleCode) {
        if (StringUtils.isNotEmpty((String)bpmRoleCode)) {
            this.removeByBpmRoles(Collections.singletonList(bpmRoleCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByBpmRoles(List<String> bpmRoleCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(bpmRoleCodeList)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionBpmRoleEntity::getBpmRoleCode, bpmRoleCodeList)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByPositionBpmRole(String positionCode, String bpmRoleCode) {
        if (StringUtils.isNotEmpty((String)positionCode) && StringUtils.isNotEmpty((String)bpmRoleCode)) {
            this.removeByPositionBpmRoles(positionCode, Collections.singletonList(bpmRoleCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByPositionBpmRoles(String positionCode, List<String> bpmRoleCodeList) {
        if (StringUtils.isNotEmpty((String)positionCode) && CollectionUtil.listNotEmptyNotSizeZero(bpmRoleCodeList)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionBpmRoleEntity::getPositionCode, (Object)positionCode)).in(MdmPositionBpmRoleEntity::getBpmRoleCode, bpmRoleCodeList)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByBpmRolePositions(String bpmRoleCode, List<String> positionCodeList) {
        if (StringUtils.isNotEmpty((String)bpmRoleCode) && CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionBpmRoleEntity::getBpmRoleCode, (Object)bpmRoleCode)).in(MdmPositionBpmRoleEntity::getPositionCode, positionCodeList)).remove();
        }
    }
}

