/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.customer.mapper.MdmCustomerSaleAreaMapper;
import com.biz.crm.customer.model.MdmCustomerSaleAreaEntity;
import com.biz.crm.customer.service.MdmCustomerSaleAreaService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerSaleAreaReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerSaleAreaRespVo;
import com.biz.crm.util.CrmBeanUtil;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"MdmCustomerSaleAreaServiceExpandImpl"})
public class MdmCustomerSaleAreaServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmCustomerSaleAreaMapper, MdmCustomerSaleAreaEntity>
implements MdmCustomerSaleAreaService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerSaleAreaServiceImpl.class);
    @Resource
    private MdmCustomerSaleAreaMapper mdmCustomerSaleAreaMapper;

    @Override
    public void remove(String customerCode) {
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerSaleAreaEntity::getCustomerCode, (Object)customerCode)).remove();
    }

    @Override
    public void add(List<MdmCustomerSaleAreaEntity> list) {
        this.saveBatch(list);
    }

    @Override
    public List<MdmCustomerSaleAreaRespVo> listCondition(MdmCustomerSaleAreaReqVo mdmCustomerSaleAreaReqVo) {
        return this.mdmCustomerSaleAreaMapper.listCondition(mdmCustomerSaleAreaReqVo);
    }

    @Override
    public void setUpArea(List<MdmCustomerSaleAreaReqVo> mdmCustomerSaleAreaReqVos, String customerCode) {
        this.remove(customerCode);
        if (!CollectionUtils.isEmpty(mdmCustomerSaleAreaReqVos)) {
            mdmCustomerSaleAreaReqVos.stream().peek(x -> x.setCustomerCode(customerCode)).forEach(x -> {});
            List mdmCustomerSaleAreaEntities = CrmBeanUtil.copyList(mdmCustomerSaleAreaReqVos, MdmCustomerSaleAreaEntity.class);
            this.add(mdmCustomerSaleAreaEntities);
        }
    }
}

