/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.org.service.impl;

import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.model.MdmCustomerMsgEntity;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.nebular.mdm.org.req.MdmOrgCustomerReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgCustomerRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.org.mapper.MdmOrgCustomerMapper;
import com.biz.crm.org.service.MdmOrgCustomerService;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.util.PageUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class MdmOrgCustomerServiceImpl
implements MdmOrgCustomerService {
    @Resource
    private MdmOrgCustomerMapper mdmOrgCustomerMapper;
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmCustomerMsgService mdmcustomerMsgService;

    @Override
    public PageResult<MdmOrgCustomerRespVo> findOrgCustomerList(MdmOrgCustomerReqVo reqVo) {
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmOrgCustomerRespVo> list = this.mdmOrgCustomerMapper.findOrgCustomerList((Page<MdmOrgCustomerRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateCustomerOrg(MdmOrgCustomerReqVo reqVo) {
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        Assert.notEmpty((Collection)reqVo.getCustomerCodeList(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        MdmOrgRespVo org = this.mdmOrgService.query(new MdmOrgReqVo().setOrgCode(reqVo.getOrgCode()));
        Assert.notNull((Object)org, (String)"\u672a\u627e\u5230\u7ec4\u7ec7");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmcustomerMsgService.lambdaUpdate().in(MdmCustomerMsgEntity::getCustomerCode, (Collection)reqVo.getCustomerCodeList())).set(MdmCustomerMsgEntity::getOrgCode, (Object)reqVo.getOrgCode())).update();
    }
}

