/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.position.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.position.mapper.MdmPositionCustomerMapper;
import com.biz.crm.position.model.MdmPositionCustomerEntity;
import com.biz.crm.position.service.MdmPositionCustomerService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmPositionCustomerServiceExpandImpl"})
public class MdmPositionCustomerServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPositionCustomerMapper, MdmPositionCustomerEntity>
implements MdmPositionCustomerService {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionCustomerServiceImpl.class);
    @Autowired
    private MdmPositionCustomerMapper mdmPositionCustomerMapper;

    @Override
    public List<String> findCustomerCodeByPosition(List<String> positionCodeList) {
        if (CollectionUtils.isEmpty(positionCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionCustomerEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionCustomerEntity::getCustomerCode}).list().stream().filter(x -> !StringUtils.isEmpty((String)x.getCustomerCode())).map(MdmPositionCustomerEntity::getCustomerCode).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addRelation(String customerCode, String positionCode) {
        if (StringUtils.isNotEmpty((String)customerCode) && StringUtils.isNotEmpty((String)positionCode)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionCustomerEntity::getCustomerCode, (Object)customerCode)).eq(MdmPositionCustomerEntity::getPositionCode, (Object)positionCode)).remove();
            MdmPositionCustomerEntity entity = new MdmPositionCustomerEntity();
            entity.setCustomerCode(customerCode);
            entity.setPositionCode(positionCode);
            this.save((Object)entity);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replacePosition(List<String> ids, String positionCode) {
        if (CollectionUtil.listNotEmptyNotSizeZero(ids) && StringUtils.isNotEmpty((String)positionCode)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(MdmPositionCustomerEntity::getPositionCode, (Object)positionCode)).update();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRelations(List<String> ids) {
        if (CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByCustomer(String customerCode) {
        if (StringUtils.isNotEmpty((String)customerCode)) {
            this.removeByCustomers(Collections.singletonList(customerCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByCustomers(List<String> customerCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(customerCodes)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionCustomerEntity::getCustomerCode, customerCodes)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByPosition(String positionCode) {
        if (StringUtils.isNotEmpty((String)positionCode)) {
            this.removeByPositions(Collections.singletonList(positionCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByPositions(List<String> positionCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodes)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionCustomerEntity::getPositionCode, positionCodes)).remove();
        }
    }

    @Override
    public void setUpDocking(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        String customerCode = mdmCustomerMsgReqVo.getCustomerCode();
        Assert.hasText((String)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionCustomerEntity::getCustomerCode, (Object)customerCode)).remove();
        List mdmCustomerDockingVos = mdmCustomerMsgReqVo.getMdmCustomerDockingVos();
        if (!CollectionUtils.isEmpty((Collection)mdmCustomerDockingVos)) {
            mdmCustomerDockingVos = mdmCustomerDockingVos.stream().peek(x -> x.setCustomerCode(customerCode)).collect(Collectors.toList());
            List mdmPositionCustomerEntities = CrmBeanUtil.copyList(mdmCustomerDockingVos, MdmPositionCustomerEntity.class);
            this.saveBatch(mdmPositionCustomerEntities);
        }
    }

    @Override
    public List<MdmCustomerDockingRespVo> findDockingListByCustomerCode(MdmCustomerDockingReqVo mdmCustomerDockingReqVo) {
        List<MdmCustomerDockingRespVo> list = this.mdmPositionCustomerMapper.findDockingListByCustomerCode(mdmCustomerDockingReqVo);
        if (!CollectionUtils.isEmpty(list)) {
            return list.stream().filter(x -> StringUtils.isEmpty((String)x.getPositionCode()) || !StringUtils.isEmpty((String)x.getOrgName()) && !StringUtils.isEmpty((String)x.getUserName())).collect(Collectors.toList());
        }
        return list;
    }
}

