/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pricesetting.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.mdm.PriceSettingStatusEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceSettingRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.pricesetting.service.IMdmPriceSettingService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmPriceSettingController"})
@Api(tags={"\u4ef7\u683c\u7ef4\u62a4\u4e3b\u8868 "})
@CrmGlobalLog
public class MdmPriceSettingController {
    private static final Logger log = LoggerFactory.getLogger(MdmPriceSettingController.class);
    @Autowired
    private IMdmPriceSettingService mdmPriceSettingService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    public Result<PageResult<MdmPriceSettingRespVo>> list(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        PageResult<MdmPriceSettingRespVo> result = this.mdmPriceSettingService.findList(mdmPriceSettingReqVo);
        if (result.getData() != null) {
            result.getData().forEach(item -> item.setEnableStatusName(PriceSettingStatusEnum.getNameByCode((String)item.getEnableStatus())));
        }
        return Result.ok(result);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true, paramType="query")})
    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/query"})
    @CrmDictMethod
    public Result<MdmPriceSettingRespVo> query(@RequestParam(value="id") String id) {
        MdmPriceSettingReqVo mdmPriceSettingReqVo = new MdmPriceSettingReqVo();
        mdmPriceSettingReqVo.setId(id);
        MdmPriceSettingRespVo respVo = this.mdmPriceSettingService.query(mdmPriceSettingReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        this.mdmPriceSettingService.save(mdmPriceSettingReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u65b0\u589e\u65f6\u95f4\u4ea4\u53c9\u6821\u9a8c")
    @PostMapping(value={"/checkDate"})
    public Result checkDate(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        Boolean result = this.mdmPriceSettingService.checkDate(mdmPriceSettingReqVo);
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result update(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        this.mdmPriceSettingService.update(mdmPriceSettingReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        MdmPriceSettingReqVo mdmPriceSettingReqVo = new MdmPriceSettingReqVo();
        mdmPriceSettingReqVo.setIds(ids);
        this.mdmPriceSettingService.deleteBatch(mdmPriceSettingReqVo);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        MdmPriceSettingReqVo mdmPriceSettingReqVo = new MdmPriceSettingReqVo();
        mdmPriceSettingReqVo.setIds(ids);
        this.mdmPriceSettingService.enableBatch(mdmPriceSettingReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        MdmPriceSettingReqVo mdmPriceSettingReqVo = new MdmPriceSettingReqVo();
        mdmPriceSettingReqVo.setIds(ids);
        this.mdmPriceSettingService.disableBatch(mdmPriceSettingReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u5ba2\u6237\u4e0b\u62c9\u6846")
    @PostMapping(value={"/findCustomerSelectList"})
    public Result<List<MdmCustomerMsgSelectRespVo>> findCustomerSelectList(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        return Result.ok(this.mdmPriceSettingService.findCustomerSelectList(mdmCustomerMsgReqVo));
    }

    @ApiOperation(value="\u5546\u54c1\u4e0b\u62c9\u6846")
    @PostMapping(value={"/findProductSelectList"})
    @CrmDictMethod
    public Result<List<MdmProductRespVo>> findProductSelectList(@RequestBody MdmProductReqVo mdmProductReqVo) {
        return Result.ok(this.mdmPriceSettingService.findProductSelectList(mdmProductReqVo));
    }
}

