/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.product.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.availablelist.service.CusAvailablelistService;
import com.biz.crm.availablelist.service.TerminalAvailablelistService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.FileTypeEnum;
import com.biz.crm.eunm.IsShelfEnum;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.product.req.MdmProductMediaReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductIntroductionRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMaterialRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMediaRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductSaleCompanyRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.product.mapper.MdmProductMapper;
import com.biz.crm.product.model.MdmProductEntity;
import com.biz.crm.product.model.MdmProductIntroductionEntity;
import com.biz.crm.product.model.MdmProductMaterialEntity;
import com.biz.crm.product.model.MdmProductMediaEntity;
import com.biz.crm.product.service.IMdmProductIntroductionService;
import com.biz.crm.product.service.MdmProductMaterialService;
import com.biz.crm.product.service.MdmProductMediaService;
import com.biz.crm.product.service.MdmProductService;
import com.biz.crm.product.service.impl.MdmProductBuilder;
import com.biz.crm.product.service.impl.MdmProductServiceHelper;
import com.biz.crm.productlevel.model.MdmProductLevelEntity;
import com.biz.crm.productlevel.service.MdmProductLevelService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.PageUtil;
import com.bizunited.platform.common.util.JsonUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmProductServiceExpandImpl"})
public class MdmProductServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmProductMapper, MdmProductEntity>
implements MdmProductService {
    private static final Logger log = LoggerFactory.getLogger(MdmProductServiceImpl.class);
    @Resource
    private MdmProductMapper mdmProductMapper;
    @Autowired
    private MdmProductServiceHelper productServiceHelper;
    @Autowired
    private MdmProductMediaService mdmProductMediaService;
    @Autowired
    private MdmProductMaterialService mdmProductMaterialService;
    @Resource
    private IMdmProductIntroductionService mdmProductIntroductionService;
    @Resource
    private CusAvailablelistService cusAvailablelistService;
    @Resource
    private TerminalAvailablelistService terminalAvailablelistService;
    @Resource
    private MdmProductLevelService mdmProductLevelService;
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Value(value="${rocketmq.topic}${rocketmq.environment-variable}")
    private String topic;

    @Override
    public PageResult<MdmProductRespVo> findList(MdmProductReqVo mdmProductReqVo) {
        MdmProductLevelRespVo productLevel;
        Page page = PageUtil.buildPage((Integer)mdmProductReqVo.getPageNum(), (Integer)mdmProductReqVo.getPageSize());
        if (StringUtils.isNotEmpty((CharSequence)mdmProductReqVo.getCode()) && (productLevel = this.mdmProductLevelService.detail(null, mdmProductReqVo.getCode())) != null) {
            mdmProductReqVo.setRuleCode(productLevel.getRuleCode());
        }
        List<MdmProductRespVo> list = this.mdmProductMapper.findList((Page<MdmProductRespVo>)page, mdmProductReqVo);
        this.productServiceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmDictMethod
    public MdmProductRespVo detail(String id, String productCode) {
        MdmProductEntity one;
        if ((StringUtils.isNotEmpty((CharSequence)id) || StringUtils.isNotEmpty((CharSequence)productCode)) && (one = (MdmProductEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((CharSequence)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((CharSequence)productCode), MdmProductEntity::getProductCode, (Object)productCode)).one())) != null) {
            MdmProductRespVo respVo = (MdmProductRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmProductRespVo.class);
            MdmProductLevelEntity productLevel = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)this.mdmProductLevelService.lambdaQuery().eq(MdmProductLevelEntity::getProductLevelCode, (Object)one.getProductLevelCode())).one());
            if (productLevel != null) {
                respVo.setProductLevelName(productLevel.getProductLevelName());
            }
            List<MdmProductMaterialRespVo> materialRespVos = this.productServiceHelper.findMaterialByProductCode(one.getProductCode());
            respVo.setMaterialList(materialRespVos);
            List<MdmProductMediaRespVo> medias = this.mdmProductMediaService.list(new MdmProductMediaReqVo().setProductCode(one.getProductCode()));
            if (CollectionUtils.isNotEmpty(medias)) {
                Map<String, List<MdmProductMediaRespVo>> mediaMap = medias.stream().collect(Collectors.groupingBy(MdmProductMediaRespVo::getType));
                List<MdmProductMediaRespVo> pictureList = mediaMap.get(FileTypeEnum.PICTURE.getCode());
                respVo.setPictureList(pictureList);
                respVo.setVideoList(mediaMap.get(FileTypeEnum.VIDEO.getCode()));
            }
            MdmProductIntroductionRespVo introduction = this.productServiceHelper.findIntroductionByProductCode(one.getProductCode());
            respVo.setIntroductionVo(introduction);
            return respVo;
        }
        return null;
    }

    @Override
    public List<MdmProductAdviseRespVo> adviseQuery(List<String> productCodeList) {
        if (CollectionUtils.isEmpty(productCodeList)) {
            return Collections.emptyList();
        }
        ArrayList<MdmProductAdviseRespVo> list = new ArrayList<MdmProductAdviseRespVo>(productCodeList.size());
        for (String productCode : productCodeList) {
            MdmProductRespVo mdmProductRespVo = this.detail(null, productCode);
            if (mdmProductRespVo == null) continue;
            MdmProductAdviseRespVo mdmProductAdviseRespVo = (MdmProductAdviseRespVo)CrmBeanUtil.copy((Object)mdmProductRespVo, MdmProductAdviseRespVo.class);
            mdmProductAdviseRespVo.setMaterialList(JsonUtils.obj2JsonString((Object)mdmProductRespVo.getMaterialList()));
            mdmProductAdviseRespVo.setPictureList(JsonUtils.obj2JsonString((Object)mdmProductRespVo.getPictureList()));
            mdmProductAdviseRespVo.setVideoList(JsonUtils.obj2JsonString((Object)mdmProductRespVo.getVideoList()));
            mdmProductAdviseRespVo.setIntroductionVo(JsonUtils.obj2JsonString((Object)mdmProductRespVo.getIntroductionVo()));
            list.add(mdmProductAdviseRespVo);
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmProductReqVo mdmProductReqVo) {
        if (StringUtils.isEmpty((CharSequence)mdmProductReqVo.getProductCode())) {
            mdmProductReqVo.setProductCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_PRODUCT_CODE.getCode()));
        }
        MdmProductBuilder.builder(this.productServiceHelper, mdmProductReqVo).init().check().convert().save();
        this.sendChangeMsg(Collections.singletonList(mdmProductReqVo.getProductCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmProductReqVo mdmProductReqVo) {
        Assert.hasText((String)mdmProductReqVo.getId(), (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmProductEntity one = (MdmProductEntity)((Object)this.getById((Serializable)((Object)mdmProductReqVo.getId())));
        Assert.notNull((Object)((Object)one), (String)"\u672a\u627e\u5230\u5546\u54c1");
        Assert.isTrue((boolean)IsShelfEnum.DOWN.getCode().equals(one.getIsShelf()), (String)"\u53ea\u80fd\u7f16\u8f91\u72b6\u6001\u4e3a\u201c\u4e0b\u67b6\u201d\u7684\u5546\u54c1");
        MdmProductBuilder.builder(this.productServiceHelper, mdmProductReqVo).init().check().convert().update();
        this.sendChangeMsg(Collections.singletonList(mdmProductReqVo.getProductCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u4f20\u5165\u53c2\u6570");
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmProductEntity product = (MdmProductEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)product), (String)"\u65e0\u6548\u7684id");
            ((LambdaUpdateChainWrapper)this.mdmProductMediaService.lambdaUpdate().eq(MdmProductMediaEntity::getProductCode, (Object)product.getProductCode())).remove();
            ((LambdaUpdateChainWrapper)this.mdmProductMaterialService.lambdaUpdate().eq(MdmProductMaterialEntity::getProductCode, (Object)product.getProductCode())).remove();
            ((LambdaUpdateChainWrapper)this.mdmProductIntroductionService.lambdaUpdate().eq(MdmProductIntroductionEntity::getProductCode, (Object)product.getProductCode())).remove();
        });
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).select(new SFunction[]{MdmProductEntity::getProductCode}).list();
        this.removeByIds(ids);
        this.sendDelMsg(list.stream().map(MdmProductEntity::getProductCode).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> productCodeList = new ArrayList<String>();
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmProductEntity one = (MdmProductEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)one), (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
            Assert.isTrue((!CrmEnableStatusEnum.ENABLE.getCode().equals(one.getEnableStatus()) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u542f\u7528\u72b6\u6001\u4e3a\u201c\u7981\u7528\u201d\u7684\u5546\u54c1");
            one.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            this.updateById((Object)one);
            productCodeList.add(one.getProductCode());
        });
        this.sendChangeMsg(productCodeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> productCodeList = new ArrayList<String>();
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmProductEntity one = (MdmProductEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)one), (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
            Assert.isTrue((boolean)IsShelfEnum.DOWN.getCode().equals(one.getIsShelf()), (String)"\u53ea\u80fd\u7981\u7528\u72b6\u6001\u4e3a\u201c\u4e0b\u67b6\u201d\u7684\u5546\u54c1");
            Assert.isTrue((!CrmEnableStatusEnum.DISABLE.getCode().equals(one.getEnableStatus()) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u7981\u7528\u72b6\u6001\u4e3a\u201c\u542f\u7528\u201d\u7684\u5546\u54c1");
            one.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            one.setIsShelf(IsShelfEnum.DOWN.getCode());
            this.updateById((Object)one);
            productCodeList.add(one.getProductCode());
        });
        this.sendChangeMsg(productCodeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void upShelf(List<String> ids) {
        Assert.notEmpty(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> productCodeList = new ArrayList<String>();
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmProductEntity one = (MdmProductEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)one), (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
            Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(one.getEnableStatus()), (String)"\u53ea\u80fd\u4e0a\u67b6\u72b6\u6001\u4e3a\u201c\u542f\u7528\u201d\u7684\u5546\u54c1");
            Assert.isTrue((boolean)IsShelfEnum.DOWN.getCode().equals(one.getIsShelf()), (String)"\u53ea\u80fd\u4e0a\u67b6\u72b6\u6001\u4e3a\u201c\u4e0b\u67b6\u201d\u7684\u5546\u54c1");
            one.setIsShelf(IsShelfEnum.UP.getCode());
            this.updateById((Object)one);
            productCodeList.add(one.getProductCode());
        });
        this.sendChangeMsg(productCodeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void downShelf(List<String> ids) {
        Assert.notEmpty(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> productCodeList = new ArrayList<String>();
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmProductEntity one = (MdmProductEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)one), (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
            Assert.isTrue((boolean)IsShelfEnum.UP.getCode().equals(one.getIsShelf()), (String)"\u53ea\u80fd\u4e0b\u67b6\u72b6\u6001\u4e3a\u201c\u4e0a\u67b6\u201d\u7684\u5546\u54c1");
            one.setIsShelf(IsShelfEnum.DOWN.getCode());
            this.updateById((Object)one);
            productCodeList.add(one.getProductCode());
        });
        this.sendChangeMsg(productCodeList);
    }

    @Override
    public void sendChangeMsg(List<String> productCodeList) {
        if (CollectionUtils.isEmpty(productCodeList)) {
            return;
        }
        log.info("\u5546\u54c1\u4fee\u6539\u901a\u77e5:{}", productCodeList);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTopic(this.topic);
        rocketMQMessageBody.setTag("AVAILBLELIST_UPDATEPRODUCT");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(productCodeList));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }

    @Override
    public void sendDelMsg(List<String> productCodeList) {
        log.info("\u5546\u54c1\u5220\u9664\u901a\u77e5:{}", productCodeList);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTopic(this.topic);
        rocketMQMessageBody.setTag("AVAILBLELIST_DELPRODUCT");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(productCodeList));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }

    @Override
    public Map<String, List<MdmProductSaleCompanyRespVo>> findSaleCompanyByProductCodeList(List<String> productCodeList) {
        log.info("\u5546\u54c1\u7ba1\u7406\uff1a\u6839\u636e\u5546\u54c1\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7269\u6599\u9500\u552e\u516c\u53f8,\u5165\u53c2:{}", productCodeList);
        if (CollectionUtils.isEmpty(productCodeList)) {
            return Collections.emptyMap();
        }
        List<MdmProductSaleCompanyRespVo> companyList = this.mdmProductMapper.findSaleCompanyByProductCodeList(productCodeList);
        log.info("\u5546\u54c1\u7ba1\u7406\uff1a\u6839\u636e\u5546\u54c1\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7269\u6599\u9500\u552e\u516c\u53f8,\u7ed3\u679c:{}", companyList);
        if (CollectionUtils.isEmpty(companyList)) {
            return productCodeList.stream().distinct().collect(Collectors.toMap(Function.identity(), x -> Collections.emptyList()));
        }
        Map map = DictUtil.getDictValueMapsByCodes((String)"sale_company");
        log.info("\u5546\u54c1\u7ba1\u7406\uff1a\u6839\u636e\u5546\u54c1\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7269\u6599\u9500\u552e\u516c\u53f8,\u5b57\u5178:{}", (Object)map);
        return companyList.stream().peek(x -> {
            String saleCompanyCode = x.getSaleCompanyCode();
            if (!StringUtils.isEmpty((CharSequence)saleCompanyCode) && map != null) {
                x.setSaleCompanyName((String)map.get(saleCompanyCode));
            }
        }).collect(Collectors.groupingBy(MdmProductSaleCompanyRespVo::getProductCode));
    }
}

