/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyDetailVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.terminal.mapper.MdmTerminalSupplyMapper;
import com.biz.crm.terminal.model.MdmTerminalSupplyDetailEntity;
import com.biz.crm.terminal.model.MdmTerminalSupplyEntity;
import com.biz.crm.terminal.service.MdmTerminalSupplyDetailService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.util.CrmBeanUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmTerminalSupplyServiceExpandImpl"})
public class MdmTerminalSupplyServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmTerminalSupplyMapper, MdmTerminalSupplyEntity>
implements MdmTerminalSupplyService {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalSupplyServiceImpl.class);
    @Autowired
    private MdmTerminalSupplyDetailService mdmTerminalSupplyDetailService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByCodes(List<String> terminalCodes) {
        if (CollectionUtils.isEmpty(terminalCodes)) {
            return;
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalSupplyEntity::getTerminalCode, terminalCodes)).select(new SFunction[]{BaseIdEntity::getId}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        List supplyIds = list.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)this.mdmTerminalSupplyDetailService.lambdaUpdate().in(MdmTerminalSupplyDetailEntity::getSupplyId, supplyIds)).remove();
        this.removeByIds(supplyIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setUpSupply(MdmTerminalVo mdmTerminalVo) {
        String terminalCode = mdmTerminalVo.getTerminalCode();
        Assert.hasText((String)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalSupplyEntity::getTerminalCode, (Object)terminalCode)).select(new SFunction[]{BaseIdEntity::getId}).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List supplyIds = list.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
            ((LambdaUpdateChainWrapper)this.mdmTerminalSupplyDetailService.lambdaUpdate().in(MdmTerminalSupplyDetailEntity::getSupplyId, supplyIds)).remove();
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmTerminalSupplyEntity::getTerminalCode, (Object)terminalCode)).remove();
        List supplys = mdmTerminalVo.getSupplys();
        if (!CollectionUtils.isEmpty((Collection)supplys)) {
            for (MdmTerminalSupplyVo supply : supplys) {
                String positionCode = supply.getPositionCode();
                Assert.hasText((String)positionCode, (String)("[\u7ec8\u7aef:{" + terminalCode + "}]\u4f9b\u8d27\u5173\u7cfb\uff0c\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a"));
                supply.setId(UUID.randomUUID().toString());
                supply.setTerminalCode(terminalCode);
                List details = supply.getDetails();
                if (!CollectionUtils.isEmpty((Collection)details)) {
                    for (MdmTerminalSupplyDetailVo detail : details) {
                        Assert.hasText((String)detail.getCode(), (String)("[\u7ec8\u7aef:{" + terminalCode + "}]\u4f9b\u8d27\u5173\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                        Assert.hasText((String)detail.getName(), (String)("[\u7ec8\u7aef:{" + terminalCode + "}]\u4f9b\u8d27\u5173\u7cfb\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
                        Assert.hasText((String)detail.getDataType(), (String)("[\u7ec8\u7aef:{" + terminalCode + "}]\u4f9b\u8d27\u5173\u7cfb\u4ea7\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
                        detail.setId(UUID.randomUUID().toString());
                        detail.setSupplyId(supply.getId());
                    }
                    this.mdmTerminalSupplyDetailService.saveBatch(CrmBeanUtil.copyList((List)details, MdmTerminalSupplyDetailEntity.class));
                }
                this.save(CrmBeanUtil.copy((Object)supply, MdmTerminalSupplyEntity.class));
            }
        }
    }

    @Override
    public List<MdmTerminalSupplyVo> findByTerminalCode(String terminalCode) {
        Assert.hasText((String)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalSupplyEntity::getTerminalCode, (Object)terminalCode)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        List supplyIds = list.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
        List mdmTerminalSupplyVos = CrmBeanUtil.copyList((List)list, MdmTerminalSupplyVo.class);
        List supplyDetailEntities = ((LambdaQueryChainWrapper)this.mdmTerminalSupplyDetailService.lambdaQuery().in(MdmTerminalSupplyDetailEntity::getSupplyId, supplyIds)).list();
        if (!CollectionUtils.isEmpty((Collection)supplyDetailEntities)) {
            Map<String, List<MdmTerminalSupplyDetailEntity>> detailsMap = supplyDetailEntities.stream().collect(Collectors.groupingBy(MdmTerminalSupplyDetailEntity::getSupplyId));
            for (MdmTerminalSupplyVo mdmTerminalSupplyVo : mdmTerminalSupplyVos) {
                List detailVos = CrmBeanUtil.copyList(detailsMap.get(mdmTerminalSupplyVo.getId()), MdmTerminalSupplyDetailVo.class);
                mdmTerminalSupplyVo.setDetails(detailVos);
            }
        }
        return mdmTerminalSupplyVos;
    }
}

