/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.bpmrole.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.bpmrole.mapper.MdmBpmRoleMapper;
import com.biz.crm.bpmrole.model.MdmBpmRoleEntity;
import com.biz.crm.bpmrole.service.MdmBpmRoleService;
import com.biz.crm.bpmrole.service.MdmPositionBpmRoleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleReqVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRespVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmBpmRoleServiceExpandImpl"})
public class MdmBpmRoleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmBpmRoleMapper, MdmBpmRoleEntity>
implements MdmBpmRoleService {
    private static final Logger log = LoggerFactory.getLogger(MdmBpmRoleServiceImpl.class);
    @Resource
    private MdmBpmRoleMapper mdmBpmRoleMapper;
    @Resource
    private MdmPositionBpmRoleService mdmPositionBpmRoleService;

    @Override
    public PageResult<MdmBpmRoleRespVo> findList(MdmBpmRoleReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmBpmRoleRespVo> list = this.mdmBpmRoleMapper.findList((Page<MdmBpmRoleRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmBpmRoleRespVo detail(String id, String bpmRoleCode) {
        MdmBpmRoleEntity one;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)bpmRoleCode)) && (one = (MdmBpmRoleEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)bpmRoleCode), MdmBpmRoleEntity::getBpmRoleCode, (Object)bpmRoleCode)).one())) != null) {
            return (MdmBpmRoleRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmBpmRoleRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmBpmRoleReqVo reqVo) {
        reqVo.setId(null);
        MdmBpmRoleEntity entity = (MdmBpmRoleEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmBpmRoleEntity.class));
        if (StringUtils.isEmpty((String)entity.getBpmRoleCode())) {
            entity.setBpmRoleCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_BPM_ROLE_CODE.getCode()));
        }
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmBpmRoleReqVo reqVo) {
        MdmBpmRoleEntity entity = (MdmBpmRoleEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmBpmRoleEntity entity = (MdmBpmRoleEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)entity), (String)"\u65e0\u6548\u7684id");
            this.mdmPositionBpmRoleService.removeByBpmRole(entity.getBpmRoleCode());
            this.removeById((Serializable)((Object)id));
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        for (String id : ids) {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmBpmRoleEntity entity = (MdmBpmRoleEntity)((Object)this.getById((Serializable)((Object)id)));
            Assert.notNull((Object)((Object)entity), (String)"id\u65e0\u6548");
            Assert.isTrue((boolean)CrmEnableStatusEnum.DISABLE.getCode().equals(entity.getEnableStatus()), (String)("\u53ea\u80fd\u542f\u7528\u72b6\u6001\u4e3a\u201c" + CrmEnableStatusEnum.DISABLE.getDes() + "\u201d\u7684\u6570\u636e"));
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)id)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        for (String id : ids) {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmBpmRoleEntity entity = (MdmBpmRoleEntity)((Object)this.getById((Serializable)((Object)id)));
            Assert.notNull((Object)((Object)entity), (String)"id\u65e0\u6548");
            Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(entity.getEnableStatus()), (String)("\u53ea\u80fd\u7981\u7528\u72b6\u6001\u4e3a\u201c" + CrmEnableStatusEnum.ENABLE.getDes() + "\u201d\u7684\u6570\u636e"));
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)id)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
        }
    }

    @Override
    public List<MdmBpmRoleRespVo> selectList(MdmBpmRoleReqVo reqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus())).like(StringUtils.isNotEmpty((String)reqVo.getBpmRoleCode()), MdmBpmRoleEntity::getBpmRoleCode, (Object)reqVo.getBpmRoleCode())).like(StringUtils.isNotEmpty((String)reqVo.getBpmRoleName()), MdmBpmRoleEntity::getBpmRoleName, (Object)reqVo.getBpmRoleName())).select(new SFunction[]{MdmBpmRoleEntity::getBpmRoleCode, MdmBpmRoleEntity::getBpmRoleName}).list();
        return CrmBeanUtil.copyList((List)list, MdmBpmRoleRespVo.class);
    }
}

