/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.dict.model.MdmDictAttrConfEntity;
import com.biz.crm.dict.model.MdmDictDataEntity;
import com.biz.crm.dict.service.MdmDictAttrConfService;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.dict.service.MdmDictService;
import com.biz.crm.nebular.mdm.dict.resp.DictAttrConfVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.mdm.dict.resp.DictGroupVo;
import com.biz.crm.util.CrmBeanUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MdmDictServiceImpl
implements MdmDictService {
    private static final Logger log = LoggerFactory.getLogger(MdmDictServiceImpl.class);
    @Resource
    private MdmDictDataService mdmDictDataService;
    @Resource
    private MdmDictAttrConfService mdmDictAttrConfService;

    @Override
    public List<DictGroupVo> getDictGroupList(List<String> dictTypeCodeList) {
        ArrayList<DictGroupVo> list = new ArrayList<DictGroupVo>();
        dictTypeCodeList.forEach(dictTypeCode -> {
            DictGroupVo group = this.getDictGroup((String)dictTypeCode);
            if (group != null) {
                list.add(group);
            }
        });
        return list;
    }

    private DictGroupVo getDictGroup(String dictTypeCode) {
        DictGroupVo respVo = null;
        List list = ((LambdaQueryChainWrapper)this.mdmDictDataService.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)dictTypeCode)).list();
        if (list != null && list.size() > 0) {
            respVo = new DictGroupVo();
            respVo.setDictTypeCode(dictTypeCode);
            respVo.setDataList(CrmBeanUtil.copyList((List)list, DictDataVo.class));
            List confEntityList = ((LambdaQueryChainWrapper)this.mdmDictAttrConfService.lambdaQuery().eq(MdmDictAttrConfEntity::getDictTypeCode, (Object)dictTypeCode)).list();
            if (confEntityList != null && confEntityList.size() > 0) {
                respVo.setConfList(CrmBeanUtil.copyList((List)confEntityList, DictAttrConfVo.class));
            }
        }
        return respVo;
    }
}

