/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.service.impl;

import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.login.service.MdmDmsMallLoginService;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmDmsMallLoginServiceExpandImpl"})
public class MdmDmsMallLoginServiceImpl
implements MdmDmsMallLoginService {
    private static final Logger log = LoggerFactory.getLogger(MdmDmsMallLoginServiceImpl.class);
    @Autowired
    private MdmUserService mdmUserService;
    @Autowired
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Autowired
    private PasswordEncoder passwordEncoder;

    protected void storeRedis(MdmUserRespVo mdmUserRespVo, MdmCustomerMsgRespVo mdmCustomerMsgRespVo, String token) {
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(mdmUserRespVo.getUserName());
        userRedis.setRealname(mdmUserRespVo.getFullName());
        userRedis.setCustname(mdmCustomerMsgRespVo.getCustomerName());
        userRedis.setCustcode(mdmCustomerMsgRespVo.getCustomerCode());
        userRedis.setOrgcode(mdmCustomerMsgRespVo.getOrgCode());
        UserUtils.setUser((String)token, (UserRedis)userRedis);
    }

    protected MdmUserRespVo validUser(MdmLoginReqVo mdmLoginReqVo) {
        String userName = mdmLoginReqVo.getUserName();
        String password = mdmLoginReqVo.getPassword();
        Assert.hasText((String)userName, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)password, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmUserReqVo mdmUserReqVo = new MdmUserReqVo();
        mdmUserReqVo.setUserName(userName);
        MdmUserRespVo mdmUserRespVo = this.mdmUserService.queryBasic(mdmUserReqVo);
        Assert.notNull((Object)mdmUserRespVo, (String)"\u5ba2\u6237\u7528\u6237\u4e0d\u5b58\u5728");
        String userType = mdmUserRespVo.getUserType();
        Assert.hasText((String)userType, (String)"\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((UserTypeEnum.CUSTOMER_ONE.getCode().equals(userType) || UserTypeEnum.CUSTOMER_MANY.getCode().equals(userType) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7528\u6237\u4e0d\u5b58\u5728");
        log.info("[\u7cfb\u7edf\u767b\u5f55]\u7528\u6237\u4fe1\u606f:{}", (Object)mdmUserRespVo);
        String encryPwd = Md5EncryptionAndDecryption.encryPwd((String)password);
        Assert.isTrue((!StringUtils.isEmpty((Object)encryPwd) && encryPwd.equals(mdmUserRespVo.getUserPassword()) ? 1 : 0) != 0, (String)"\u5bc6\u7801\u4e0d\u6b63\u786e");
        return mdmUserRespVo;
    }

    @Override
    public MdmLoginRespVo dmsMallLogin(MdmLoginReqVo mdmLoginReqVo) {
        MdmUserRespVo mdmUserRespVo = this.validUser(mdmLoginReqVo);
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = this.validCustomer(mdmUserRespVo);
        String token = UUID.randomUUID().toString();
        this.storeRedis(mdmUserRespVo, mdmCustomerMsgRespVo, token);
        MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
        mdmLoginRespVo.setLoginUserToken(token);
        mdmLoginRespVo.setUserName(mdmUserRespVo.getUserName());
        mdmLoginRespVo.setFullName(mdmUserRespVo.getFullName());
        mdmLoginRespVo.setOrgCode(mdmCustomerMsgRespVo.getOrgCode());
        mdmLoginRespVo.setCustomerCode(mdmCustomerMsgRespVo.getCustomerCode());
        mdmLoginRespVo.setCustomerName(mdmCustomerMsgRespVo.getCustomerName());
        mdmLoginRespVo.setMdmCustomerMsgRespVo(this.mdmCustomerMsgService.query(null, mdmCustomerMsgRespVo.getCustomerCode()));
        return mdmLoginRespVo;
    }

    @Override
    public void dmsMallLogout() {
        UserUtils.remove();
    }

    protected MdmCustomerMsgRespVo validCustomer(MdmUserRespVo mdmUserRespVo) {
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
        mdmCustomerMsgReqVo.setUserName(mdmUserRespVo.getUserName());
        List<MdmCustomerMsgRespVo> mdmCustomerMsgRespVos = this.mdmCustomerMsgService.queryBasic(mdmCustomerMsgReqVo);
        Assert.notEmpty(mdmCustomerMsgRespVos, (String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5173\u8054\u4e3b\u5ba2\u6237");
        log.info("[dms\u5546\u57ce\u767b\u5f55]\u5ba2\u6237\u4fe1\u606f\uff1a{}", mdmCustomerMsgRespVos);
        List collect = mdmCustomerMsgRespVos.stream().filter(x -> !StringUtils.isEmpty((Object)x.getUserName()) && YesNoEnum.yesNoEnum.ONE.getValue().equals(x.getCustomerPrimary())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect) || collect.size() != 1) {
            for (MdmCustomerMsgRespVo mdmCustomerMsgRespVo : mdmCustomerMsgRespVos) {
                mdmCustomerMsgRespVo.setCustomerPrimary(YesNoEnum.yesNoEnum.ZERO.getValue());
            }
            MdmCustomerMsgRespVo mdmCustomerMsgRespVo = mdmCustomerMsgRespVos.get(0);
            mdmCustomerMsgRespVo.setCustomerPrimary(YesNoEnum.yesNoEnum.ONE.getValue());
            this.mdmCustomerMsgService.updateBatchById(CrmBeanUtil.copyList(mdmCustomerMsgRespVos, MdmCustomerEntity.class));
            return mdmCustomerMsgRespVo;
        }
        return (MdmCustomerMsgRespVo)collect.get(0);
    }
}

