/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.material.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.material.mapper.MdmMaterialMapper;
import com.biz.crm.material.model.MdmMaterialEntity;
import com.biz.crm.material.service.MdmMaterialService;
import com.biz.crm.nebular.mdm.humanarea.MdmMaterialOrgSearchReqVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialPriceRespVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialReqVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialRespVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialUnitRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.product.model.MdmProductEntity;
import com.biz.crm.product.model.MdmProductMaterialEntity;
import com.biz.crm.product.service.MdmProductMaterialService;
import com.biz.crm.product.service.MdmProductService;
import com.biz.crm.productlevel.service.MdmProductLevelService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import joptsimple.internal.Strings;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmMaterialServiceExpandImpl"})
public class MdmMaterialServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmMaterialMapper, MdmMaterialEntity>
implements MdmMaterialService {
    private static final Logger log = LoggerFactory.getLogger(MdmMaterialServiceImpl.class);
    @Resource
    private MdmMaterialMapper mdmMaterialMapper;
    @Resource
    private MdmProductLevelService mdmProductLevelService;
    @Resource
    private MdmProductMaterialService mdmProductMaterialService;
    @Resource
    private MdmProductService mdmProductService;
    private final String UNIT_CONVERSION_REGEX = "^[+]?([1-9][0-9]*(?:[.][0-9]*)?|0*\\.0*[1-9][0-9]*)(?:[eE][+-][0-9]+)?$";
    private final String COST_PRICE_REGEX = "(^[1-9](\\d+)?(\\.\\d{1,2})?$)|(^\\d\\.\\d{1,2}$)";

    @Override
    public PageResult<MdmMaterialRespVo> findList(MdmMaterialReqVo mdmMaterialReqVo) {
        List<MdmMaterialRespVo> list;
        Page page = PageUtil.buildPage((Integer)mdmMaterialReqVo.getPageNum(), (Integer)mdmMaterialReqVo.getPageSize());
        if (StringUtils.isNotEmpty((String)mdmMaterialReqVo.getCode())) {
            MdmProductLevelRespVo productLevel = this.mdmProductLevelService.detail(null, mdmMaterialReqVo.getCode());
            mdmMaterialReqVo.setRuleCode(productLevel.getRuleCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list = this.mdmMaterialMapper.findList((Page<MdmMaterialRespVo>)page, mdmMaterialReqVo))) {
            Map map = DictUtil.dictMap((String)"sale_company");
            list.forEach(item -> {
                String saleCompanyName = "";
                String saleCompany = item.getSaleCompany();
                if (StringUtils.isNotEmpty((String)saleCompany)) {
                    ArrayList saleCompanyNameList = new ArrayList();
                    for (String saleCompanyCode : saleCompany.split(",")) {
                        if (!map.containsKey(saleCompanyCode)) continue;
                        saleCompanyNameList.add(map.get(saleCompanyCode));
                    }
                    if (CollectionUtil.listNotEmptyNotSizeZero(saleCompanyNameList)) {
                        saleCompanyName = String.join((CharSequence)",", saleCompanyNameList);
                    }
                }
                item.setSaleCompanyName(saleCompanyName);
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmMaterialRespVo detail(String id, String materialCode) {
        MdmMaterialEntity one;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)materialCode)) && (one = (MdmMaterialEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)materialCode), MdmMaterialEntity::getMaterialCode, (Object)materialCode)).one())) != null) {
            MdmProductLevelRespVo productLevel;
            MdmMaterialRespVo respVo = (MdmMaterialRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmMaterialRespVo.class);
            if (StringUtils.isNotEmpty((String)one.getSaleCompany())) {
                respVo.setSaleCompanyList(Arrays.asList(one.getSaleCompany().split(",")));
            }
            if ((productLevel = this.mdmProductLevelService.detail(null, one.getProductLevelCode())) != null) {
                respVo.setProductLevelName(productLevel.getProductLevelName());
            }
            return respVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmMaterialReqVo mdmMaterialReqVo) {
        Assert.hasText((String)mdmMaterialReqVo.getMaterialName(), (String)"\u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((String)mdmMaterialReqVo.getCostPrice())) {
            Assert.isTrue((boolean)mdmMaterialReqVo.getCostPrice().matches("(^[1-9](\\d+)?(\\.\\d{1,2})?$)|(^\\d\\.\\d{1,2}$)"), (String)"\u6210\u672c\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a\u8bf7\u8f93\u5165\u6b63\u6570\uff0c\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570");
        }
        if (StringUtils.isEmpty((String)mdmMaterialReqVo.getMaterialCode())) {
            mdmMaterialReqVo.setMaterialCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_MATERIAL_CODE.getCode()));
        } else {
            MdmMaterialRespVo query = this.detail(null, mdmMaterialReqVo.getMaterialCode());
            Assert.isNull((Object)query, (String)("\u7269\u6599\u7f16\u7801\u5df2\u5b58\u5728:" + mdmMaterialReqVo.getMaterialCode()));
        }
        String unitConversion = mdmMaterialReqVo.getUnitConversion();
        Assert.isTrue((!StringUtils.isEmpty((String)unitConversion) && unitConversion.matches("^[+]?([1-9][0-9]*(?:[.][0-9]*)?|0*\\.0*[1-9][0-9]*)(?:[eE][+-][0-9]+)?$") ? 1 : 0) != 0, (String)"\u5355\u4f4d\u6362\u7b97\u7cfb\u6570\u5fc5\u987b\u662f\u6b63\u6570");
        if (CollectionUtil.listNotEmptyNotSizeZero((List)mdmMaterialReqVo.getSaleCompanyList())) {
            mdmMaterialReqVo.setSaleCompany(Strings.join((Iterable)mdmMaterialReqVo.getSaleCompanyList(), (String)","));
        }
        this.save(CrmBeanUtil.copy((Object)mdmMaterialReqVo, MdmMaterialEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmMaterialReqVo mdmMaterialReqVo) {
        String unitConversion;
        Assert.hasText((String)mdmMaterialReqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmMaterialReqVo.getMaterialName(), (String)"\u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((String)mdmMaterialReqVo.getCostPrice())) {
            Assert.isTrue((boolean)mdmMaterialReqVo.getCostPrice().matches("(^[1-9](\\d+)?(\\.\\d{1,2})?$)|(^\\d\\.\\d{1,2}$)"), (String)"\u6210\u672c\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a\u8bf7\u8f93\u5165\u6b63\u6570\uff0c\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570");
        }
        Assert.isTrue((!StringUtils.isEmpty((String)(unitConversion = mdmMaterialReqVo.getUnitConversion())) && unitConversion.matches("^[+]?([1-9][0-9]*(?:[.][0-9]*)?|0*\\.0*[1-9][0-9]*)(?:[eE][+-][0-9]+)?$") ? 1 : 0) != 0, (String)"\u5355\u4f4d\u6362\u7b97\u7cfb\u6570\u5fc5\u987b\u662f\u6b63\u6570");
        if (CollectionUtil.listNotEmptyNotSizeZero((List)mdmMaterialReqVo.getSaleCompanyList())) {
            mdmMaterialReqVo.setSaleCompany(Strings.join((Iterable)mdmMaterialReqVo.getSaleCompanyList(), (String)","));
        }
        this.updateById(CrmBeanUtil.copy((Object)mdmMaterialReqVo, MdmMaterialEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        ValidateUtils.validate(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> materialCodeList = new ArrayList<String>();
        for (String id : ids) {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmMaterialEntity material = (MdmMaterialEntity)((Object)this.getById((Serializable)((Object)id)));
            Assert.notNull((Object)((Object)material), (String)"\u7269\u6599\u4e0d\u5b58\u5728");
            materialCodeList.add(material.getMaterialCode());
        }
        this.removeByIds(ids);
        List productMaterialList = ((LambdaQueryChainWrapper)this.mdmProductMaterialService.lambdaQuery().in(MdmProductMaterialEntity::getMaterialCode, materialCodeList)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)productMaterialList)) {
            List productCodeList = productMaterialList.stream().map(MdmProductMaterialEntity::getProductCode).collect(Collectors.toList());
            List productEntityList = ((LambdaQueryChainWrapper)this.mdmProductService.lambdaQuery().in(MdmProductEntity::getProductCode, productCodeList)).select(new SFunction[]{BaseIdEntity::getId}).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)productEntityList)) {
                List<String> productIdList = productEntityList.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
                this.mdmProductService.deleteBatch(productIdList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        ValidateUtils.validate(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmMaterialEntity material = (MdmMaterialEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)material), (String)"\u7269\u6599\u4e0d\u5b58\u5728");
            Assert.isTrue((!CrmEnableStatusEnum.ENABLE.getCode().equals(material.getEnableStatus()) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u542f\u7528\u72b6\u6001\u4e3a\u201c\u7981\u7528\u201d\u7684\u7269\u6599");
            material.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            this.updateById((Object)material);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        ValidateUtils.validate(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmMaterialEntity material = (MdmMaterialEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)material), (String)"\u7269\u6599\u4e0d\u5b58\u5728");
            Assert.isTrue((!CrmEnableStatusEnum.DISABLE.getCode().equals(material.getEnableStatus()) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u7981\u7528\u72b6\u6001\u4e3a\u201c\u542f\u7528\u201d\u7684\u7269\u6599");
            material.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            this.updateById((Object)material);
        });
    }

    @Override
    public List<MdmMaterialPriceRespVo> findCurrentAndSubMaterialList(MdmMaterialOrgSearchReqVo mdmMaterialOrgSearchReqVo) {
        Map materialBaseUnit = DictUtil.dictMap((String)"material_base_unit");
        Map materialSaleUnit = DictUtil.dictMap((String)"material_sale_unit");
        Integer pageNum = Optional.ofNullable(mdmMaterialOrgSearchReqVo.getPageNum()).orElse(1);
        Integer pageSize = Optional.ofNullable(mdmMaterialOrgSearchReqVo.getPageSize()).orElse(1000);
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        List<MdmMaterialRespVo> mdmMaterialRespVos = this.mdmMaterialMapper.pageCondition((Page<MdmMaterialRespVo>)page, mdmMaterialOrgSearchReqVo);
        if (CollectionUtils.isEmpty(mdmMaterialRespVos)) {
            return Collections.emptyList();
        }
        return mdmMaterialRespVos.stream().map(x -> {
            MdmMaterialPriceRespVo mdmMaterialPriceRespVo = (MdmMaterialPriceRespVo)CrmBeanUtil.copy((Object)x, MdmMaterialPriceRespVo.class);
            MdmMaterialUnitRespVo baseUnitRespVo = new MdmMaterialUnitRespVo();
            String baseUnit = x.getBaseUnit();
            baseUnitRespVo.setUnit(baseUnit);
            baseUnitRespVo.setUnitName(StringUtils.isEmpty((String)baseUnit) ? baseUnit : (String)materialBaseUnit.get(baseUnit));
            String costPrice = x.getCostPrice();
            baseUnitRespVo.setCostPrice(costPrice);
            MdmMaterialUnitRespVo saleUnitRespVo = new MdmMaterialUnitRespVo();
            String saleUnit = x.getSaleUnit();
            saleUnitRespVo.setUnit(saleUnit);
            saleUnitRespVo.setUnitName(StringUtils.isEmpty((String)saleUnit) ? saleUnit : (String)materialSaleUnit.get(saleUnit));
            String unitConversion = x.getUnitConversion();
            if (!StringUtils.isEmpty((String)costPrice) && !StringUtils.isEmpty((String)unitConversion)) {
                saleUnitRespVo.setCostPrice(new BigDecimal(costPrice).multiply(new BigDecimal(unitConversion)).toString());
            }
            mdmMaterialPriceRespVo.setMdmMaterialUnitRespVos(Arrays.asList(baseUnitRespVo, saleUnitRespVo));
            return mdmMaterialPriceRespVo;
        }).collect(Collectors.toList());
    }
}

