/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.region.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.region.MdmRegionReqVo;
import com.biz.crm.nebular.mdm.region.MdmRegionRespVo;
import com.biz.crm.nebular.mdm.region.MdmRegionSelectRespVo;
import com.biz.crm.region.service.MdmRegionService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmRegionController"})
@Api(tags={"mdm-\u884c\u653f\u533a\u57df"})
@CrmGlobalLog
public class MdmRegionController {
    private static final Logger log = LoggerFactory.getLogger(MdmRegionController.class);
    @Autowired
    private MdmRegionService mdmRegionService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868\uff08\u884c\u653f\u533a\u57df\u7ba1\u7406\u5217\u8868\u4f7f\u7528\uff0c\u5176\u5b83\u5730\u65b9\u4e0d\u8981\u7528\u8fd9\u4e2a\u63a5\u53e3\uff09")
    @PostMapping(value={"/pageList"})
    @CrmDictMethod
    public Result<PageResult<MdmRegionRespVo>> pageList(@RequestBody MdmRegionReqVo mdmRegionReqVo) {
        return Result.ok(this.mdmRegionService.pageList(mdmRegionReqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmDictMethod
    public Result<List<MdmRegionRespVo>> list(@RequestBody MdmRegionReqVo mdmRegionReqVo) {
        return Result.ok(this.mdmRegionService.findList(mdmRegionReqVo));
    }

    @ApiOperation(value="\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="regionCode", value="\u533a\u57df\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/query"})
    @CrmDictMethod
    public Result<MdmRegionRespVo> query(@RequestParam(value="id", required=false) String id, @RequestParam(value="regionCode", required=false) String regionCode) {
        MdmRegionRespVo respVo = this.mdmRegionService.query(id, regionCode);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result<Object> save(@RequestBody MdmRegionReqVo mdmRegionReqVo) {
        this.mdmRegionService.save(mdmRegionReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result<Object> update(@RequestBody MdmRegionReqVo mdmRegionReqVo) {
        this.mdmRegionService.update(mdmRegionReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result<Object> delete(@RequestBody List<String> ids) {
        MdmRegionReqVo mdmRegionReqVo = new MdmRegionReqVo();
        mdmRegionReqVo.setIds(ids);
        this.mdmRegionService.deleteBatch(mdmRegionReqVo);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    public Result<Object> enable(@RequestBody List<String> ids) {
        MdmRegionReqVo mdmRegionReqVo = new MdmRegionReqVo();
        mdmRegionReqVo.setIds(ids);
        this.mdmRegionService.enableBatch(mdmRegionReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    public Result<Object> disable(@RequestBody List<String> ids) {
        MdmRegionReqVo mdmRegionReqVo = new MdmRegionReqVo();
        mdmRegionReqVo.setIds(ids);
        this.mdmRegionService.disableBatch(mdmRegionReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u533a\u57df\u4e0b\u62c9\u6846")
    @PostMapping(value={"/select"})
    public Result<List<MdmRegionSelectRespVo>> select(@RequestBody MdmRegionReqVo mdmRegionReqVo) {
        return Result.ok(this.mdmRegionService.select(mdmRegionReqVo));
    }
}

