/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.region.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.constant.RegionLevelEnum;
import com.biz.crm.nebular.mdm.region.MdmRegionReqVo;
import com.biz.crm.nebular.mdm.region.MdmRegionRespVo;
import com.biz.crm.nebular.mdm.region.MdmRegionSelectRespVo;
import com.biz.crm.region.mapper.MdmRegionMapper;
import com.biz.crm.region.model.MdmRegionEntity;
import com.biz.crm.region.service.MdmRegionService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.DatabaseTypeUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmRegionServiceExpandImpl"})
public class MdmRegionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmRegionMapper, MdmRegionEntity>
implements MdmRegionService {
    private static final Logger log = LoggerFactory.getLogger(MdmRegionServiceImpl.class);
    @Resource
    private MdmRegionMapper mdmRegionMapper;

    @Override
    public PageResult<MdmRegionRespVo> pageList(MdmRegionReqVo mdmRegionReqVo) {
        if (StringUtils.isNotEmpty((String)mdmRegionReqVo.getParentCode())) {
            List<MdmRegionRespVo> list = this.mdmRegionMapper.pageList(null, new MdmRegionReqVo().setParentCode(mdmRegionReqVo.getParentCode()));
            return PageResult.builder().data(list).count(Long.valueOf(list != null ? (long)list.size() : 0L)).build();
        }
        if (StringUtils.isEmpty((String)mdmRegionReqVo.getRegionCode()) && StringUtils.isEmpty((String)mdmRegionReqVo.getRegionName())) {
            List<MdmRegionRespVo> list = this.mdmRegionMapper.pageList(null, new MdmRegionReqVo().setRegionLevel(RegionLevelEnum.COUNTRY.getCode()));
            return PageResult.builder().data(list).count(Long.valueOf(list != null ? (long)list.size() : 0L)).build();
        }
        Page page = PageUtil.buildPage((Integer)mdmRegionReqVo.getPageNum(), (Integer)mdmRegionReqVo.getPageSize());
        List<MdmRegionRespVo> list = this.mdmRegionMapper.pageList((Page<MdmRegionRespVo>)page, mdmRegionReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmRegionRespVo> findList(MdmRegionReqVo reqVo) {
        return this.mdmRegionMapper.findList(reqVo);
    }

    @Override
    public MdmRegionRespVo query(String id, String regionCode) {
        return this.mdmRegionMapper.query(id, regionCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmRegionReqVo reqVo) {
        String regionCode = this.valid(reqVo);
        reqVo.setHasChild(Boolean.valueOf(false));
        MdmRegionEntity one = (MdmRegionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRegionEntity::getRegionCode, (Object)regionCode)).last(DatabaseTypeUtil.SEGMENT)).select(new SFunction[]{BaseIdEntity::getId}).one());
        Assert.isNull((Object)((Object)one), (String)"\u5f53\u524d\u533a\u57df\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        if (!StringUtils.isEmpty((String)reqVo.getParentCode())) {
            MdmRegionEntity parent = (MdmRegionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRegionEntity::getRegionCode, (Object)reqVo.getParentCode())).select(new SFunction[]{BaseIdEntity::getId, MdmRegionEntity::getHasChild}).one());
            Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u533a\u57df\u4e0d\u5b58\u5728");
            Boolean hasChild = parent.getHasChild();
            if (hasChild == null || !hasChild.booleanValue()) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)parent.getId())).set(MdmRegionEntity::getHasChild, (Object)true)).update();
            }
        }
        MdmRegionEntity entity = (MdmRegionEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmRegionEntity.class));
        this.save((Object)entity);
    }

    protected String valid(MdmRegionReqVo reqVo) {
        String regionCode = reqVo.getRegionCode();
        Assert.hasText((String)regionCode, (String)"\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)regionCode.matches("^[A-Za-z0-9]+$"), (String)"\u533a\u57df\u7f16\u7801\u8bf7\u8f93\u5165\u5b57\u6bcd\u548c\u6570\u5b57\u7ec4\u5408");
        String regionName = reqVo.getRegionName();
        Assert.hasText((String)regionName, (String)"\u533a\u57df\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getRegionLevel(), (String)"\u533a\u57df\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a");
        String latitude = reqVo.getLatitude();
        String longitude = reqVo.getLongitude();
        Assert.hasText((String)latitude, (String)"\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)latitude.matches("^[0-9]+(.[0-9]{2})?$"), (String)"\u7eac\u5ea6\u4ec5\u652f\u6301\u8f93\u5165\u6570\u5b57\uff0c\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570");
        Assert.hasText((String)longitude, (String)"\u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)longitude.matches("^[0-9]+(.[0-9]{2})?$"), (String)"\u7ecf\u5ea6\u4ec5\u652f\u6301\u8f93\u5165\u6570\u5b57\uff0c\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570");
        String email = reqVo.getEmail();
        if (!StringUtils.isEmpty((String)email)) {
            Assert.isTrue((boolean)email.matches("^\\d{6}$"), (String)"\u90ae\u7f16\u4ec5\u652f\u63016\u4f4d\u6570\u5b57");
        }
        return regionCode;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmRegionReqVo reqVo) {
        String id = reqVo.getId();
        Assert.hasText((String)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmRegionEntity entity = (MdmRegionEntity)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)entity), (String)"\u533a\u57df\u4e0d\u5b58\u5728");
        MdmRegionEntity one = (MdmRegionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ne(BaseIdEntity::getId, (Object)id)).eq(MdmRegionEntity::getRegionCode, (Object)reqVo.getRegionCode())).last(DatabaseTypeUtil.SEGMENT)).select(new SFunction[]{BaseIdEntity::getId}).one());
        Assert.isNull((Object)((Object)one), (String)"\u5f53\u524d\u533a\u57df\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        this.updateChildMark(reqVo, entity);
        this.updateSubRegionLevel(reqVo, entity);
        this.updateById(CrmBeanUtil.copy((Object)reqVo, MdmRegionEntity.class));
    }

    protected void updateSubRegionLevel(MdmRegionReqVo reqVo, MdmRegionEntity entity) {
        String regionLevel = reqVo.getRegionLevel();
        if (!regionLevel.equals(entity.getRegionLevel())) {
            int level = Integer.parseInt(regionLevel);
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRegionEntity::getParentCode, (Object)reqVo.getRegionCode())).select(new SFunction[]{BaseIdEntity::getId, MdmRegionEntity::getHasChild, CrmBaseEntity::getEnableStatus}).list();
            while (!CollectionUtils.isEmpty((Collection)list)) {
                ++level;
                for (MdmRegionEntity mdmRegionEntity : list) {
                    mdmRegionEntity.setRegionLevel(String.valueOf(level));
                }
                this.updateBatchById(list);
                list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmRegionEntity::getParentCode, (Collection)list.stream().map(MdmRegionEntity::getRegionCode).collect(Collectors.toList()))).select(new SFunction[]{BaseIdEntity::getId, MdmRegionEntity::getHasChild, CrmBaseEntity::getEnableStatus}).list();
            }
        }
    }

    protected void updateChildMark(MdmRegionReqVo reqVo, MdmRegionEntity entity) {
        String id = reqVo.getId();
        String parentCode = entity.getParentCode();
        if (StringUtils.isEmpty((String)parentCode)) {
            if (!StringUtils.isEmpty((String)reqVo.getParentCode())) {
                reqVo.setHasChild(Boolean.valueOf(true));
            }
        } else if (!StringUtils.isEmpty((String)reqVo.getParentCode()) && !reqVo.getParentCode().equals(parentCode)) {
            Integer newCount;
            Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRegionEntity::getParentCode, (Object)parentCode)).ne(BaseIdEntity::getId, (Object)id)).count();
            if (count == null || count == 0) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmRegionEntity::getRegionCode, (Object)parentCode)).set(MdmRegionEntity::getHasChild, (Object)false)).update();
            }
            if ((newCount = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRegionEntity::getParentCode, (Object)reqVo.getParentCode())).count()) != null && newCount > 0) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmRegionEntity::getRegionCode, (Object)reqVo.getParentCode())).set(MdmRegionEntity::getHasChild, (Object)true)).update();
            }
        } else {
            Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRegionEntity::getParentCode, (Object)parentCode)).ne(BaseIdEntity::getId, (Object)id)).count();
            if (count == null || count == 0) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmRegionEntity::getRegionCode, (Object)parentCode)).set(MdmRegionEntity::getHasChild, (Object)false)).update();
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmRegionReqVo reqVo) {
        log.info("[\u884c\u653f\u533a\u57df][\u5220\u9664]:{}", (Object)reqVo.getIds());
        List ids = reqVo.getIds();
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).remove();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmRegionReqVo reqVo) {
        List ids = reqVo.getIds();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmRegionReqVo reqVo) {
        List ids = reqVo.getIds();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public List<MdmRegionSelectRespVo> select(MdmRegionReqVo mdmRegionReqVo) {
        String currentRegionLevel = mdmRegionReqVo.getCurrentRegionLevel();
        if (!StringUtils.isEmpty((String)currentRegionLevel)) {
            Assert.isTrue((boolean)currentRegionLevel.matches("^[0-9]+$"), (String)"\u533a\u57df\u5c42\u7ea7\u5fc5\u987b\u662f\u6570\u5b57");
            mdmRegionReqVo.setRegionLevel(String.valueOf(Integer.parseInt(currentRegionLevel) - 1));
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)mdmRegionReqVo.getId()), BaseIdEntity::getId, (Object)mdmRegionReqVo.getId())).in(!CollectionUtils.isEmpty((Collection)mdmRegionReqVo.getIds()), BaseIdEntity::getId, new Object[]{mdmRegionReqVo.getId()})).in(!CollectionUtils.isEmpty((Collection)mdmRegionReqVo.getRegionCodeList()), MdmRegionEntity::getRegionCode, (Collection)mdmRegionReqVo.getRegionCodeList())).like(!StringUtils.isEmpty((String)mdmRegionReqVo.getRegionCode()), MdmRegionEntity::getRegionCode, (Object)mdmRegionReqVo.getRegionCode())).like(!StringUtils.isEmpty((String)mdmRegionReqVo.getRegionName()), MdmRegionEntity::getRegionName, (Object)mdmRegionReqVo.getRegionName())).eq(!StringUtils.isEmpty((String)mdmRegionReqVo.getRegionLevel()), MdmRegionEntity::getRegionLevel, (Object)mdmRegionReqVo.getRegionLevel())).eq(!StringUtils.isEmpty((String)mdmRegionReqVo.getParentCode()), MdmRegionEntity::getParentCode, (Object)mdmRegionReqVo.getParentCode())).eq(!StringUtils.isEmpty((String)mdmRegionReqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)mdmRegionReqVo.getEnableStatus())).list();
        return CrmBeanUtil.copyList((List)list, MdmRegionSelectRespVo.class);
    }
}

