/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelationTerminalPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelationTerminalReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelationTerminalPageRespVo;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.terminal.model.MdmTerminalSupplyEntity;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.user.mapper.MdmUserRelationTerminalMapper;
import com.biz.crm.user.service.MdmUserRelationTerminalService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class MdmUserRelationTerminalServiceImpl
implements MdmUserRelationTerminalService {
    @Resource
    private MdmUserRelationTerminalMapper mdmUserRelationTerminalMapper;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmTerminalSupplyService mdmTerminalSupplyService;

    @Override
    public PageResult<MdmUserRelationTerminalPageRespVo> findTerminalNotRelateAnyUser(MdmUserRelationTerminalPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmUserRelationTerminalPageRespVo> list = this.mdmUserRelationTerminalMapper.findTerminalNotRelateAnyUser((Page<MdmUserRelationTerminalPageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmUserRelationTerminalPageRespVo> findTerminalNotRelateCurUser(MdmUserRelationTerminalPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        List<MdmUserRelationTerminalPageRespVo> list = this.mdmUserRelationTerminalMapper.findTerminalNotRelateCurUser((Page<MdmUserRelationTerminalPageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmUserRelationTerminalPageRespVo> findTerminalHasRelateCurUser(MdmUserRelationTerminalPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmUserRelationTerminalPageRespVo> list = this.mdmUserRelationTerminalMapper.findTerminalHasRelateCurUser((Page<MdmUserRelationTerminalPageRespVo>)page, reqVo);
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bindRelation(MdmUserRelationTerminalReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getTerminalCodeList(), (String)"\u7f3a\u5931\u7ec8\u7aef\u7f16\u7801");
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        MdmPositionEntity position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).select(new SFunction[]{MdmPositionEntity::getPositionCode}).one());
        Assert.notNull((Object)((Object)position), (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7f16\u7801");
        this.mdmTerminalSupplyService.addTerminalPosition(reqVo.getTerminalCodeList(), reqVo.getPositionCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceTerminalPosition(MdmUserRelationTerminalReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u7f3a\u5931id");
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        MdmPositionEntity position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).select(new SFunction[]{MdmPositionEntity::getPositionCode}).one());
        Assert.notNull((Object)((Object)position), (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7f16\u7801");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmTerminalSupplyService.lambdaQuery().in(BaseIdEntity::getId, (Collection)reqVo.getIds())).eq(MdmTerminalSupplyEntity::getPositionCode, (Object)reqVo.getPositionCode())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            throw new BusinessException("\u7ec8\u7aef[" + ((MdmTerminalSupplyEntity)((Object)list.get(0))).getTerminalCode() + "]\u5df2\u7ecf\u5173\u8054\u4e86" + "\u804c\u4f4d[" + ((MdmTerminalSupplyEntity)((Object)list.get(0))).getPositionCode() + "]");
        }
        this.mdmTerminalSupplyService.replaceRelationPosition(reqVo.getIds(), reqVo.getPositionCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unbindRelation(MdmUserRelationTerminalReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u7f3a\u5931id");
        this.mdmTerminalSupplyService.unbindByIds(reqVo.getIds());
    }
}

