/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tableconfig.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.button.service.MdmButtonService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.button.MdmButtonReqVo;
import com.biz.crm.nebular.mdm.button.MdmButtonRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubRespVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmTableConfigReqVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmTableConfigRespVo;
import com.biz.crm.tableconfig.mapper.MdmTableConfigMapper;
import com.biz.crm.tableconfig.model.MdmTableConfigEntity;
import com.biz.crm.tableconfig.service.IMdmColumnConfigService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubService;
import com.biz.crm.tableconfig.service.IMdmTableConfigService;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmTableConfigServiceExpandImpl"})
public class MdmTableConfigServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmTableConfigMapper, MdmTableConfigEntity>
implements IMdmTableConfigService {
    private static final Logger log = LoggerFactory.getLogger(MdmTableConfigServiceImpl.class);
    @Resource
    private MdmTableConfigMapper mdmTableConfigMapper;
    @Autowired
    private IMdmColumnConfigService mdmColumnConfigService;
    @Autowired
    private MdmButtonService mdmButtonService;
    @Autowired
    private IMdmFunctionSubService mdmFunctionSubService;

    @Override
    public PageResult<MdmTableConfigRespVo> findList(MdmTableConfigReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmTableConfigRespVo> list = this.mdmTableConfigMapper.findList((Page<MdmTableConfigRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmTableConfigRespVo query(MdmTableConfigReqVo reqVo) {
        String functionCode = reqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmFunctionSubRespVo functionSubRespVo = this.mdmFunctionSubService.query(null, functionCode);
        Assert.notNull((Object)functionSubRespVo, (String)"\u5217\u8868\u914d\u7f6e\u4e0d\u5b58\u5728");
        String parentCode = functionSubRespVo.getParentCode();
        String apiUrl = functionSubRespVo.getApiUrl();
        Assert.hasText((String)parentCode, (String)"\u5217\u8868\u5bf9\u5e94\u83dc\u5355\u4e0d\u5b58\u5728");
        MdmButtonReqVo mdmButtonReqVo = new MdmButtonReqVo();
        mdmButtonReqVo.setFunctionCode(parentCode);
        List<MdmButtonRespVo> mdmButtonRespVos = this.mdmButtonService.listCondition(mdmButtonReqVo);
        MdmColumnConfigReqVo mdmColumnConfigReqVo = new MdmColumnConfigReqVo();
        mdmColumnConfigReqVo.setFunctionCode(functionCode);
        List<MdmColumnConfigRespVo> mdmColumnConfigRespVos = this.mdmColumnConfigService.listCondition(mdmColumnConfigReqVo);
        Assert.notEmpty(mdmColumnConfigRespVos, (String)"\u5b57\u6bb5\u914d\u7f6e\u4e0d\u5b58\u5728");
        MdmTableConfigRespVo mdmTableConfigRespVo = (MdmTableConfigRespVo)CrmBeanUtil.copy((Object)((Object)new MdmTableConfigEntity()), MdmTableConfigRespVo.class);
        mdmTableConfigRespVo.setColumn(mdmColumnConfigRespVos);
        mdmTableConfigRespVo.setButtonVos(mdmButtonRespVos);
        mdmTableConfigRespVo.setUrl(apiUrl);
        return mdmTableConfigRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmTableConfigReqVo reqVo) {
        MdmTableConfigEntity entity = (MdmTableConfigEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmTableConfigEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmTableConfigReqVo reqVo) {
        MdmTableConfigEntity entity = (MdmTableConfigEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmTableConfigReqVo reqVo) {
        List mdmTableConfigEntities = this.mdmTableConfigMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmTableConfigEntities)) {
            mdmTableConfigEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(mdmTableConfigEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmTableConfigReqVo reqVo) {
        List mdmTableConfigEntities = this.mdmTableConfigMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmTableConfigEntities)) {
            mdmTableConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmTableConfigEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmTableConfigReqVo reqVo) {
        List mdmTableConfigEntities = this.mdmTableConfigMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmTableConfigEntities)) {
            mdmTableConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmTableConfigEntities);
    }

    @Override
    public List<MdmColumnConfigRespVo> formQuery(MdmTableConfigReqVo mdmTableConfigReqVo) {
        String functionCode = mdmTableConfigReqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmColumnConfigReqVo mdmColumnConfigReqVo = new MdmColumnConfigReqVo();
        mdmColumnConfigReqVo.setFunctionCode(functionCode);
        List<Object> mdmColumnConfigRespVos = this.mdmColumnConfigService.listCondition(mdmColumnConfigReqVo);
        if (CollectionUtils.isEmpty(mdmColumnConfigRespVos)) {
            mdmColumnConfigRespVos = mdmColumnConfigRespVos.stream().peek(x -> {
                x.setFormvalue("");
                if (StringUtils.isEmpty((Object)x.getType())) {
                    x.setType("input");
                }
            }).collect(Collectors.toList());
        }
        return mdmColumnConfigRespVos;
    }
}

