/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.product.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ProductTypeEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.mdm.MdmProductException;
import com.biz.crm.material.mapper.MdmMaterialMapper;
import com.biz.crm.material.model.MdmMaterialEntity;
import com.biz.crm.nebular.mdm.product.req.MdmProductMaterialReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductMediaReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductIntroductionRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMaterialRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMediaRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.product.mapper.MdmProductIntroductionMapper;
import com.biz.crm.product.mapper.MdmProductMapper;
import com.biz.crm.product.mapper.MdmProductMaterialMapper;
import com.biz.crm.product.mapper.MdmProductMediaMapper;
import com.biz.crm.product.model.MdmProductEntity;
import com.biz.crm.product.model.MdmProductIntroductionEntity;
import com.biz.crm.product.model.MdmProductMaterialEntity;
import com.biz.crm.product.model.MdmProductMediaEntity;
import com.biz.crm.product.service.MdmProductMaterialService;
import com.biz.crm.product.service.MdmProductMediaService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MdmProductServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(MdmProductServiceHelper.class);
    @Resource
    private MdmProductMapper mdmProductMapper;
    @Resource
    private MdmProductMediaMapper mdmProductMediaMapper;
    @Resource
    private MdmProductIntroductionMapper mdmProductIntroductionMapper;
    @Resource
    private MdmProductMaterialMapper mdmProductMaterialMapper;
    @Autowired
    private MdmProductMaterialService mdmProductMaterialService;
    @Autowired
    private MdmProductMediaService mdmProductMediaService;
    @Resource
    private MdmMaterialMapper mdmMaterialMapper;

    public Map<String, Map<String, String>> getProductDict() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("product_sale_unit");
        dictCodes.add("product_base_unit");
        dictCodes.add("material_base_unit");
        dictCodes.add("material_sale_unit");
        Map map = DictUtil.getDictValueMapsByCodes((List)dictCodes);
        return map;
    }

    public void convertListDate(List<MdmProductRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getProductDict();
            list.forEach(o -> {
                if (!StringUtils.equals((CharSequence)ProductTypeEnum.STANDARD.getCode(), (CharSequence)o.getProductType())) {
                    if (StringUtils.isNotEmpty((CharSequence)o.getSaleUnit())) {
                        o.setSaleUnitName((String)((Map)Optional.ofNullable(map.get("product_sale_unit")).orElse(Maps.newHashMap())).get(o.getSaleUnit()));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)o.getBaseUnit())) {
                        o.setBaseUnitName((String)((Map)Optional.ofNullable(map.get("product_base_unit")).orElse(Maps.newHashMap())).get(o.getBaseUnit()));
                    }
                } else {
                    if (StringUtils.isNotEmpty((CharSequence)o.getSaleUnit())) {
                        o.setSaleUnitName((String)((Map)Optional.ofNullable(map.get("material_sale_unit")).orElse(Maps.newHashMap())).get(o.getSaleUnit()));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)o.getBaseUnit())) {
                        o.setBaseUnitName((String)((Map)Optional.ofNullable(map.get("material_base_unit")).orElse(Maps.newHashMap())).get(o.getBaseUnit()));
                    }
                }
            });
        }
    }

    public void saveProductEntity(MdmProductEntity mdmProductEntity) {
        if (Objects.isNull((Object)mdmProductEntity)) {
            throw new BusinessException((CrmExceptionType)MdmProductException.PRODUCT_NULL);
        }
        if (StringUtils.isNotEmpty((CharSequence)mdmProductEntity.getId())) {
            this.mdmProductMapper.updateById((Object)mdmProductEntity);
        } else {
            this.mdmProductMapper.insert((Object)mdmProductEntity);
        }
    }

    public void saveProductMaterials(List<MdmProductMaterialEntity> materialEntities, Boolean isSave, String productCode) {
        if (isSave.booleanValue()) {
            materialEntities.forEach(o -> this.mdmProductMaterialMapper.insert(o));
        } else {
            List ids = materialEntities.stream().filter(O -> StringUtils.isNotEmpty((CharSequence)O.getId())).map(BaseIdEntity::getId).collect(Collectors.toList());
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmProductMaterialService.lambdaUpdate().eq(MdmProductMaterialEntity::getProductCode, (Object)productCode)).notIn(CollectionUtils.isNotEmpty(ids), BaseIdEntity::getId, ids)).remove();
            this.mdmProductMaterialService.saveOrUpdateBatch(materialEntities);
        }
    }

    public void saveProductMedias(List<MdmProductMediaEntity> mediaEntities, Boolean isSave, String productCode) {
        if (isSave.booleanValue()) {
            if (CollectionUtils.isNotEmpty(mediaEntities)) {
                mediaEntities.forEach(o -> this.mdmProductMediaMapper.insert(o));
            }
        } else {
            List ids = mediaEntities.stream().filter(O -> StringUtils.isNotEmpty((CharSequence)O.getId())).map(BaseIdEntity::getId).collect(Collectors.toList());
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmProductMediaService.lambdaUpdate().eq(MdmProductMediaEntity::getProductCode, (Object)productCode)).notIn(CollectionUtils.isNotEmpty(ids), BaseIdEntity::getId, ids)).remove();
            if (CollectionUtil.listNotEmptyNotSizeZero(mediaEntities)) {
                this.mdmProductMediaService.saveOrUpdateBatch(mediaEntities);
            }
        }
    }

    public void saveProductIntroduction(MdmProductIntroductionEntity mdmProductIntroductionEntity, Boolean isSave, String productCode) {
        if (!isSave.booleanValue()) {
            this.mdmProductIntroductionMapper.delete((Wrapper)new LambdaQueryWrapper().eq(MdmProductIntroductionEntity::getProductCode, (Object)productCode));
        }
        if (mdmProductIntroductionEntity != null) {
            this.mdmProductIntroductionMapper.insert((Object)mdmProductIntroductionEntity);
        }
    }

    public List<MdmProductEntity> findProductsByParam(MdmProductReqVo reqVo) {
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getProductCode())) {
            wrapper.eq((Object)"product_code", (Object)reqVo.getProductCode());
        }
        return this.mdmProductMapper.selectList((Wrapper)wrapper);
    }

    public List<MdmProductMaterialRespVo> findMaterialByProductCode(String productCode) {
        MdmProductMaterialReqVo materialReqVo = new MdmProductMaterialReqVo();
        materialReqVo.setProductCode(productCode);
        return this.mdmProductMaterialService.findList(materialReqVo).getData();
    }

    public List<MdmProductMediaRespVo> findMediaByProductCode(String productCode) {
        MdmProductMediaReqVo mediaReqVo = new MdmProductMediaReqVo();
        mediaReqVo.setProductCode(productCode);
        PageResult<MdmProductMediaRespVo> page = this.mdmProductMediaService.findList(mediaReqVo);
        return page.getData();
    }

    public MdmProductMediaRespVo getMediaByProductCode(String productCode) {
        MdmProductMediaReqVo mediaReqVo = new MdmProductMediaReqVo();
        mediaReqVo.setProductCode(productCode);
        return this.mdmProductMediaService.query(mediaReqVo);
    }

    public MdmProductIntroductionRespVo findIntroductionByProductCode(String productCode) {
        MdmProductIntroductionEntity introductionEntity = (MdmProductIntroductionEntity)((Object)this.mdmProductIntroductionMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"product_code", (Object)productCode)));
        if (Objects.isNull((Object)introductionEntity)) {
            return null;
        }
        MdmProductIntroductionRespVo respVo = new MdmProductIntroductionRespVo();
        CrmBeanUtil.copyProperties((Object)((Object)introductionEntity), (Object)respVo);
        return respVo;
    }

    public LambdaQueryWrapper<MdmProductEntity> getProductQueryWrapper(MdmProductReqVo reqVo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.like(StringUtils.isNotEmpty((CharSequence)reqVo.getProductCode()), MdmProductEntity::getProductCode, (Object)reqVo.getProductCode());
        wrapper.like(StringUtils.isNotEmpty((CharSequence)reqVo.getProductCode()), MdmProductEntity::getProductName, (Object)reqVo.getProductName());
        wrapper.like(StringUtils.isNotEmpty((CharSequence)reqVo.getProductLevelCode()), MdmProductEntity::getProductLevelCode, (Object)reqVo.getProductLevelCode());
        return wrapper;
    }

    public void updateBySelectAll(MdmProductReqVo reqVo, MdmProductEntity entity) {
        LambdaQueryWrapper<MdmProductEntity> productQueryWrapper = this.getProductQueryWrapper(reqVo);
        this.mdmProductMapper.update((Object)entity, (Wrapper)productQueryWrapper);
    }

    public Map<String, MdmMaterialEntity> findMaterialMapByCodes(Set<String> materialCodes) {
        List mdmMaterialEntities = this.mdmMaterialMapper.selectList((Wrapper)new LambdaQueryWrapper().in(MdmMaterialEntity::getMaterialCode, materialCodes));
        LinkedHashMap map = Maps.newLinkedHashMap();
        mdmMaterialEntities.stream().filter(Objects::nonNull).forEach(o -> map.put(o.getMaterialCode(), o));
        return map;
    }
}

